/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.network;

import com.mjr.extraplanets.network.ExtraPlanetsPacketHandler;
import com.mjr.extraplanets.network.PacketSimple;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.EnumMap;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketControllableEntity;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.network.PacketDynamicInventory;
import micdoodle8.mods.galacticraft.core.network.PacketEntityUpdate;
import micdoodle8.mods.galacticraft.core.network.PacketRotateRocket;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.entity.player.EntityPlayerMP;

public class ExtraPlanetsChannelHandler
extends FMLIndexedMessageToMessageCodec<IPacket> {
    private EnumMap<Side, FMLEmbeddedChannel> channels;

    private ExtraPlanetsChannelHandler() {
        this.addDiscriminator(0, PacketSimple.class);
        this.addDiscriminator(1, PacketRotateRocket.class);
        this.addDiscriminator(2, PacketDynamic.class);
        this.addDiscriminator(3, PacketControllableEntity.class);
        this.addDiscriminator(4, PacketEntityUpdate.class);
        this.addDiscriminator(5, PacketDynamicInventory.class);
    }

    public static ExtraPlanetsChannelHandler init() {
        ExtraPlanetsChannelHandler channelHandler = new ExtraPlanetsChannelHandler();
        channelHandler.channels = NetworkRegistry.INSTANCE.newChannel("ExtraPlanets", new ChannelHandler[]{channelHandler, new ExtraPlanetsPacketHandler()});
        return channelHandler;
    }

    public void encodeInto(ChannelHandlerContext ctx, IPacket msg, ByteBuf target) throws Exception {
        msg.encodeInto(ctx, target);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, IPacket msg) {
        msg.decodeInto(ctx, source);
    }

    public void sendToAll(IPacket message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendTo(IPacket message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendToAllAround(IPacket message, NetworkRegistry.TargetPoint point) {
        try {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
        }
        catch (Exception e) {
            GCLog.severe((String)"Forge error when sending network packet to nearby players - this is not a Galacticraft bug, does another mod make fake players?");
            e.printStackTrace();
        }
    }

    public void sendToDimension(IPacket message, int dimensionId) {
        try {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
            this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
        }
        catch (Exception e) {
            GCLog.severe((String)"Forge error when sending network packet to all players in dimension - this is not a Galacticraft bug, does another mod make fake players?");
            e.printStackTrace();
        }
    }

    public void sendToServer(IPacket message) {
        if (FMLCommonHandler.instance().getSide() != Side.CLIENT) {
            return;
        }
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeOutbound(new Object[]{message});
    }
}

