/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.entities.monsters;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityCustomSlime
extends EntityLiving
implements IMob {
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private int slimeJumpDelay;

    public EntityCustomSlime(World p_i1742_1_) {
        super(p_i1742_1_);
        int i = 1 << this.field_70146_Z.nextInt(3);
        this.field_70129_M = 0.0f;
        this.slimeJumpDelay = this.field_70146_Z.nextInt(20) + 10;
        this.setSlimeSize(i);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(1));
    }

    protected void setSlimeSize(int p_70799_1_) {
        this.field_70180_af.func_75692_b(16, (Object)new Byte((byte)p_70799_1_));
        this.func_70105_a(0.6f * (float)p_70799_1_, 0.6f * (float)p_70799_1_);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV = p_70799_1_;
    }

    public int getSlimeSize() {
        return this.field_70180_af.func_75683_a(16);
    }

    protected String getSlimeParticle() {
        return "slime";
    }

    protected String getJumpSound() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    public void func_70071_h_() {
        int i;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && this.getSlimeSize() > 0) {
            this.field_70128_L = true;
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        boolean flag = this.field_70122_E;
        super.func_70071_h_();
        if (this.field_70122_E && !flag) {
            i = this.getSlimeSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                this.field_70170_p.func_72869_a(this.getSlimeParticle(), this.field_70165_t + (double)f2, this.field_70121_D.field_72338_b, this.field_70161_v + (double)f3, 0.0, 0.0, 0.0);
            }
            if (this.makesSoundOnLand()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && flag) {
            this.squishAmount = 1.0f;
        }
        this.alterSquishAmount();
        if (this.field_70170_p.field_72995_K) {
            i = this.getSlimeSize();
            this.func_70105_a(0.6f * (float)i, 0.6f * (float)i);
        }
    }

    protected void func_70626_be() {
        this.func_70623_bb();
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        if (entityplayer != null) {
            this.func_70625_a((Entity)entityplayer, 10.0f, 20.0f);
        }
        if (this.field_70122_E && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.getJumpDelay();
            if (entityplayer != null) {
                this.slimeJumpDelay /= 3;
            }
            this.field_70703_bu = true;
            if (this.makesSoundOnJump()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_70702_br = 1.0f - this.field_70146_Z.nextFloat() * 2.0f;
            this.field_70701_bs = 1 * this.getSlimeSize();
        } else {
            this.field_70703_bu = false;
            if (this.field_70122_E) {
                this.field_70701_bs = 0.0f;
                this.field_70702_br = 0.0f;
            }
        }
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    protected EntityCustomSlime createInstance() {
        return new EntityCustomSlime(this.field_70170_p);
    }

    public void func_70106_y() {
        int i = this.getSlimeSize();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntityCustomSlime entityslime = this.createInstance();
                entityslime.setSlimeSize(0);
                entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            }
        }
        super.func_70106_y();
    }

    public void func_70100_b_(EntityPlayer p_70100_1_) {
        if (this.canDamagePlayer()) {
            int i = this.getSlimeSize();
            if (this.func_70685_l((Entity)p_70100_1_) && this.func_70068_e((Entity)p_70100_1_) < 0.6 * (double)i * 0.6 * (double)i && p_70100_1_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength())) {
                this.func_85030_a("mob.attack", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    protected boolean canDamagePlayer() {
        return this.getSlimeSize() > 1;
    }

    protected int getAttackStrength() {
        return this.getSlimeSize();
    }

    protected String func_70621_aR() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected String func_70673_aS() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected Item func_146068_u() {
        return this.getSlimeSize() == 1 ? Items.field_151123_aH : Item.func_150899_d((int)0);
    }

    protected float func_70599_aP() {
        return 0.4f * (float)this.getSlimeSize();
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return this.getSlimeSize() > 0;
    }

    protected boolean makesSoundOnLand() {
        return this.getSlimeSize() > 2;
    }
}

