/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.texture;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class TextureMultiIcon
extends TextureAtlasSprite {
    public int grid_x;
    public int grid_y;
    public int grid_w;
    public int grid_h;
    public String field_110984_i;
    boolean successfullyLoad = false;

    public TextureMultiIcon(String par1Str, int grid_x, int grid_y, int grid_w, int grid_h) {
        super(par1Str + "_" + grid_x + "_" + grid_y);
        this.field_110984_i = par1Str;
        if (this.field_110984_i.contains(":")) {
            this.field_110984_i = this.field_110984_i.substring(1 + this.field_110984_i.indexOf(":"), this.field_110984_i.length());
        }
        this.grid_x = grid_x;
        this.grid_y = grid_y;
        this.grid_w = grid_w;
        this.grid_h = grid_h;
    }

    public static IIcon registerGridIcon(IIconRegister register, String texture, int grid_x, int grid_y, int w, int h) {
        String entry2 = texture + "_" + grid_x + "_" + grid_y;
        TextureAtlasSprite result = ((TextureMap)register).getTextureExtry(entry2);
        if (result == null) {
            result = new TextureMultiIcon(texture, grid_x, grid_y, w, h);
            ((TextureMap)register).setTextureEntry(result.func_94215_i(), result);
        }
        return result;
    }

    public boolean func_130098_m() {
        return false;
    }

    public int[][] func_147965_a(int par1) {
        return (int[][])this.field_110976_a.get(par1);
    }

    public void func_147964_a(BufferedImage[] p_147964_1_, AnimationMetadataSection p_147964_2_, boolean p_147964_3_) {
        throw new RuntimeException("Likely Optifine error. TextureAtlasSprite.loadSprite(BufferedImage[] p_147964_1_, AnimationMetadataSection p_147964_2_, boolean p_147964_3_) called after TextureAtlasSprite.load(IResourceManager manager, ResourceLocation location) returned false (which is the correct return value for successful loading).\nThis is not supposed to happen and will result in a missing texture.\nThis is likely an Optifine error.");
    }

    public void func_94217_a(TextureAtlasSprite par1TextureAtlasSprite) {
        if (this.successfullyLoad) {
            if ("missingno".equals(par1TextureAtlasSprite.func_94215_i())) {
                throw new RuntimeException("Likely Optifine error. Please only report if it occurs without Optifine installed:\nA Sprite with custom loading was not placed in the texture sheet despite TextureMultiIcon.load(IResourceManager manager, ResourceLocation location) completing successfully and returning false (which is the correct return value for successful loading).\nThis should not happen.");
            }
        } else {
            super.func_94217_a(par1TextureAtlasSprite);
        }
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        String altPath = "textures/blocks/" + this.field_110984_i + ".png";
        if (!(this.field_110984_i + "_" + this.grid_x + "_" + this.grid_y).equals(location.func_110623_a())) {
            throw new RuntimeException("Likely Optifine error. Please only report if it occurs without Optifine installed:\nTextureAtlasSprite.load(IResourceManager manager, ResourceLocation location) called with bad parameters.\nExpected resource path " + this.field_110984_i + "_" + this.grid_x + "_" + this.grid_y + ", recieved " + location.func_110623_a() + ".\n");
        }
        ResourceLocation altLocation = new ResourceLocation(location.func_110624_b(), altPath);
        try {
            this.altLoadSprite(manager.func_110536_a(altLocation));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.successfullyLoad = false;
            return true;
        }
        this.successfullyLoad = true;
        return false;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public void altLoadSprite(IResource par1Resource) throws IOException {
        this.func_110968_a(Lists.newArrayList());
        this.field_110973_g = 0;
        this.field_110983_h = 0;
        InputStream inputstream = par1Resource.func_110527_b();
        BufferedImage bufferedimage = ImageIO.read(inputstream);
        this.field_130224_d = bufferedimage.getHeight() / this.grid_h;
        this.field_130223_c = bufferedimage.getWidth() / this.grid_w;
        if (this.field_130224_d < this.grid_h || this.field_130223_c < this.grid_w) {
            throw new RuntimeException("Texture too small, must be at least " + this.grid_w + " pixels wide and " + this.grid_h + " pixels tall");
        }
        if (this.grid_x < 0 || this.grid_x >= this.grid_w) {
            throw new RuntimeException("GridTextureIcon called with an invalid grid_x");
        }
        if (this.grid_y < 0 || this.grid_y >= this.grid_h) {
            throw new RuntimeException("GridTextureIcon called with an invalid grid_y");
        }
        int[] aint = new int[this.field_130224_d * this.field_130223_c];
        bufferedimage.getRGB(this.grid_x * this.field_130223_c, this.grid_y * this.field_130224_d, this.field_130223_c, this.field_130224_d, aint, 0, this.field_130223_c);
        if (this.field_130224_d != this.field_130223_c) {
            throw new RuntimeException("broken aspect ratio, must be in ratio: " + this.grid_w + ":" + this.grid_h);
        }
        this.field_110976_a.add(this.prepareAnisotropicFiltering(aint, this.field_130223_c, this.field_130224_d, Minecraft.func_71410_x().field_71474_y.field_151442_I, (float)Minecraft.func_71410_x().field_71474_y.field_151443_J > 1.0f));
    }

    private int[][] prepareAnisotropicFiltering(int[] p_147960_1_, int p_147960_2_, int p_147960_3_, int mipMap, boolean useAnisotropicFiltering) {
        int[][] aint1 = new int[mipMap + 1][];
        aint1[0] = p_147960_1_;
        return aint1;
    }
}

