/*
 * Decompiled with CFR 0.152.
 */
package extracells.util;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import extracells.api.gas.IAEGasStack;
import extracells.integration.mekanism.gas.MekanismGas;
import extracells.util.FluidHelper;
import extracells.util.StorageChannels;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.MutablePair;

public class GasUtil {
    public static IAEFluidStack createAEFluidStack(Gas gas) {
        return GasUtil.createAEFluidStack(new FluidStack(MekanismGas.getFluidGasMap().get(gas), 1000));
    }

    public static IAEFluidStack createAEFluidStack(GasStack gasStack) {
        return gasStack == null ? null : GasUtil.createAEFluidStack(new FluidStack(MekanismGas.getFluidGasMap().get(gasStack.getGas()), gasStack.amount));
    }

    public static IAEFluidStack createAEFluidStack(FluidStack fluid) {
        return (IAEFluidStack)StorageChannels.FLUID().createStack((Object)fluid);
    }

    public static IAEFluidStack createAEFluidStack(Gas gas, long amount) {
        return (IAEFluidStack)GasUtil.createAEFluidStack(new FluidStack(MekanismGas.getFluidGasMap().get(gas), 1)).setStackSize(amount);
    }

    public static IAEFluidStack createAEFluidStack(IAEGasStack gasStack) {
        if (gasStack == null || gasStack.getGas() == null) {
            return null;
        }
        return (IAEFluidStack)GasUtil.createAEFluidStack((Gas)gasStack.getGas()).setStackSize(gasStack.getStackSize());
    }

    public static IAEGasStack createAEGasStack(Gas gas) {
        return (IAEGasStack)StorageChannels.GAS().createStack(gas);
    }

    public static IAEGasStack createAEGasStack(GasStack gasStack) {
        return (IAEGasStack)StorageChannels.GAS().createStack(gasStack);
    }

    public static IAEGasStack createAEGasStack(Gas gas, long amount) {
        return (IAEGasStack)GasUtil.createAEGasStack(gas).setStackSize(amount);
    }

    public static IAEGasStack createAEGasStack(IAEFluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null || !GasUtil.isGas(fluidStack.getFluid())) {
            return null;
        }
        return (IAEGasStack)GasUtil.createAEGasStack(GasUtil.getGas(fluidStack.getFluid())).setStackSize(fluidStack.getStackSize());
    }

    public static IItemList<IAEGasStack> createAEGasItemList(IItemList<IAEFluidStack> fluidStacks) {
        IItemList out = StorageChannels.GAS().createList();
        for (IAEFluidStack fluid : fluidStacks) {
            out.add((IAEStack)GasUtil.createAEGasStack(fluid));
        }
        return out;
    }

    public static IItemList<IAEFluidStack> createAEFluidItemList(IItemList<IAEGasStack> fluidStacks) {
        IItemList out = StorageChannels.FLUID().createList();
        for (IAEGasStack gas : fluidStacks) {
            out.add((IAEStack)GasUtil.createAEFluidStack(gas));
        }
        return out;
    }

    public static MutablePair<Integer, ItemStack> drainStack(ItemStack itemStack, GasStack gas) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IGasItem) {
            GasStack drained = ((IGasItem)item).removeGas(itemStack, gas.amount);
            int amountDrained = drained != null && drained.getGas() == gas.getGas() ? drained.amount : 0;
            return new MutablePair((Object)amountDrained, (Object)itemStack);
        }
        return null;
    }

    public static MutablePair<Integer, ItemStack> fillStack(ItemStack itemStack, GasStack gas) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IGasItem) {
            int filled = ((IGasItem)item).addGas(itemStack, gas);
            return new MutablePair((Object)filled, (Object)itemStack);
        }
        return null;
    }

    public static int getCapacity(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IGasItem) {
            return ((IGasItem)item).getMaxGas(itemStack);
        }
        return 0;
    }

    public static GasStack getGasFromContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemStack container = itemStack.func_77946_l();
        Item item = container.func_77973_b();
        if (item instanceof IGasItem) {
            return ((IGasItem)item).getGas(itemStack);
        }
        return null;
    }

    public static boolean isEmpty(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IGasItem) {
            GasStack content = ((IGasItem)item).getGas(itemStack);
            return content == null || content.amount <= 0;
        }
        return false;
    }

    public static boolean isFilled(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IGasItem) {
            GasStack content = ((IGasItem)item).getGas(itemStack);
            return content != null && content.amount > 0;
        }
        return FluidHelper.isFilled(itemStack);
    }

    public static boolean isGasContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return item instanceof IGasItem;
    }

    public static GasStack getGasStack(FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid instanceof MekanismGas.GasFluid) {
            return new GasStack(((MekanismGas.GasFluid)fluid).getGas(), fluidStack.amount);
        }
        return null;
    }

    public static GasStack getGasStack(IAEFluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid instanceof MekanismGas.GasFluid) {
            return new GasStack(((MekanismGas.GasFluid)fluid).getGas(), (int)fluidStack.getStackSize());
        }
        return null;
    }

    public static FluidStack getFluidStack(GasStack gasStack) {
        if (gasStack == null) {
            return null;
        }
        Fluid fluid = MekanismGas.getFluidGasMap().get(gasStack.getGas());
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, gasStack.amount);
    }

    public static boolean isGas(FluidStack fluidStack) {
        return fluidStack != null && GasUtil.isGas(fluidStack.getFluid());
    }

    public static boolean isGas(Fluid fluid) {
        return fluid != null && fluid instanceof MekanismGas.GasFluid;
    }

    public static Gas getGas(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        if (fluid instanceof MekanismGas.GasFluid) {
            return ((MekanismGas.GasFluid)fluid).getGas();
        }
        return null;
    }
}

