/*
 * Decompiled with CFR 0.152.
 */
package extracells.part.fluid;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import com.google.common.collect.ImmutableList;
import extracells.container.ContainerPlaneFormation;
import extracells.container.IUpgradeable;
import extracells.gridblock.ECBaseGridBlock;
import extracells.gui.fluid.GuiFluidPlaneFormation;
import extracells.gui.widget.fluid.IFluidSlotListener;
import extracells.inventory.InventoryPlain;
import extracells.inventory.UpgradeInventorySingle;
import extracells.models.PartModels;
import extracells.network.packet.other.PacketFluidSlotUpdate;
import extracells.part.PartECBase;
import extracells.util.AEUtils;
import extracells.util.MachineSource;
import extracells.util.NetworkUtil;
import extracells.util.PermissionUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class PartFluidPlaneFormation
extends PartECBase
implements IFluidSlotListener,
IGridTickable,
IUpgradeable {
    private Fluid fluid;
    private InventoryPlain upgradeInventory = new UpgradeInventorySingle(AEApi.instance().definitions().materials().cardRedstone());

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack stack : this.upgradeInventory.slots) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    public float getCableConnectionLength(AECableType aeCableType) {
        return 2.0f;
    }

    public void doWork() {
        BlockPos pos;
        TileEntity hostTile = this.getHostTile();
        ECBaseGridBlock gridBlock = this.getGridBlock();
        EnumFacing facing = this.getFacing();
        if (this.fluid == null || hostTile == null || gridBlock == null || this.fluid.getBlock() == null) {
            return;
        }
        IMEMonitor<IAEFluidStack> monitor = gridBlock.getFluidMonitor();
        if (monitor == null) {
            return;
        }
        World world = hostTile.func_145831_w();
        IBlockState blockState = world.func_180495_p(pos = hostTile.func_174877_v().func_177972_a(facing));
        Block worldBlock = blockState.func_177230_c();
        if (worldBlock == null || !worldBlock.isAir(blockState, (IBlockAccess)world, pos)) {
            return;
        }
        IAEFluidStack fluidStack = AEUtils.createFluidStack(this.fluid, 1000L);
        IAEFluidStack canDrain = (IAEFluidStack)monitor.extractItems((IAEStack)fluidStack, Actionable.SIMULATE, (IActionSource)new MachineSource(this));
        if (canDrain == null || canDrain.getStackSize() < 1000L) {
            return;
        }
        monitor.extractItems((IAEStack)fluidStack, Actionable.MODULATE, (IActionSource)new MachineSource(this));
        Block fluidWorldBlock = this.fluid.getBlock();
        world.func_175656_a(pos, fluidWorldBlock.func_176223_P());
        world.func_184138_a(pos, fluidWorldBlock.func_176223_P(), fluidWorldBlock.func_176223_P(), 0);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiFluidPlaneFormation(this, player);
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerPlaneFormation(this, player);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, false);
    }

    @Override
    public InventoryPlain getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, hand, pos);
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.fluid = FluidRegistry.getFluid((String)data.func_74779_i("fluid"));
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return PartModels.FORMATION_PLANE_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return PartModels.FORMATION_PLANE_ON;
        }
        return PartModels.FORMATION_PLANE_OFF;
    }

    public void sendInformation(EntityPlayer player) {
        NetworkUtil.sendToPlayer(new PacketFluidSlotUpdate((List<Fluid>)ImmutableList.of((Object)this.fluid)), player);
    }

    @Override
    public void setFluid(int index, Fluid fluid, EntityPlayer player) {
        this.fluid = fluid;
        NetworkUtil.sendToPlayer(new PacketFluidSlotUpdate((List<Fluid>)ImmutableList.of((Object)this.fluid)), player);
        this.saveData();
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        this.doWork();
        return TickRateModulation.SAME;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.func_74778_a("fluid", this.fluid == null ? "" : this.fluid.getName());
    }
}

