/*
 * Decompiled with CFR 0.152.
 */
package extracells.part.fluid;

import appeng.api.AEApi;
import appeng.api.config.RedstoneMode;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import extracells.container.IUpgradeable;
import extracells.container.fluid.ContainerBusFluidIO;
import extracells.gui.fluid.GuiBusFluidIO;
import extracells.gui.widget.fluid.IFluidSlotListener;
import extracells.inventory.IInventoryListener;
import extracells.inventory.InventoryPlain;
import extracells.inventory.UpgradeInventory;
import extracells.network.packet.other.PacketFluidSlotUpdate;
import extracells.network.packet.part.PacketPartConfig;
import extracells.part.PartECBase;
import extracells.util.NetworkUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class PartFluidIO
extends PartECBase
implements IGridTickable,
IInventoryListener,
IFluidSlotListener,
IUpgradeable {
    public final Fluid[] filterFluids = new Fluid[9];
    private final UpgradeInventory upgradeInventory = new UpgradeInventory(this){

        @Override
        protected void onContentsChanged() {
            PartFluidIO.this.saveData();
        }
    };
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    protected byte filterSize;
    protected byte speedState;
    protected boolean redstoneControlled;

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack stack : this.upgradeInventory.slots) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        ItemStack stack = super.getItemStack(type);
        if (type.equals((Object)PartItemStack.WRENCH)) {
            stack.func_77978_p().func_82580_o("upgradeInventory");
        }
        return stack;
    }

    public float getCableConnectionLength(AECableType aeCableType) {
        return 5.0f;
    }

    private boolean canDoWork() {
        boolean redstonePowered = this.isRedstonePowered();
        if (!this.redstoneControlled) {
            return true;
        }
        switch (this.getRedstoneMode()) {
            case IGNORE: {
                return true;
            }
            case LOW_SIGNAL: {
                return !redstonePowered;
            }
            case HIGH_SIGNAL: {
                return redstonePowered;
            }
            case SIGNAL_PULSE: {
                return false;
            }
        }
        return false;
    }

    public byte getSpeedState() {
        return this.speedState;
    }

    public abstract boolean doWork(int var1, int var2);

    @Override
    public abstract void getBoxes(IPartCollisionHelper var1);

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiBusFluidIO(this, player);
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerBusFluidIO(this, player);
    }

    public final TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, false);
    }

    @Override
    public InventoryPlain getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public List<String> getWailaBodey(NBTTagCompound tag, List<String> oldList) {
        if (tag.func_74764_b("speed")) {
            oldList.add(tag.func_74762_e("speed") + "mB/t");
        } else {
            oldList.add("125mB/t");
        }
        return oldList;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        tag.func_74768_a("speed", 125 + this.speedState * 125);
        return tag;
    }

    public void loopRedstoneMode(EntityPlayer player) {
        this.redstoneMode = this.redstoneMode.ordinal() + 1 < RedstoneMode.values().length ? RedstoneMode.values()[this.redstoneMode.ordinal() + 1] : RedstoneMode.values()[0];
        NetworkUtil.sendToPlayer(new PacketPartConfig(this, "FluidIO.Redstone.Mode", this.redstoneMode.toString()), player);
        this.saveData();
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand enumHand, Vec3d pos) {
        boolean activate = super.onActivate(player, enumHand, pos);
        this.onInventoryChanged();
        return activate;
    }

    public List<Fluid> getActiveFilters() {
        int i;
        ArrayList<Fluid> filter = new ArrayList<Fluid>();
        filter.add(this.filterFluids[4]);
        if (this.filterSize >= 1) {
            for (i = 1; i < 9; i = (int)((byte)(i + 2))) {
                if (i == 4) continue;
                filter.add(this.filterFluids[i]);
            }
        }
        if (this.filterSize >= 2) {
            for (i = 0; i < 9; i = (int)((byte)(i + 2))) {
                if (i == 4) continue;
                filter.add(this.filterFluids[i]);
            }
        }
        return filter;
    }

    @Override
    public void onInventoryChanged() {
        this.filterSize = 0;
        this.redstoneControlled = false;
        this.speedState = 0;
        for (int i = 0; i < this.upgradeInventory.func_70302_i_(); ++i) {
            ItemStack currentStack = this.upgradeInventory.func_70301_a(i);
            if (currentStack == null) continue;
            if (AEApi.instance().definitions().materials().cardCapacity().isSameAs(currentStack)) {
                this.filterSize = (byte)(this.filterSize + 1);
            }
            if (AEApi.instance().definitions().materials().cardRedstone().isSameAs(currentStack)) {
                this.redstoneControlled = true;
            }
            if (!AEApi.instance().definitions().materials().cardSpeed().isSameAs(currentStack)) continue;
            this.speedState = (byte)(this.speedState + 1);
        }
        IPartHost host = this.getHost();
        DimensionalCoord coord = this.getLocation();
        if (host == null || coord == null || coord.getWorld() == null || coord.getWorld().field_72995_K) {
            return;
        }
        NetworkUtil.sendNetworkPacket(new PacketPartConfig(this, "FluidIO.Filter", Byte.toString(this.filterSize)), coord.getPos(), coord.getWorld());
        NetworkUtil.sendNetworkPacket(new PacketPartConfig(this, "FluidIO.Redstone", Boolean.toString(this.redstoneControlled)), coord.getPos(), coord.getWorld());
        this.saveData();
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
    }

    @Override
    public final void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.redstoneMode = RedstoneMode.values()[data.func_74762_e("redstoneMode")];
        for (int i = 0; i < 9; ++i) {
            this.filterFluids[i] = FluidRegistry.getFluid((String)data.func_74779_i("FilterFluid#" + i));
        }
        this.upgradeInventory.readFromNBT(data.func_150295_c("upgradeInventory", 10));
        this.onInventoryChanged();
    }

    @Override
    public final boolean readFromStream(ByteBuf data) throws IOException {
        return super.readFromStream(data);
    }

    public void sendInformation(EntityPlayer player) {
        NetworkUtil.sendToPlayer(new PacketFluidSlotUpdate(Arrays.asList(this.filterFluids)), player);
        NetworkUtil.sendToPlayer(new PacketPartConfig(this, "FluidIO.Filter", Byte.toString(this.filterSize)), player);
        NetworkUtil.sendToPlayer(new PacketPartConfig(this, "FluidIO.Redstone", Boolean.toString(this.redstoneControlled)), player);
        NetworkUtil.sendToPlayer(new PacketPartConfig(this, "FluidIO.Redstone.Mode", this.redstoneMode.toString()), player);
    }

    @Override
    public final void setFluid(int index, Fluid fluid, EntityPlayer player) {
        this.filterFluids[index] = fluid;
        NetworkUtil.sendToPlayer(new PacketFluidSlotUpdate(Arrays.asList(this.filterFluids)), player);
        this.saveData();
    }

    @Override
    public void setPartHostInfo(AEPartLocation location, IPartHost iPartHost, TileEntity tileEntity) {
        super.setPartHostInfo(location, iPartHost, tileEntity);
        this.onInventoryChanged();
    }

    public final TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.canDoWork()) {
            return this.doWork(125 + this.speedState * 125, TicksSinceLastCall) ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        }
        return TickRateModulation.SLOWER;
    }

    @Override
    public final void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("redstoneMode", this.redstoneMode.ordinal());
        for (int i = 0; i < this.filterFluids.length; ++i) {
            Fluid fluid = this.filterFluids[i];
            if (fluid != null) {
                data.func_74778_a("FilterFluid#" + i, fluid.getName());
                continue;
            }
            data.func_74778_a("FilterFluid#" + i, "");
        }
        data.func_74782_a("upgradeInventory", (NBTBase)this.upgradeInventory.writeToNBT());
    }

    @Override
    public final void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
    }
}

