#version 120

/* Sildur's basic shaders */
/* read the permission in my thread before editing, thank you */

/*--------------------
//ADJUSTABLE VARIABLES//
---------------------*/

//#define BLOOM							//Will lower the fps
#ifdef BLOOM
	const float BLOOM_AMOUNT = 4; 		//Strengh of Bloom	
#endif

/*---------------------------
//END OF ADJUSTABLE VARIABLES//
----------------------------*/

uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D gnormal;
uniform sampler2D composite;
uniform vec3 sunPosition;
uniform float worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;


varying vec4 texcoord;

void main() {
	vec4 color = texture2D(composite, texcoord.st);
	
#ifdef BLOOM
	int j;
	int i;
	vec4 sum = vec4(0);
        float count = 0;
    for( i= -4 ;i < 4; i++) {
        for (j = -3; j < 3; j++) {
            vec2 coord = texcoord.st + vec2(j,i) * 0.004;
                if(coord.x > 0 && coord.x < 1 && coord.y > 0 && coord.y < 1){
                    sum += texture2D(composite, coord) * BLOOM_AMOUNT;
                    count += 1;
                }
            }
    }
    sum = sum / vec4(count);
	if (color.r < 0.3)
	{
		color += sum*sum*0.012;
	}
	else
	{
		if (color.r < 0.5)
		{
			color += sum*sum*0.009;
		}
		else
		{
			color += sum*sum*0.0075;
		}
	}
#endif	
	
	color.r = (color.r*1.34)+(color.b+color.g)*(-0.1);
    color.g = (color.g*1.2)+(color.r+color.b)*(-0.1);
    color.b = (color.b*1.1)+(color.r+color.g)*(-0.1);
	color = color / (color + 2.2) * (1.0+2.0);

	gl_FragColor = color;	
}