#version 120
/* DRAWBUFFERS:0 */
/*
                            _____ _____ ___________ 
                           /  ___|_   _|  _  | ___ \
                           \ `--.  | | | | | | |_/ /
                            `--. \ | | | | | |  __/ 
                           /\__/ / | | \ \_/ / |    
                           \____/  \_/  \___/\_|    

						Before editing anything here make sure you've 
						read The agreement, which you accepted by downloading
						my shaderpack. The agreement can be found here:
			http://www.minecraftforum.net/topic/1953873-164-172-sildurs-shaders-pcmacintel/
						   
						Sildur's shaders, derived from Chocapic's shaders */
						
//Shadows
const bool Shadows = true;			
#define SHADOW_MAP_BIAS 0.86			
const int shadowMapResolution = 1024;		//Shadows resolution. [512 1024 2048 3072 4096 8192]
const float shadowDistance = 90;			//Draw distance of shadows.[60 90 120 150 180 210]
const bool 	shadowHardwareFiltering0 = true;
//------------------------------------------

const int noiseTextureResolution  = 512;
const float	sunPathRotation	= 0.0f;		//[0.0f -40.0f]
varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

varying vec4 ambientColor;

uniform sampler2D texture;
uniform sampler2D lightmap;
uniform sampler2DShadow shadow;

uniform float viewWidth;
uniform float viewHeight;
uniform ivec2 eyeBrightness;

varying float mat;
varying float lblocks;
float diffuse = ambientColor.a;

//Default fog
const int GL_LINEAR = 9729;
const int GL_EXP = 2048;
uniform int fogMode;

/* If you reached this line, then you're probably about to break the agreement which you accepted by downloading Sildur's shaders!
So stop your doing and ask Sildur before copying anything which would break the agreement, unless you're Chocapic then go ahead ;)
--------------------------------------------------------------------------------------------------------------------------------*/ 

void main() {

//Shadows
float shading = 0.0;
vec4 fragposition = gbufferProjectionInverse*(vec4(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z,1.0)*2.0-1.0);
fragposition /= fragposition.w;
	
if (Shadows){
	vec4 worldposition = gbufferModelViewInverse * vec4(fragposition);
	
	worldposition = shadowModelView * worldposition;
	worldposition = shadowProjection * worldposition;
	worldposition /= worldposition.w;
	float distb = length(worldposition.st);
	float distortFactor = mix(1.0,distb,SHADOW_MAP_BIAS);
	worldposition.xy /= distortFactor; 
	
	float diffthresh = distortFactor*distortFactor*(0.0097297*tan(acos(diffuse)) + 0.01729729729);
	diffthresh = mix(diffthresh,0.0007,mat);
	const float halfres = (0.5/shadowMapResolution);
	float offset = ((mat)*halfres+halfres);
	
	worldposition = worldposition * 0.5f + vec4(0.5,0.5,0.5-diffthresh,0.5);
	
	if (max(abs(worldposition.x-0.5),abs(worldposition.y-0.5)) < 0.48) {
	if(eyeBrightness.y < 2)shading = 0.0;
	else shading = dot(vec4(shadow2D(shadow,vec3(worldposition.st + vec2(offset,offset), worldposition.z)).x,shadow2D(shadow,vec3(worldposition.st + vec2(-offset,offset), worldposition.z)).x,shadow2D(shadow,vec3(worldposition.st + vec2(offset,-offset), worldposition.z)).x,shadow2D(shadow,vec3(worldposition.st + vec2(-offset,-offset), worldposition.z)).x),vec4(diffuse)*0.25);
	}
}
	//Colors
	vec4 tex = texture2D(texture, texcoord.st) * texture2D(lightmap, lmcoord.st) * color;
	vec3 mixcolors = (1.5+shading+ambientColor.rgb)*tex.rgb/3.0;
//-----------------------------------------------------------------------------------
	
	if(lblocks > 0.9)gl_FragData[0] = tex;
	else gl_FragData[0] = vec4(mixcolors,tex.a);
	
	//Default fog
	if (fogMode == GL_EXP) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, 1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
	} else if (fogMode == GL_LINEAR) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));
	}

}