/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.detail.TreeCutting;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.blocks.StandardEntityBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Overlay;

public class EdTreeCutter {
    public static void on_config(int boost_energy_per_tick, int cutting_time_seconds, boolean power_required) {
        TreeCutterTileEntity.on_config(boost_energy_per_tick, cutting_time_seconds, power_required);
    }

    public static class TreeCutterTileEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements IEnergyStorage {
        public static final int IDLE_TICK_INTERVAL = 40;
        public static final int TICK_INTERVAL = 5;
        public static final int BOOST_FACTOR = 6;
        public static final int DEFAULT_BOOST_ENERGY = 64;
        public static final int DEFAULT_CUTTING_TIME_NEEDED = 60;
        private static int boost_energy_consumption = 64;
        private static int energy_max = 1280;
        private static int cutting_time_needed = 1200;
        private static boolean requires_power = false;
        private int tick_timer_;
        private int active_timer_;
        private int proc_time_elapsed_;
        private int energy_;
        protected LazyOptional<IEnergyStorage> energy_handler_ = LazyOptional.of(() -> this);

        public static void on_config(int boost_energy_per_tick, int cutting_time_seconds, boolean power_required) {
            boost_energy_consumption = 5 * Mth.m_14045_((int)boost_energy_per_tick, (int)4, (int)4096);
            energy_max = Math.max(boost_energy_consumption * 10, 10000);
            cutting_time_needed = 20 * Mth.m_14045_((int)cutting_time_seconds, (int)10, (int)240);
            requires_power = power_required;
            ModConfig.log("Config tree cutter: energy consumption:" + boost_energy_consumption / 5 + "rf/t" + (requires_power ? " (power required for operation) " : "") + ", cutting time:" + cutting_time_needed + "t.");
        }

        public TreeCutterTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.getBlockEntityTypeOfBlock(state.m_60734_().getRegistryName().m_135815_()), pos, state);
        }

        public void readnbt(CompoundTag nbt) {
            this.energy_ = nbt.m_128451_("energy");
        }

        private void writenbt(CompoundTag nbt) {
            nbt.m_128405_("energy", this.energy_);
        }

        public void state_message(Player player) {
            String progress = "0";
            if (this.active_timer_ > 0 && cutting_time_needed > 0 && this.active_timer_ > 0) {
                progress = Integer.toString((int)Mth.m_14008_((double)((double)this.proc_time_elapsed_ / (double)cutting_time_needed * 100.0), (double)0.0, (double)100.0));
            }
            String soc = Integer.toString(Mth.m_14045_((int)(this.energy_ * 100 / energy_max), (int)0, (int)100));
            Overlay.show(player, (Component)Auxiliaries.localizable("block.engineersdecor.small_tree_cutter.status", soc, energy_max, progress, cutting_time_needed / 20));
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt);
        }

        public void m_7651_() {
            super.m_7651_();
            this.energy_handler_.invalidate();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            return boost_energy_consumption * 2;
        }

        public int getEnergyStored() {
            return this.energy_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            maxReceive = Mth.m_14045_((int)maxReceive, (int)0, (int)Math.max(energy_max - this.energy_, 0));
            if (!simulate) {
                this.energy_ += maxReceive;
            }
            return maxReceive;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        @Override
        public void tick() {
            boolean active;
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 5;
            BlockState device_state = this.f_58857_.m_8055_(this.f_58858_);
            if (!(device_state.m_60734_() instanceof TreeCutterBlock)) {
                return;
            }
            BlockPos tree_pos = this.f_58858_.m_142300_((Direction)device_state.m_61143_((Property)TreeCutterBlock.HORIZONTAL_FACING));
            BlockState tree_state = this.f_58857_.m_8055_(tree_pos);
            if (!TreeCutting.canChop(tree_state) || this.f_58857_.m_46753_(this.f_58858_)) {
                if (((Boolean)device_state.m_61143_((Property)TreeCutterBlock.ACTIVE)).booleanValue()) {
                    this.f_58857_.m_7731_(this.f_58858_, (BlockState)device_state.m_61124_((Property)TreeCutterBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                }
                this.proc_time_elapsed_ = 0;
                this.active_timer_ = 0;
                this.tick_timer_ = 40;
                return;
            }
            this.proc_time_elapsed_ += 5;
            if (this.energy_ >= boost_energy_consumption) {
                this.energy_ -= boost_energy_consumption;
                this.proc_time_elapsed_ += 30;
                this.active_timer_ = 2;
            } else if (!requires_power) {
                this.active_timer_ = 1024;
            } else if (this.active_timer_ > 0) {
                --this.active_timer_;
            }
            boolean bl = active = this.active_timer_ > 0;
            if (requires_power && !active) {
                this.proc_time_elapsed_ = Math.max(0, this.proc_time_elapsed_ - 10);
            }
            if (this.proc_time_elapsed_ >= cutting_time_needed) {
                this.proc_time_elapsed_ = 0;
                TreeCutting.chopTree(this.f_58857_, tree_state, tree_pos, 512, false);
                this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_12630_, SoundSource.BLOCKS, 1.0f, 1.0f);
                active = false;
            }
            if ((Boolean)device_state.m_61143_((Property)TreeCutterBlock.ACTIVE) != active) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)device_state.m_61124_((Property)TreeCutterBlock.ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
            }
        }
    }

    public static class TreeCutterBlock
    extends StandardBlocks.Horizontal
    implements StandardEntityBlocks.IStandardEntityBlock<TreeCutterTileEntity> {
        public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

        public TreeCutterBlock(long config, BlockBehaviour.Properties builder, AABB[] unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        public ResourceLocation getBlockRegistryName() {
            return this.getRegistryName();
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return true;
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{ACTIVE});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return (BlockState)super.m_5573_(context).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7100_(BlockState state, Level world, BlockPos pos, Random rnd) {
            if (state.m_60734_() != this || !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                return;
            }
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12634_, SoundSource.BLOCKS, 0.1f, 1.0f, false);
            double rv = rnd.nextDouble();
            if (rv < 0.8) {
                double x = 0.5 + (double)pos.m_123341_();
                double y = 0.5 + (double)pos.m_123342_();
                double z = 0.5 + (double)pos.m_123343_();
                double xc = 0.52;
                double xr = rnd.nextDouble() * 0.4 - 0.2;
                double yr = y - 0.3 + rnd.nextDouble() * 0.2;
                switch ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)) {
                    case WEST: {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x - 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                        break;
                    }
                    case EAST: {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                        break;
                    }
                    case NORTH: {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xr, yr, z - 0.52, 0.0, 0.0, 0.0);
                        break;
                    }
                    default: {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xr, yr, z + 0.52, 0.0, 0.0, 0.0);
                    }
                }
            }
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof TreeCutterTileEntity) {
                ((TreeCutterTileEntity)te).state_message(player);
            }
            return InteractionResult.CONSUME;
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }
    }
}

