/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity;

import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.loot.EntityLootHelper;
import crazypants.enderio.zoo.config.ZooConfig;
import crazypants.enderio.zoo.entity.EntityUtil;
import crazypants.enderio.zoo.entity.EntityWitherWitch;
import crazypants.enderio.zoo.entity.IEnderZooEntity;
import crazypants.enderio.zoo.entity.IOwnable;
import crazypants.enderio.zoo.entity.ai.EntityAIAttackOnCollideOwned;
import crazypants.enderio.zoo.entity.ai.EntityAIFollowOwner;
import crazypants.enderio.zoo.entity.render.RenderWitherCat;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderiozoo")
public class EntityWitherCat
extends EntityMob
implements IOwnable<EntityWitherCat, EntityWitherWitch>,
IEnderZooEntity {
    @Nonnull
    public static final String NAME = "withercat";
    public static final int EGG_BG_COL = 0x303030;
    public static final int EGG_FG_COL = 0xFFFFFF;
    private static final float DEF_HEIGHT = 0.8f;
    private static final float DEF_WIDTH = 0.6f;
    @Nonnull
    private static final DataParameter<Float> SCALE_INDEX = EntityDataManager.func_187226_a(EntityWitherCat.class, (DataSerializer)DataSerializers.field_187193_c);
    @Nonnull
    private static final DataParameter<Integer> GROWTH_MODE_INDEX = EntityDataManager.func_187226_a(EntityWitherCat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final float ANGRY_SCALE = 2.0f;
    private static final float SCALE_INC = 0.05f;
    @Nonnull
    private static final UUID ATTACK_BOOST_MOD_UID = UUID.fromString("B9662B59-9566-4402-BC1F-2ED2B276D846");
    @Nonnull
    private static final UUID HEALTH_BOOST_MOD_UID = UUID.fromString("B9662B29-9467-3302-1D1A-2ED2B276D846");
    private float lastScale = 1.0f;
    private EntityWitherWitch owner;
    @Nonnull
    private final EntityAIFollowOwner followTask = new EntityAIFollowOwner(this, 2.5, 5.0, 1.0);
    private boolean attackTargetChanged = false;

    @SubscribeEvent
    public static void onEntityRegister(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        IEnderZooEntity.register(event, NAME, EntityWitherCat.class, 0x303030, 0xFFFFFF, IEnderZooEntity.MobID.WCAT);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("enderio", NAME));
        RenderingRegistry.registerEntityRenderingHandler(EntityWitherCat.class, (IRenderFactory)RenderWitherCat.FACTORY);
    }

    public EntityWitherCat(World world) {
        super(world);
        EntityAIFollowOwner retreatTask = new EntityAIFollowOwner(this, 2.5, 5.0, 2.5);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollideOwned(this, EntityPlayer.class, 2.5, false, retreatTask));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.followTask);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.func_70105_a(0.6f, 0.8f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCALE_INDEX, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(GROWTH_MODE_INDEX, (Object)GrowthMode.NONE.ordinal());
    }

    @Override
    public EntityWitherWitch getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(EntityWitherWitch owner) {
        this.owner = owner;
    }

    @Override
    @Nonnull
    public EntityWitherCat asEntity() {
        return this;
    }

    public void setScale(float scale) {
        this.field_70180_af.func_187227_b(SCALE_INDEX, (Object)Float.valueOf(scale));
    }

    public float getScale() {
        return ((Float)this.field_70180_af.func_187225_a(SCALE_INDEX)).floatValue();
    }

    public void setGrowthMode(GrowthMode mode) {
        this.setGrowthMode(mode.ordinal());
    }

    private void setGrowthMode(int ordinal) {
        this.field_70180_af.func_187227_b(GROWTH_MODE_INDEX, (Object)ordinal);
    }

    public GrowthMode getGrowthMode() {
        return GrowthMode.values()[(Integer)this.field_70180_af.func_187225_a(GROWTH_MODE_INDEX)];
    }

    public float getAngryScale() {
        return 2.0f;
    }

    public float getScaleInc() {
        return 0.05f;
    }

    public boolean isAngry() {
        return this.getScale() >= 2.0f;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (this.func_70638_az() != target) {
            this.attackTargetChanged = true;
        }
        super.func_70624_b(target);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.applyAttributes((EntityLivingBase)this, ZooConfig.witherCatHealth, ZooConfig.witherCatAttackDamage);
    }

    public boolean func_70687_e(@Nonnull PotionEffect potion) {
        return potion.func_188419_a() != MobEffects.field_82731_v && super.func_70687_e(potion);
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.owner != null && source.func_76346_g() == this.owner) {
            return false;
        }
        boolean res = super.func_70097_a(source, amount);
        if (!this.field_70170_p.field_72995_K && source.func_76346_g() instanceof EntityLivingBase) {
            if (this.owner != null) {
                EntityLivingBase ownerHitBy = this.owner.func_70643_av();
                if (ownerHitBy == null) {
                    this.owner.func_70604_c((EntityLivingBase)source.func_76346_g());
                }
            } else if (this.owner == null) {
                this.func_70624_b((EntityLivingBase)source.func_76346_g());
            }
        }
        return res;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.owner != null) {
            this.owner.catDied(this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            float scale = this.getScale();
            if (this.lastScale != scale) {
                this.spawnParticles();
                this.lastScale = scale;
                this.func_70105_a(0.6f * scale, 0.8f * scale);
            }
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.attackTargetChanged) {
            EntityUtil.cancelCurrentTasks((EntityLiving)this);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.followTask);
            if (this.func_70638_az() == null) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.followTask);
            }
            this.attackTargetChanged = false;
        }
        if (this.owner != null && this.owner.field_70128_L) {
            this.setOwner((EntityWitherWitch)null);
        }
        if (this.func_70638_az() != null && !this.isAngry() && this.getGrowthMode() != GrowthMode.GROW) {
            this.setGrowthMode(GrowthMode.GROW);
        }
        this.updateScale();
        float scale = this.getScale();
        if (this.lastScale != scale) {
            this.lastScale = scale;
            this.func_70105_a(0.6f * scale, 0.8f * scale);
            float growthRatio = (this.lastScale - 1.0f) / 1.0f;
            this.updateAttackDamage(growthRatio);
            this.updateHealth(growthRatio);
        }
    }

    public void updateScale() {
        GrowthMode curMode = this.getGrowthMode();
        if (curMode == GrowthMode.NONE) {
            return;
        }
        float scale = this.getScale();
        if (curMode == GrowthMode.GROW) {
            if (scale < 2.0f) {
                this.setScale(Math.min(scale + 0.05f, 2.0f));
            } else {
                this.setScale(2.0f);
                this.setGrowthMode(GrowthMode.NONE);
            }
        } else if (scale > 1.0f) {
            this.setScale(Math.max(1.0f, scale - 0.05f));
        } else {
            this.setScale(1.0f);
            this.setGrowthMode(GrowthMode.NONE);
        }
    }

    protected void updateAttackDamage(float growthRatio) {
        IAttributeInstance att = EntityUtil.removeModifier((EntityLivingBase)this, SharedMonsterAttributes.field_111264_e, ATTACK_BOOST_MOD_UID);
        if (growthRatio == 0.0f || att == null) {
            return;
        }
        double damageInc = EntityUtil.isHardDifficulty(this.field_70170_p) ? (Double)ZooConfig.witherCatAttackDamageBonusHard.get() : 0.0;
        double attackDif = damageInc + (Double)ZooConfig.witherCatAttackDamageBonusAngry.get();
        double toAdd = attackDif * (double)growthRatio;
        AttributeModifier mod = new AttributeModifier(ATTACK_BOOST_MOD_UID, "Transformed Attack Modifier", toAdd, 0);
        att.func_111121_a(mod);
    }

    protected void updateHealth(float growthRatio) {
        IAttributeInstance att = EntityUtil.removeModifier((EntityLivingBase)this, SharedMonsterAttributes.field_111267_a, HEALTH_BOOST_MOD_UID);
        if (growthRatio == 0.0f || att == null) {
            return;
        }
        double currentRatio = this.func_110143_aJ() / this.func_110138_aP();
        double healthDif = (Double)ZooConfig.witherCatHealthBonusAngry.get();
        double toAdd = healthDif * (double)growthRatio;
        AttributeModifier mod = new AttributeModifier(HEALTH_BOOST_MOD_UID, "Transformed Attack Modifier", toAdd, 0);
        att.func_111121_a(mod);
        double newHealth = currentRatio * (double)this.func_110138_aP();
        this.func_70606_j((float)newHealth);
    }

    private void spawnParticles() {
        double startX = this.field_70165_t;
        double startY = this.field_70163_u;
        double startZ = this.field_70161_v;
        double offsetScale = 0.8 * (double)this.getScale();
        for (int i = 0; i < 2; ++i) {
            double xOffset = offsetScale - (double)this.field_70146_Z.nextFloat() * offsetScale * 2.0;
            double yOffset = offsetScale / 3.0 + (double)this.field_70146_Z.nextFloat() * offsetScale / 3.0 * 2.0;
            double zOffset = offsetScale - (double)this.field_70146_Z.nextFloat() * offsetScale * 2.0;
            Particle fx = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.SPELL.func_179348_c(), startX + xOffset, startY + yOffset, startZ + zOffset, 0.0, 0.0, 0.0, new int[0]);
            if (fx == null) continue;
            fx.func_70538_b(0.8f, 0.2f, 0.2f);
        }
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.updateBounds();
    }

    protected boolean func_70814_o() {
        return true;
    }

    protected void func_70105_a(float width, float height) {
        if (width != this.field_70130_N || height != this.field_70131_O) {
            this.field_70130_N = width;
            this.field_70131_O = height;
            this.updateBounds();
        }
    }

    private void updateBounds() {
        double hw = this.field_70130_N / 2.0f;
        double hd = hw * 2.75;
        float f1 = this.field_70131_O;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - hw, this.field_70163_u, this.field_70161_v - hd, this.field_70165_t + hw, this.field_70163_u + (double)f1, this.field_70161_v + hd));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187636_O;
    }

    @Nonnull
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource source) {
        return SoundEvents.field_187642_Q;
    }

    @Nonnull
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187639_P;
    }

    public boolean func_70039_c(@Nonnull NBTTagCompound root) {
        if (this.getOwner() == null) {
            return super.func_70039_c(root);
        }
        return false;
    }

    public void func_70014_b(@Nonnull NBTTagCompound root) {
        super.func_70014_b(root);
        root.func_74776_a("scale", this.getScale());
        root.func_74774_a("growthMode", (byte)this.getGrowthMode().ordinal());
    }

    public void func_70037_a(@Nonnull NBTTagCompound root) {
        super.func_70037_a(root);
        if (root.func_74764_b("scale")) {
            this.setScale(root.func_74760_g("scale"));
        }
        if (root.func_74764_b("growthMode")) {
            this.setGrowthMode(root.func_74771_c("growthMode"));
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("enderio", NAME);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        EntityLootHelper.dropLoot((EntityLiving)this, (ResourceLocation)this.func_184647_J(), (DamageSource)source);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    public static enum GrowthMode {
        NONE,
        GROW,
        SHRINK;

    }
}

