/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.loot.EntityLootHelper;
import crazypants.enderio.base.teleport.RandomTeleportUtil;
import crazypants.enderio.zoo.EnderIOZoo;
import crazypants.enderio.zoo.config.ZooConfig;
import crazypants.enderio.zoo.entity.IEnderZooEntity;
import crazypants.enderio.zoo.entity.render.RenderConcussionCreeper;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderiozoo")
public class EntityConcussionCreeper
extends EntityCreeper
implements IEnderZooEntity.Aggressive {
    @Nonnull
    public static final String NAME = "concussioncreeper";
    public static final int EGG_BG_COL = 5701518;
    public static final int EGG_FG_COL = 16714274;
    private Field fTimeSinceIgnited;
    private Field fFuseTime;

    @SubscribeEvent
    public static void onEntityRegister(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("enderio", NAME));
        IEnderZooEntity.register(event, NAME, EntityConcussionCreeper.class, 5701518, 16714274, IEnderZooEntity.MobID.CCREEPER);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityConcussionCreeper.class, (IRenderFactory)RenderConcussionCreeper.FACTORY);
    }

    public EntityConcussionCreeper(World world) {
        super(world);
        try {
            this.fTimeSinceIgnited = ReflectionHelper.findField(EntityCreeper.class, (String)"timeSinceIgnited", (String)"field_70833_d");
            this.fFuseTime = ReflectionHelper.findField(EntityCreeper.class, (String)"fuseTime", (String)"field_82225_f");
        }
        catch (Exception e) {
            Log.error((Object[])new Object[]{"Could not create ender creeper logic as fields not found"});
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.applyAttributes((EntityLivingBase)this, ZooConfig.creeperHealth, NO_ATTACK);
    }

    public void func_70071_h_() {
        int fuseTime;
        int timeSinceIgnited;
        if (this.func_70089_S() && (timeSinceIgnited = this.getTimeSinceIgnited()) >= (fuseTime = this.getFuseTime()) - 1) {
            this.setTimeSinceIgnited(0);
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.HOSTILE, 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
            this.func_70106_y();
            int range = (Integer)ZooConfig.explosionRange.get();
            AxisAlignedBB bb = new AxisAlignedBB(this.field_70165_t - (double)range, this.field_70163_u - (double)range, this.field_70161_v - (double)range, this.field_70165_t + (double)range, this.field_70163_u + (double)range, this.field_70161_v + (double)range);
            List ents = this.field_70170_p.func_72872_a(EntityLivingBase.class, bb);
            for (EntityLivingBase ent : ents) {
                if (ent.field_70128_L) continue;
                if (!this.field_70170_p.field_72995_K) {
                    RandomTeleportUtil.teleportEntity((World)ent.field_70170_p, (Entity)ent, (boolean)false, (boolean)true, (float)((Float)ZooConfig.teleportRange.get()).floatValue());
                }
                if (!(ent instanceof EntityPlayer)) continue;
                EnderIOZoo.proxy.setInstantConfusionOnPlayer((EntityPlayer)ent, (Integer)ZooConfig.confusionDuration.get());
            }
        }
        super.func_70071_h_();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("enderio", NAME);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        EntityLootHelper.dropLoot((EntityLiving)this, (ResourceLocation)this.func_184647_J(), (DamageSource)source);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    private void setTimeSinceIgnited(int i) {
        if (this.fTimeSinceIgnited == null) {
            return;
        }
        try {
            this.fTimeSinceIgnited.setInt(this, i);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getTimeSinceIgnited() {
        if (this.fTimeSinceIgnited == null) {
            return 0;
        }
        try {
            return this.fTimeSinceIgnited.getInt(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int getFuseTime() {
        if (this.fFuseTime == null) {
            return 0;
        }
        try {
            return this.fFuseTime.getInt(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

