/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.loot.EntityLootHelper;
import crazypants.enderio.base.potion.PotionUtil;
import crazypants.enderio.zoo.config.ZooConfig;
import crazypants.enderio.zoo.entity.EntityUtil;
import crazypants.enderio.zoo.entity.EntityWitherCat;
import crazypants.enderio.zoo.entity.IEnderZooEntity;
import crazypants.enderio.zoo.entity.SpawnUtil;
import crazypants.enderio.zoo.entity.ai.EntityAIRangedAttack;
import crazypants.enderio.zoo.entity.render.RenderWitherWitch;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderiozoo")
public class EntityWitherWitch
extends EntityMob
implements IRangedAttackMob,
IEnderZooEntity.Aggressive {
    @Nonnull
    public static final String NAME = "witherwitch";
    public static final int EGG_BG_COL = 2511373;
    public static final int EGG_FG_COL = 9461315;
    private int attackTimer;
    private EntityLivingBase attackedWithPotion;
    private int healTimer;
    private boolean isHealing;
    private boolean spawned;
    private boolean firstUpdateWitch = true;
    @Nonnull
    private final List<EntityWitherCat> cats = new ArrayList<EntityWitherCat>();
    @Nonnull
    private final List<NBTTagCompound> loadedCats = new ArrayList<NBTTagCompound>();
    @Nonnull
    private final EntityAIRangedAttack rangedAttackAI = new EntityAIRangedAttack(this, 1.0, 60, 10.0f);
    private int noActiveTargetTime;

    @SubscribeEvent
    public static void onEntityRegister(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("enderio", NAME));
        IEnderZooEntity.register(event, NAME, EntityWitherWitch.class, 2511373, 9461315, IEnderZooEntity.MobID.WWITCH);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityWitherWitch.class, (IRenderFactory)RenderWitherWitch.FACTORY);
    }

    public EntityWitherWitch(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.rangedAttackAI);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.applyAttributes((EntityLivingBase)this, ZooConfig.witherWitchHealth, NO_ATTACK);
    }

    protected float func_70672_c(@Nonnull DamageSource damageSource, float damage) {
        damage = super.func_70672_c(damageSource, damage);
        if (damageSource.func_76346_g() == this) {
            damage = 0.0f;
        }
        if (damageSource.func_82725_o()) {
            damage = (float)((double)damage * 0.15);
        }
        return damage;
    }

    public boolean func_70687_e(@Nonnull PotionEffect potion) {
        return potion.func_188419_a() != MobEffects.field_82731_v && super.func_70687_e(potion);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("enderio", NAME);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        EntityLootHelper.dropLoot((EntityLiving)this, (ResourceLocation)this.func_184647_J(), (DamageSource)source);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    public void func_70604_c(@Nullable EntityLivingBase target) {
        EntityLivingBase curTarget = this.func_70643_av();
        super.func_70604_c(target);
        if (curTarget == target || this.field_70170_p.field_72995_K || target == null) {
            return;
        }
        float distToSrc = this.func_70032_d((Entity)target);
        if (distToSrc > this.func_70661_as().func_111269_d() && distToSrc < 50.0f) {
            this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)(distToSrc + 2.0f));
        }
    }

    public IEntityLivingData func_180482_a(@Nonnull DifficultyInstance di, @Nullable IEntityLivingData livingData) {
        this.spawned = true;
        return super.func_180482_a(di, livingData);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            super.func_70636_d();
            return;
        }
        if (this.firstUpdateWitch) {
            if (this.spawned) {
                this.spawnCats();
            } else {
                this.loadCats();
            }
            this.firstUpdateWitch = false;
        }
        this.doAttackActions();
        this.manageCats();
        super.func_70636_d();
    }

    protected void doAttackActions() {
        --this.attackTimer;
        --this.healTimer;
        EntityLivingBase target = this.getActiveTarget();
        this.noActiveTargetTime = target == null ? ++this.noActiveTargetTime : 0;
        if (this.shouldStartHeal()) {
            ItemStack potion = (double)this.field_70146_Z.nextFloat() > 0.75 ? PotionUtil.createRegenerationPotion((boolean)false, (boolean)true, (boolean)true) : PotionUtil.createHealthPotion((boolean)false, (boolean)true);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, potion);
            this.healTimer = 10;
            this.isHealing = true;
        } else if (target != null && this.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            ItemStack potion = this.getActiveTarget().func_70644_a(MobEffects.field_82731_v) ? (this.field_70146_Z.nextFloat() < (EntityUtil.isHardDifficulty(this.field_70170_p) ? 0.05f : 0.005f) ? PotionUtil.createFloatingPotion((boolean)false, (boolean)false, (boolean)true) : PotionUtil.createHarmingPotion((boolean)EntityUtil.isHardDifficulty(this.field_70170_p), (boolean)true)) : PotionUtil.createWitherPotion((boolean)false, (boolean)true);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, potion);
            this.attackTimer = 10;
            this.healTimer = 40;
        } else if (this.noActiveTargetTime > 40 && !this.isHealing && !this.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
            this.attackedWithPotion = null;
        }
        if (this.isHealing && this.healTimer <= 0 && this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Items.field_185155_bH) {
            this.throwHealthPotion();
            this.isHealing = false;
        }
    }

    protected EntityLivingBase getActiveTarget() {
        EntityLivingBase res = this.func_70638_az();
        if (res == null) {
            res = this.rangedAttackAI.getAttackTarget();
        }
        return res;
    }

    protected boolean shouldStartHeal() {
        if (this.func_70644_a(MobEffects.field_76428_l)) {
            return false;
        }
        return (double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.75 && (double)this.field_70146_Z.nextFloat() > 0.5 && this.healTimer <= 0;
    }

    public void func_82196_d(@Nonnull EntityLivingBase entity, float rangeRatio) {
        if (this.attackTimer <= 0 && this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Items.field_185155_bH && !this.isHealing) {
            this.attackedWithPotion = entity;
            double x = entity.field_70165_t + entity.field_70159_w - this.field_70165_t;
            double y = entity.field_70163_u + (double)entity.func_70047_e() - (double)1.1f - this.field_70163_u;
            double z = entity.field_70161_v + entity.field_70179_y - this.field_70161_v;
            float groundDistance = MathHelper.func_76133_a((double)(x * x + z * z));
            ItemStack potion = this.func_184586_b(EnumHand.MAIN_HAND);
            this.attackTimer = this.func_184586_b(EnumHand.MAIN_HAND).func_77988_m();
            EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, potion);
            entitypotion.field_70125_A -= -20.0f;
            entitypotion.func_70186_c(x, y + (double)(groundDistance * 0.2f), z, 0.75f, 8.0f);
            this.field_70170_p.func_72838_d((Entity)entitypotion);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
        }
    }

    protected void throwHealthPotion() {
        ItemStack potion = this.func_184586_b(EnumHand.MAIN_HAND);
        EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, potion);
        Vec3d lookVec = this.func_70040_Z();
        entitypotion.func_70186_c(lookVec.field_72450_a * 0.5, -1.0, lookVec.field_72449_c * 0.5, 0.75f, 1.0f);
        this.field_70170_p.func_72838_d((Entity)entitypotion);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
        this.healTimer = 80;
    }

    public void catDied(EntityWitherCat cat) {
        this.cats.remove(cat);
    }

    private void spawnCats() {
        if (!((Boolean)ZooConfig.witherCatEnabled.get()).booleanValue()) {
            return;
        }
        int numCats = this.field_70146_Z.nextInt((Integer)ZooConfig.witherCatMaximum.get() + 1);
        numCats = Math.max(numCats, (Integer)ZooConfig.witherCatMinimum.get());
        for (int i = 0; i < numCats; ++i) {
            BlockPos clearGround = SpawnUtil.findClearGround(this.field_70170_p, BlockCoord.get((Entity)this).func_177982_a(4 - this.field_70146_Z.nextInt(9), 0, 4 - this.field_70146_Z.nextInt(9)), 2, 10, true);
            if (clearGround == null) {
                return;
            }
            this.spawnCat(clearGround);
        }
    }

    private void spawnCat(BlockPos spawnLoc) {
        EntityWitherCat cat = new EntityWitherCat(this.field_70170_p);
        cat.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
        cat.setOwner(this);
        cat.func_70080_a((double)spawnLoc.func_177958_n() + 0.5, (double)spawnLoc.func_177956_o() + 0.5, (double)spawnLoc.func_177952_p() + 0.5, this.field_70177_z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)new LivingSpawnEvent.CheckSpawn((EntityLiving)cat, this.field_70170_p, (float)cat.field_70165_t, (float)cat.field_70163_u, (float)cat.field_70161_v, false))) {
            return;
        }
        if (!cat.func_70601_bi()) {
            return;
        }
        this.cats.add(cat);
        this.field_70170_p.func_72838_d((Entity)cat);
    }

    public void func_70014_b(@Nonnull NBTTagCompound root) {
        super.func_70014_b(root);
        if (this.cats.isEmpty()) {
            return;
        }
        NBTTagList catsList = new NBTTagList();
        for (EntityWitherCat cat : this.cats) {
            if (cat.field_70128_L) continue;
            NBTTagCompound catRoot = new NBTTagCompound();
            cat.func_189511_e(catRoot);
            catsList.func_74742_a((NBTBase)catRoot);
        }
        if (catsList.func_74745_c() > 0) {
            root.func_74782_a("cats", (NBTBase)catsList);
        }
    }

    public void func_70037_a(@Nonnull NBTTagCompound root) {
        super.func_70037_a(root);
        this.loadedCats.clear();
        if (root.func_74764_b("cats")) {
            NBTTagList catsList = (NBTTagList)root.func_74781_a("cats");
            for (int i = 0; i < catsList.func_74745_c(); ++i) {
                this.loadedCats.add(catsList.func_150305_b(i));
            }
        }
    }

    private void loadCats() {
        if (this.loadedCats.isEmpty()) {
            return;
        }
        for (NBTTagCompound catRoot : this.loadedCats) {
            if (catRoot == null) continue;
            EntityWitherCat cat = new EntityWitherCat(this.field_70170_p);
            cat.func_70020_e(catRoot);
            cat.setOwner(this);
            this.cats.add(cat);
            this.field_70170_p.func_72838_d((Entity)cat);
        }
    }

    protected void manageCats() {
        if (this.cats.isEmpty()) {
            return;
        }
        if (this.noActiveTargetTime > 40) {
            this.pacifyCats();
            return;
        }
        EntityLivingBase currentTarget = this.getActiveTarget();
        EntityLivingBase hitBy = this.func_70643_av();
        if (hitBy == null) {
            hitBy = this.attackedWithPotion;
        }
        this.angerCats(currentTarget, hitBy);
    }

    private void angerCats(EntityLivingBase targ, EntityLivingBase hitBy) {
        for (EntityWitherCat cat : this.cats) {
            if (cat.isAngry()) {
                if (cat.func_70638_az() == targ) continue;
                cat.func_70624_b(targ);
                continue;
            }
            if (cat.getGrowthMode() == EntityWitherCat.GrowthMode.GROW || hitBy == null) continue;
            cat.setGrowthMode(EntityWitherCat.GrowthMode.GROW);
        }
    }

    private void pacifyCats() {
        for (EntityWitherCat cat : this.cats) {
            if (!cat.isAngry()) continue;
            cat.setGrowthMode(EntityWitherCat.GrowthMode.SHRINK);
            if (cat.func_70638_az() == null) continue;
            cat.func_70624_b(null);
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }
}

