/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.stellarfluidconduits.common.conduit;

import com.enderio.core.common.fluid.IFluidWrapper;
import com.enderio.core.common.util.DyeColor;
import com.tfar.stellarfluidconduits.common.conduit.stellar.StellarFluidConduit;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.conduits.conduit.liquid.AbstractLiquidConduit;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class NetworkTank {
    @Nonnull
    public final StellarFluidConduit con;
    @Nonnull
    public final EnumFacing conDir;
    public final IFluidWrapper externalTank;
    @Nonnull
    public final EnumFacing tankDir;
    @Nonnull
    public final BlockPos conduitLoc;
    public final boolean acceptsOuput;
    public final DyeColor inputColor;
    public final DyeColor outputColor;
    public final int priority;
    public final boolean roundRobin;
    public final boolean selfFeed;
    public final boolean supportsMultipleTanks;

    public NetworkTank(@Nonnull StellarFluidConduit con, @Nonnull EnumFacing conDir) {
        this.con = con;
        this.conDir = conDir;
        this.conduitLoc = con.getBundle().getLocation();
        this.tankDir = conDir.func_176734_d();
        this.externalTank = AbstractLiquidConduit.getExternalFluidHandler((IBlockAccess)con.getBundle().getBundleworld(), (BlockPos)this.conduitLoc.func_177972_a(conDir), (EnumFacing)this.tankDir);
        this.acceptsOuput = con.getConnectionMode(conDir).acceptsOutput();
        this.inputColor = con.getOutputColor(conDir);
        this.outputColor = con.getInputColor(conDir);
        this.priority = con.getOutputPriority(conDir);
        this.roundRobin = con.isRoundRobinEnabled(conDir);
        this.selfFeed = con.isSelfFeedEnabled(conDir);
        this.supportsMultipleTanks = this.externalTank != null && this.externalTank.getTankInfoWrappers().size() > 1;
    }

    public boolean isValid() {
        return this.externalTank != null && this.con.getConnectionMode(this.conDir) != ConnectionMode.DISABLED;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.conDir.hashCode();
        result = 31 * result + this.conduitLoc.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkTank other = (NetworkTank)obj;
        return this.conDir == other.conDir && this.conduitLoc.equals((Object)other.conduitLoc);
    }
}

