/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.stellarfluidconduits.common.network;

import com.enderio.core.common.util.DyeColor;
import com.tfar.stellarfluidconduits.common.conduit.stellar.StellarFluidConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.capability.CapabilityFilterHolder;
import crazypants.enderio.base.filter.capability.IFilterHolder;
import crazypants.enderio.conduits.network.PacketConduitFilter;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketStellarFluidConduit
extends PacketConduitFilter<StellarFluidConduit> {
    private DyeColor colIn;
    private DyeColor colOut;
    private int priority;
    private boolean roundRobin;
    private boolean selfFeed;

    public PacketStellarFluidConduit() {
    }

    public PacketStellarFluidConduit(@Nonnull StellarFluidConduit con, @Nonnull EnumFacing dir) {
        super((IConduit)con, dir);
        this.colIn = con.getInputColor(dir);
        this.colOut = con.getOutputColor(dir);
        this.priority = con.getOutputPriority(dir);
        this.roundRobin = con.isRoundRobinEnabled(dir);
        this.selfFeed = con.isSelfFeedEnabled(dir);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.colIn.ordinal());
        buf.writeShort(this.colOut.ordinal());
        buf.writeInt(this.priority);
        buf.writeBoolean(this.roundRobin);
        buf.writeBoolean(this.selfFeed);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.colIn = DyeColor.values()[buf.readShort()];
        this.colOut = DyeColor.values()[buf.readShort()];
        this.priority = buf.readInt();
        this.roundRobin = buf.readBoolean();
        this.selfFeed = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<PacketStellarFluidConduit, IMessage> {
        public IMessage onMessage(PacketStellarFluidConduit message, MessageContext ctx) {
            StellarFluidConduit conduit = (StellarFluidConduit)message.getConduit(ctx);
            if (conduit != null) {
                conduit.setInputColor(message.dir, message.colIn);
                conduit.setOutputColor(message.dir, message.colOut);
                conduit.setOutputPriority(message.dir, message.priority);
                conduit.setRoundRobinEnabled(message.dir, message.roundRobin);
                conduit.setSelfFeedEnabled(message.dir, message.selfFeed);
                this.applyFilter(message.dir, (IConduit)conduit, message.inputFilter, true);
                this.applyFilter(message.dir, (IConduit)conduit, message.outputFilter, false);
                IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
                message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
            }
            return null;
        }

        private void applyFilter(EnumFacing dir, IConduit conduit, IFilter filter, boolean isInput) {
            if (conduit.hasInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, dir)) {
                IFilterHolder filterHolder = (IFilterHolder)conduit.getInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, dir);
                if (isInput) {
                    filterHolder.setFilter(filterHolder.getInputFilterIndex(), dir.ordinal(), filter);
                } else {
                    filterHolder.setFilter(filterHolder.getOutputFilterIndex(), dir.ordinal(), filter);
                }
            }
        }
    }
}

