/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.conduit;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.conduits.conduit.AbstractConduit;
import crazypants.enderio.util.EnumReader;
import gg.galaxygaming.gasconduits.client.GasSettings;
import gg.galaxygaming.gasconduits.common.conduit.IGasConduit;
import gg.galaxygaming.gasconduits.common.utils.GasWrapper;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractGasConduit
extends AbstractConduit
implements IGasConduit {
    protected final EnumMap<EnumFacing, RedstoneControlMode> extractionModes = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, DyeColor> extractionColors = new EnumMap(EnumFacing.class);

    public static IGasHandler getExternalGasHandler(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return world.func_175625_s(pos) instanceof IConduitBundle ? null : GasWrapper.getGasHandler(world, pos, side);
    }

    public IGasHandler getExternalHandler(@Nonnull EnumFacing direction) {
        return AbstractGasConduit.getExternalGasHandler((IBlockAccess)this.getBundle().getBundleworld(), this.getBundle().getLocation().func_177972_a(direction), direction.func_176734_d());
    }

    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreDisabled) {
        return this.getExternalHandler(direction) != null;
    }

    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return IGasConduit.class;
    }

    public void setExtractionRedstoneMode(@Nonnull RedstoneControlMode mode, @Nonnull EnumFacing dir) {
        this.extractionModes.put(dir, mode);
    }

    @Nonnull
    public RedstoneControlMode getExtractionRedstoneMode(@Nonnull EnumFacing dir) {
        RedstoneControlMode res = this.extractionModes.get(dir);
        return res == null ? RedstoneControlMode.NEVER : res;
    }

    public void setExtractionSignalColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.extractionColors.put(dir, col);
    }

    @Nonnull
    public DyeColor getExtractionSignalColor(@Nonnull EnumFacing dir) {
        DyeColor result = this.extractionColors.get(dir);
        return result == null ? DyeColor.RED : result;
    }

    @Override
    public boolean canOutputToDir(@Nonnull EnumFacing dir) {
        return this.canInputToDir(dir) && (this.conduitConnections.contains(dir) || this.externalConnections.contains(dir));
    }

    protected boolean autoExtractForDir(@Nonnull EnumFacing dir) {
        if (!this.canExtractFromDir(dir)) {
            return false;
        }
        RedstoneControlMode mode = this.getExtractionRedstoneMode(dir);
        return ConduitUtil.isRedstoneControlModeMet((IServerConduit)this, (RedstoneControlMode)mode, (DyeColor)this.getExtractionSignalColor(dir));
    }

    @Override
    public boolean canExtractFromDir(@Nonnull EnumFacing dir) {
        return this.getConnectionMode(dir).acceptsInput();
    }

    @Override
    public boolean canInputToDir(@Nonnull EnumFacing dir) {
        return this.getConnectionMode(dir).acceptsOutput() && !this.autoExtractForDir(dir);
    }

    protected boolean hasExtractableMode() {
        return this.supportsConnectionMode(ConnectionMode.INPUT) || this.supportsConnectionMode(ConnectionMode.IN_OUT);
    }

    protected void readTypeSettings(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        this.setExtractionSignalColor(dir, (DyeColor)EnumReader.get(DyeColor.class, (int)dataRoot.func_74765_d("extractionSignalColor")));
        this.setExtractionRedstoneMode(RedstoneControlMode.fromOrdinal((int)dataRoot.func_74765_d("extractionRedstoneMode")), dir);
    }

    protected void writeTypeSettingsToNbt(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("extractionSignalColor", (short)this.getExtractionSignalColor(dir).ordinal());
        dataRoot.func_74777_a("extractionRedstoneMode", (short)this.getExtractionRedstoneMode(dir).ordinal());
    }

    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        for (Map.Entry<EnumFacing, RedstoneControlMode> entry : this.extractionModes.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74777_a("extRM." + entry.getKey().name(), (short)entry.getValue().ordinal());
        }
        for (Map.Entry<EnumFacing, RedstoneControlMode> entry : this.extractionColors.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74777_a("extSC." + entry.getKey().name(), (short)((DyeColor)entry.getValue()).ordinal());
        }
    }

    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            short ord;
            String key = "extRM." + dir.name();
            if (nbtRoot.func_74764_b(key) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < RedstoneControlMode.values().length) {
                this.extractionModes.put(dir, (RedstoneControlMode)EnumReader.get(RedstoneControlMode.class, (int)ord));
            }
            if (!nbtRoot.func_74764_b(key = "extSC." + dir.name()) || (ord = nbtRoot.func_74765_d(key)) < 0 || ord >= DyeColor.values().length) continue;
            this.extractionColors.put(dir, (DyeColor)EnumReader.get(DyeColor.class, (int)ord));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ITabPanel createGuiPanel(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        return new GasSettings(gui, con);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean updateGuiPanel(@Nonnull ITabPanel panel) {
        return panel instanceof GasSettings && ((GasSettings)panel).updateConduit(this);
    }

    @SideOnly(value=Side.CLIENT)
    public int getGuiPanelTabOrder() {
        return 1;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY && side != null && this.containsExternalConnection(side)) {
            ConnectionMode mode = this.getConnectionMode(side);
            return mode.acceptsInput() || mode.acceptsOutput();
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing side) {
        return (T)(this.hasCapability(capability, side) ? this.getGasDir(side) : null);
    }

    @Override
    @Nullable
    public IGasHandler getGasDir(@Nullable EnumFacing dir) {
        return dir != null ? new ConnectionGasSide(dir) : null;
    }

    protected class ConnectionGasSide
    implements IGasHandler,
    ICapabilityProvider {
        @Nonnull
        protected EnumFacing side;

        public ConnectionGasSide(EnumFacing side) {
            this.side = side;
        }

        public int receiveGas(EnumFacing facing, GasStack resource, boolean doFill) {
            if (this.canReceiveGas(facing, resource.getGas())) {
                return AbstractGasConduit.this.receiveGas(facing, resource, doFill);
            }
            return 0;
        }

        public GasStack drawGas(EnumFacing facing, int maxDrain, boolean doDrain) {
            if (this.canDrawGas(facing, null)) {
                return AbstractGasConduit.this.drawGas(facing, maxDrain, doDrain);
            }
            return null;
        }

        public boolean canReceiveGas(EnumFacing facing, Gas gas) {
            if (this.side.equals((Object)facing) && AbstractGasConduit.this.getConnectionMode(facing).acceptsInput()) {
                return ConduitUtil.isRedstoneControlModeMet((IServerConduit)AbstractGasConduit.this, (RedstoneControlMode)AbstractGasConduit.this.getExtractionRedstoneMode(facing), (DyeColor)AbstractGasConduit.this.getExtractionSignalColor(facing));
            }
            return false;
        }

        public boolean canDrawGas(EnumFacing facing, Gas gas) {
            if (this.side.equals((Object)facing) && AbstractGasConduit.this.getConnectionMode(facing).acceptsOutput()) {
                return ConduitUtil.isRedstoneControlModeMet((IServerConduit)AbstractGasConduit.this, (RedstoneControlMode)AbstractGasConduit.this.getExtractionRedstoneMode(facing), (DyeColor)AbstractGasConduit.this.getExtractionSignalColor(facing));
            }
            return false;
        }

        @Nonnull
        public GasTankInfo[] getTankInfo() {
            return AbstractGasConduit.this.getTankInfo();
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
                if (!this.side.equals((Object)facing)) {
                    return false;
                }
                ConnectionMode connectionMode = AbstractGasConduit.this.getConnectionMode(facing);
                return connectionMode.acceptsOutput() || connectionMode.acceptsInput();
            }
            return false;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this) : null);
        }
    }
}

