/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.spawner;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.machines.machine.spawner.SpawnerNotification;
import crazypants.enderio.machines.machine.spawner.TilePoweredSpawner;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSpawnerUpdateNotification
extends MessageTileEntity<TilePoweredSpawner> {
    private Set<SpawnerNotification> notification;

    public PacketSpawnerUpdateNotification() {
    }

    public PacketSpawnerUpdateNotification(@Nonnull TilePoweredSpawner tile, @Nonnull Set<SpawnerNotification> notification) {
        super((TileEntity)tile);
        this.notification = notification;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.notification = EnumSet.noneOf(SpawnerNotification.class);
        int count = buf.readByte();
        for (int i = 0; i < count; ++i) {
            this.notification.add(SpawnerNotification.values()[buf.readByte()]);
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.notification.size());
        for (SpawnerNotification farmNotification : this.notification) {
            buf.writeByte(farmNotification.ordinal());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSpawnerUpdateNotification, IMessage> {
        public IMessage onMessage(PacketSpawnerUpdateNotification message, MessageContext ctx) {
            TilePoweredSpawner te = (TilePoweredSpawner)message.getTileEntity(message.getWorld(ctx));
            if (te != null) {
                te.replaceNotification(message.notification);
            }
            return null;
        }
    }
}

