/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.item;

import com.enderio.core.common.util.RoundRobinIterator;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capability.ItemTools;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.conduits.conduit.item.IItemConduit;
import crazypants.enderio.conduits.conduit.item.ItemConduitNetwork;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class NetworkedInventory {
    private static final boolean SIMULATE = true;
    private static final boolean EXECUTE = false;
    @Nonnull
    private final IItemConduit con;
    @Nonnull
    private final EnumFacing conDir;
    @Nonnull
    private final BlockPos location;
    @Nonnull
    private final EnumFacing inventorySide;
    @Nonnull
    private final List<Target> sendPriority = new ArrayList<Target>();
    @Nonnull
    private final RoundRobinIterator<Target> rrIter = new RoundRobinIterator(this.sendPriority);
    private int extractFromSlot = -1;
    private int tickDeficit = 100;
    @Nonnull
    private final World world;
    @Nonnull
    private final ItemConduitNetwork network;

    NetworkedInventory(@Nonnull ItemConduitNetwork network, @Nonnull IItemConduit con, @Nonnull EnumFacing conDir, @Nonnull IItemHandler inv, @Nonnull BlockPos location) {
        this.network = network;
        this.inventorySide = conDir.func_176734_d();
        this.con = con;
        this.conDir = conDir;
        this.location = location;
        this.world = con.getBundle().getBundleworld();
    }

    @Nonnull
    public BlockPos getLocation() {
        return this.location;
    }

    @Nonnull
    public IItemConduit getCon() {
        return this.con;
    }

    @Nonnull
    public EnumFacing getConDir() {
        return this.conDir;
    }

    @Nonnull
    public List<Target> getSendPriority() {
        return this.sendPriority;
    }

    public boolean hasTarget(@Nonnull IItemConduit conduit, @Nonnull EnumFacing dir) {
        for (Target t : this.sendPriority) {
            if (t.inv.getCon() != conduit || t.inv.getConDir() != dir) continue;
            return true;
        }
        return false;
    }

    private boolean canExtract() {
        return this.con.getConnectionMode(this.conDir).acceptsInput();
    }

    private boolean canInsert() {
        return this.con.getConnectionMode(this.conDir).acceptsOutput();
    }

    private boolean isSticky() {
        IItemFilter outputFilter = NetworkedInventory.valid(this.con.getOutputFilter(this.conDir));
        return outputFilter != null && outputFilter.isSticky();
    }

    private int getPriority() {
        return this.con.getOutputPriority(this.conDir);
    }

    public boolean shouldTick() {
        if (this.tickDeficit > 0) {
            --this.tickDeficit;
            return false;
        }
        if (!this.canExtract() || !this.con.isExtractionRedstoneConditionMet(this.conDir)) {
            this.tickDeficit = (Integer)ConduitConfig.sleepBetweenTries.get();
            return false;
        }
        return true;
    }

    public void onTick() {
        if (!this.transferItems()) {
            this.tickDeficit = (Integer)ConduitConfig.sleepBetweenFailedTries.get();
            return;
        }
        if (this.tickDeficit <= 0) {
            this.tickDeficit = (Integer)ConduitConfig.sleepBetweenTries.get();
        }
    }

    private int nextSlot(int numSlots) {
        ++this.extractFromSlot;
        if (this.extractFromSlot >= numSlots || this.extractFromSlot < 0) {
            this.extractFromSlot = 0;
        }
        return this.extractFromSlot;
    }

    private void setNextStartingSlot(int slot) {
        this.extractFromSlot = slot;
        --this.extractFromSlot;
    }

    private boolean transferItems() {
        IItemHandler inventory = this.getInventory();
        if (inventory == null) {
            return false;
        }
        int numSlots = inventory.getSlots();
        if (numSlots < 1) {
            return false;
        }
        int maxExtracted = this.con.getMaximumExtracted(this.conDir);
        IItemFilter filter = NetworkedInventory.valid(this.con.getInputFilter(this.conDir));
        int slotChecksPerTick = (Integer)ConduitConfig.maxSlotCheckPerTick.get();
        for (int i = 0; i < numSlots && i < slotChecksPerTick; ++i) {
            int slot = this.nextSlot(numSlots);
            ItemStack item = inventory.extractItem(slot, maxExtracted, true);
            if (Prep.isValid(item)) {
                ItemStack stackInSlot;
                int count;
                if (filter != null && (!filter.isLimited() ? !filter.doesItemPassFilter(inventory, item) : (count = filter.getMaxCountThatPassesFilter(inventory, item)) <= 0 || count < Integer.MAX_VALUE && ((stackInSlot = inventory.getStackInSlot(slot)).func_190916_E() <= count || stackInSlot.func_190916_E() - item.func_190916_E() < count && Prep.isInvalid(item = inventory.extractItem(slot, stackInSlot.func_190916_E() - count, true))))) continue;
                if (!this.doTransfer(inventory, item, slot)) continue;
                if (inventory.getStackInSlot(slot).func_190926_b()) {
                    this.setNextStartingSlot(slot + 1);
                } else {
                    this.setNextStartingSlot(slot);
                }
                return true;
            }
            ++slotChecksPerTick;
        }
        return false;
    }

    private boolean doTransfer(@Nonnull IItemHandler inventory, @Nonnull ItemStack extractedItem, int slot) {
        int numInserted = this.insertIntoTargets(extractedItem.func_77946_l());
        if (numInserted <= 0) {
            return false;
        }
        ItemStack extracted = inventory.extractItem(slot, numInserted, false);
        if (Prep.isInvalid(extracted) || extracted.func_190916_E() != numInserted || extracted.func_77973_b() != extractedItem.func_77973_b()) {
            if (extracted.func_190916_E() < numInserted && (extracted.func_190916_E() == 0 || extracted.func_77973_b() == extractedItem.func_77973_b())) {
                Log.warn("NetworkedInventory.itemExtracted: Inserted " + numInserted + " " + extractedItem.func_82833_r() + " but only removed " + extracted.func_190916_E() + " " + extracted.func_82833_r() + " from " + inventory + " at " + this.location + ". This means that " + (numInserted - extracted.func_190916_E()) + " items were just duped by " + inventory + "!");
            } else {
                Log.warn("NetworkedInventory.itemExtracted: Inserted " + numInserted + " " + extractedItem.func_82833_r() + " but only removed " + extracted.func_190916_E() + " " + extracted.func_82833_r() + " from " + inventory + " at " + this.location);
            }
        }
        this.onItemExtracted(slot, numInserted);
        return true;
    }

    private void onItemExtracted(int slot, int numInserted) {
        this.con.itemsExtracted(numInserted, slot);
        this.tickDeficit = Math.round((float)numInserted * this.con.getTickTimePerItem(this.conDir));
    }

    private int insertIntoTargets(@Nonnull ItemStack toInsert) {
        if (Prep.isInvalid(toInsert)) {
            return 0;
        }
        int totalToInsert = toInsert.func_190916_E();
        boolean matchedStickyOutput = false;
        for (Target target : this.getTargetIterator()) {
            IItemFilter filter = NetworkedInventory.valid(target.inv.getCon().getOutputFilter(target.inv.getConDir()));
            if (target.stickyInput && !matchedStickyOutput && filter != null) {
                matchedStickyOutput = filter.doesItemPassFilter(target.inv.getInventory(), toInsert);
            }
            if (target.stickyInput || !matchedStickyOutput) {
                toInsert.func_190918_g(NetworkedInventory.positive(target.inv.insertItem(toInsert, filter)));
                if (!Prep.isInvalid(toInsert)) continue;
                break;
            }
            if (target.stickyInput || !matchedStickyOutput) continue;
            break;
        }
        return totalToInsert - toInsert.func_190916_E();
    }

    private static final IItemFilter valid(IItemFilter filter) {
        return filter != null && filter.isValid() ? filter : null;
    }

    private static final int positive(int x) {
        return x > 0 ? x : 0;
    }

    private Iterable<Target> getTargetIterator() {
        if (this.con.isRoundRobinEnabled(this.conDir)) {
            return this.rrIter;
        }
        return this.sendPriority;
    }

    private int insertItem(@Nonnull ItemStack item, IItemFilter filter) {
        if (!this.canInsert() || Prep.isInvalid(item)) {
            return 0;
        }
        IItemHandler inventory = this.getInventory();
        if (inventory == null) {
            return 0;
        }
        if (filter != null) {
            if (filter.isLimited()) {
                int count = filter.getMaxCountThatPassesFilter(inventory, item);
                if (count <= 0) {
                    return 0;
                }
                int maxInsert = ItemTools.getInsertLimit(inventory, item, count);
                if (maxInsert <= 0) {
                    return 0;
                }
                if (maxInsert < item.func_190916_E()) {
                    item = item.func_77946_l();
                    item.func_190920_e(maxInsert);
                }
            } else if (!filter.doesItemPassFilter(inventory, item)) {
                return 0;
            }
        }
        return ItemTools.doInsertItem(inventory, item);
    }

    public void updateInsertOrder() {
        this.sendPriority.clear();
        if (!this.canExtract()) {
            return;
        }
        ArrayList<Target> result = new ArrayList<Target>();
        for (NetworkedInventory other : this.network.getInventories()) {
            if (!this.con.isSelfFeedEnabled(this.conDir) && other == this || !other.canInsert() || this.con.getInputColor(this.conDir) != other.getCon().getOutputColor(other.getConDir())) continue;
            if (((Boolean)ConduitConfig.usePhyscialDistance.get()).booleanValue()) {
                this.sendPriority.add(new Target(other, this.distanceTo(other), other.isSticky(), other.getPriority()));
                continue;
            }
            result.add(new Target(other, 9999999, other.isSticky(), other.getPriority()));
        }
        if (((Boolean)ConduitConfig.usePhyscialDistance.get()).booleanValue()) {
            Collections.sort(this.sendPriority);
        } else if (!result.isEmpty()) {
            HashMap<BlockPos, Integer> visited = new HashMap<BlockPos, Integer>();
            ArrayList<BlockPos> steps = new ArrayList<BlockPos>();
            steps.add(this.con.getBundle().getLocation());
            this.calculateDistances(result, visited, steps, 0);
            this.sendPriority.addAll(result);
            Collections.sort(this.sendPriority);
        }
    }

    private void calculateDistances(@Nonnull List<Target> targets, @Nonnull Map<BlockPos, Integer> visited, @Nonnull List<BlockPos> steps, int distance) {
        if (steps.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> nextSteps = new ArrayList<BlockPos>();
        for (BlockPos pos : steps) {
            IItemConduit con1 = this.network.getConMap().get(pos);
            if (con1 == null) continue;
            for (EnumFacing dir : con1.getExternalConnections()) {
                Target target;
                if (dir == null || (target = this.getTarget(targets, con1, dir)) == null || target.distance <= distance) continue;
                target.distance = distance;
            }
            if (!visited.containsKey(pos)) {
                visited.put(pos, distance);
            } else {
                int prevDist = visited.get(pos);
                if (prevDist <= distance) continue;
                visited.put(pos, distance);
            }
            for (EnumFacing dir : con1.getConduitConnections()) {
                if (dir == null) continue;
                nextSteps.add(pos.func_177972_a(dir));
            }
        }
        this.calculateDistances(targets, visited, nextSteps, distance + 1);
    }

    private Target getTarget(@Nonnull List<Target> targets, @Nonnull IItemConduit con1, @Nonnull EnumFacing dir) {
        for (Target target : targets) {
            if (target == null || target.inv == null || target.inv.getConDir() != dir || !target.inv.getCon().getBundle().getLocation().equals((Object)con1.getBundle().getLocation())) continue;
            return target;
        }
        return null;
    }

    private int distanceTo(NetworkedInventory other) {
        return (int)this.con.getBundle().getLocation().func_177951_i((Vec3i)other.getCon().getBundle().getLocation());
    }

    @Nullable
    public IItemHandler getInventory() {
        return ItemTools.getExternalInventory((IBlockAccess)this.world, this.location, this.inventorySide);
    }

    @Nonnull
    public String getLocalizedInventoryName() {
        return this.world.func_180495_p(this.location).func_177230_c().func_149732_F();
    }

    static class Target
    implements Comparable<Target> {
        final NetworkedInventory inv;
        int distance;
        final boolean stickyInput;
        final int priority;

        Target(@Nonnull NetworkedInventory inv, int distance, boolean stickyInput, int priority) {
            this.inv = inv;
            this.distance = distance;
            this.stickyInput = stickyInput;
            this.priority = priority;
        }

        @Override
        public int compareTo(Target o) {
            if (this.stickyInput && !o.stickyInput) {
                return -1;
            }
            if (!this.stickyInput && o.stickyInput) {
                return 1;
            }
            if (this.priority != o.priority) {
                return Integer.compare(o.priority, this.priority);
            }
            return Integer.compare(this.distance, o.distance);
        }
    }
}

