/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.alloy;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.material.alloy.IAlloy;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import org.apache.commons.lang3.StringUtils;

public enum Alloy implements IStringSerializable,
IAlloy
{
    ELECTRICAL_STEEL("electricalSteel", 6.0f, 0xA9A9A9, 1202),
    ENERGETIC_ALLOY("energeticAlloy", 7.0f, 14259020, 855),
    VIBRANT_ALLOY("vibrantAlloy", 4.0f, 11978864, 640),
    REDSTONE_ALLOY("redstoneAlloy", 1.0f, 11609895, 1084),
    CONDUCTIVE_IRON("conductiveIron", 5.2f, 11230559, 1127),
    PULSATING_IRON("pulsatingIron", 7.0f, 2920516, 1132),
    DARK_STEEL("darkSteel", 10.0f, 0x6C6C6C, 1540),
    SOULARIUM("soularium", 10.0f, 6904653, 363),
    END_STEEL("endSteel", 10.0f, 16514227, 940),
    CONSTRUCTION_ALLOY("constructionAlloy", 1.0f, 2693162, 290);

    @Nonnull
    public final String baseName;
    @Nonnull
    private final String oreName;
    private final float hardness;
    private final int color;
    private final int meltingPoint;

    private Alloy(String baseName, float hardness, int color, int meltingPoint) {
        this.baseName = baseName.replaceAll("([A-Z])", "_$0").toLowerCase(Locale.ENGLISH);
        this.oreName = StringUtils.capitalize((String)baseName);
        this.hardness = hardness;
        this.color = color;
        this.meltingPoint = meltingPoint;
    }

    @Override
    @Nonnull
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    @Nonnull
    public String getFluidName() {
        return this.baseName;
    }

    @Override
    public float getHardness() {
        return this.hardness;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getMeltingPoint() {
        return this.meltingPoint;
    }

    @Override
    @Nonnull
    public ItemStack getStackNugget() {
        return this.getStackNugget(1);
    }

    @Override
    @Nonnull
    public ItemStack getStackNugget(int size) {
        return new ItemStack(ModObject.itemAlloyNugget.getItemNN(), size, this.ordinal());
    }

    @Override
    @Nonnull
    public ItemStack getStackIngot() {
        return this.getStackIngot(1);
    }

    @Override
    @Nonnull
    public ItemStack getStackIngot(int size) {
        return new ItemStack(ModObject.itemAlloyIngot.getItemNN(), size, this.ordinal());
    }

    @Override
    @Nonnull
    public ItemStack getStackBall() {
        return this.getStackBall(1);
    }

    @Override
    @Nonnull
    public ItemStack getStackBall(int size) {
        return new ItemStack(ModObject.itemAlloyBall.getItemNN(), size, this.ordinal());
    }

    @Override
    @Nonnull
    public ItemStack getStackBlock() {
        return this.getStackBlock(1);
    }

    @Override
    @Nonnull
    public ItemStack getStackBlock(int size) {
        return new ItemStack(ModObject.blockAlloy.getBlockNN(), size, this.ordinal());
    }

    @Override
    @Nonnull
    public String getOreName() {
        return this.oreName;
    }

    @Override
    @Nonnull
    public String getOreNugget() {
        return "nugget" + this.oreName;
    }

    @Override
    @Nonnull
    public String getOreIngot() {
        return "ingot" + this.oreName;
    }

    @Override
    @Nonnull
    public String getOreBall() {
        return "ball" + this.oreName;
    }

    @Override
    @Nonnull
    public String getOreBlock() {
        return "block" + this.oreName;
    }

    @Nonnull
    public String func_176610_l() {
        return this.baseName;
    }

    @Nonnull
    public static Alloy getTypeFromMeta(int meta) {
        return (Alloy)NullHelper.notnullJ((Object)Alloy.values()[meta >= 0 && meta < Alloy.values().length ? meta : 0], (String)"Enum.values()");
    }

    public static int getMetaFromType(@Nonnull Alloy value) {
        return value.ordinal();
    }
}

