/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.ShapedRecipe;
import crazypants.enderio.base.config.recipes.ShapelessRecipe;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractCrafting;
import crazypants.enderio.base.config.recipes.xml.Grid;
import crazypants.enderio.base.config.recipes.xml.Shapeless;
import crazypants.enderio.base.integration.jei.JeiAccessor;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.util.Strings;

public class Crafting
extends AbstractCrafting {
    private Optional<Grid> grid = this.empty();
    private Optional<Shapeless> shapeless = this.empty();
    private boolean upgrade = false;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.grid.isPresent() == this.shapeless.isPresent()) {
                throw new InvalidRecipeConfigException("Exactly one of either <grid> or <shapeless> must be specified");
            }
            this.valid = this.grid.isPresent() ? this.valid && this.grid.get().isValid() : this.valid && this.shapeless.get().isValid();
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <crafting>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        super.enforceValidity();
        if (this.grid.isPresent()) {
            this.grid.get().enforceValidity();
        } else if (this.shapeless.isPresent()) {
            this.shapeless.get().enforceValidity();
        }
    }

    public static ResourceLocation mkRL(String recipeName) {
        String s = recipeName.replaceAll("[^A-Za-z0-9]", "_").replaceAll("([A-Z])", "_$0").replaceAll("__+", "_").replaceFirst("^_", "").replaceFirst("_$", "").toLowerCase(Locale.ENGLISH);
        ModContainer activeMod = Loader.instance().activeModContainer();
        if (activeMod == null) {
            throw new RuntimeException("I really doubt Mojang would ever use our recipe handler, so something just went really wrong because Forge just told us that we were called by vanilla code...");
        }
        String modId = activeMod.getModId();
        if (modId == null) {
            throw new RuntimeException("Why does a mod without an ID use our recipe handler?");
        }
        return new ResourceLocation(modId, s);
    }

    private void log(String recipeType, String recipeName, ResourceLocation recipeRL, ItemStack result, NNList<Ingredient> nnList) {
        Log.debug("Registering " + recipeType + " for '" + recipeName + "' as '" + recipeRL + "': " + result + ": " + nnList);
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (this.valid && this.active) {
            ResourceLocation recipeRL = Crafting.mkRL(recipeName);
            IForgeRegistry registry = ForgeRegistries.RECIPES;
            if (this.grid.isPresent()) {
                final Grid grid = this.grid.get();
                if (this.upgrade) {
                    this.log("ShapedRecipe.Upgrade", recipeName, recipeRL, this.getOutput().getItemStack(), grid.getIngredients());
                    registry.register((IForgeRegistryEntry)new ShapedRecipe.Upgrade(recipeRL, grid.getWidth(), grid.getHeight(), grid.getIngredients(), this.getOutput().getThing()));
                } else {
                    this.log("ShapedRecipe", recipeName, recipeRL, this.getOutput().getItemStack(), grid.getIngredients());
                    registry.register((IForgeRegistryEntry)new ShapedRecipe(recipeRL, grid.getWidth(), grid.getHeight(), grid.getIngredients(), this.getOutput().getThing()));
                }
                if (this.getOutput().hasAlternatives()) {
                    this.getOutput().getAlternatives().apply((NNList.Callback)new NNList.Callback<ItemStack>(){

                        public void apply(@Nonnull ItemStack alternative) {
                            Log.debug("Providing synthetic alternative recipe to JEI for oredicted output: " + alternative + ": " + grid.getIngredients());
                            JeiAccessor.addAlternativeRecipe((IRecipe)new ShapedRecipes("", grid.getWidth(), grid.getHeight(), grid.getIngredients(), alternative));
                        }
                    });
                }
            } else {
                final Shapeless shapeless = this.shapeless.get();
                if (this.upgrade) {
                    this.log("GenericUpgradeRecipeShapeless", recipeName, recipeRL, this.getOutput().getItemStack(), shapeless.getIngredients());
                    registry.register((IForgeRegistryEntry)new ShapelessRecipe.Upgrade(recipeRL, shapeless.getIngredients(), this.getOutput().getThing()));
                } else {
                    this.log("ShapelessOreRecipe", recipeName, recipeRL, this.getOutput().getItemStack(), shapeless.getIngredients());
                    registry.register((IForgeRegistryEntry)new ShapelessRecipe(recipeRL, shapeless.getIngredients(), this.getOutput().getThing()));
                }
                if (this.getOutput().hasAlternatives()) {
                    this.getOutput().getAlternatives().apply((NNList.Callback)new NNList.Callback<ItemStack>(){

                        public void apply(@Nonnull ItemStack alternative) {
                            Log.debug("Providing synthetic alternative recipe to JEI for oredicted output: " + alternative + ": " + shapeless.getIngredients());
                            JeiAccessor.addAlternativeRecipe((IRecipe)new ShapelessRecipes("", alternative, shapeless.getIngredients()));
                        }
                    });
                }
            }
        } else {
            Log.debug("Skipping Crafting '" + (this.getOutputs().isEmpty() ? "null" : this.getOutput().getItemStack()) + "' (valid=" + this.valid + ", active=" + this.active + ")");
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("upgrade".equals(name)) {
            this.upgrade = !Strings.isBlank((String)value) && !"no".equals(value.toLowerCase(Locale.ENGLISH)) && !"false".equals(value.toLowerCase(Locale.ENGLISH));
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("grid".equals(name) && !this.grid.isPresent()) {
            this.grid = this.of(factory.read(new Grid(), startElement));
            return true;
        }
        if ("shapeless".equals(name) && !this.shapeless.isPresent()) {
            this.shapeless = this.of(factory.read(new Shapeless(), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

