/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.util;

import crazypants.enderio.util.Prep;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public enum NbtValue {
    GLINT("glinted"),
    CAPNAME("capname"),
    CAPNO("capno"),
    FAKE("fake"),
    REMOTE_X("x"),
    REMOTE_Y("y"),
    REMOTE_Z("z"),
    REMOTE_D("d"),
    REMOTE_POS("pos"),
    REMOTE_NAME("name"),
    REMOTE_ICON("icon"),
    ENERGY("Energy"),
    ENERGY_BUFFER("MaxEnergy"),
    FLUIDAMOUNT("famount"),
    BLOCKSTATE("paint"),
    ORIGINAL_STACK("original"),
    PAINT_SOURCE("paintsrc"),
    DISPLAYMODE("displaymode"),
    MAGNET_ACTIVE("magnetActive"),
    LAST_USED_TICK("lastUsedAt"),
    FILTER("filter"),
    FILTER_CLASS("class"),
    FILTER_BLACKLIST("isBlacklist"),
    FILTER_META("matchMeta"),
    FILTER_NBT("matchNBT"),
    FILTER_OREDICT("useOreDict"),
    FILTER_STICKY("sticky"),
    FILTER_ADVANCED("isAdvanced"),
    FILTER_LIMITED("isLimited"),
    FILTER_DAMAGE("damageMode"),
    CONDUIT("conduit"),
    DATAROOT("data"),
    FILTER_BIG("isBig"),
    ENABLED("enabled"),
    INFINITY("infinity"),
    INVENTORY("inv"),
    DSU("dsu");

    @Nonnull
    private final String key;

    private NbtValue(String key) {
        this.key = "enderio:" + key.toLowerCase(Locale.ENGLISH);
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getString(@Nonnull ItemStack stack, @Nonnull String _default) {
        if (Prep.isValid(stack) && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.key)) {
            return stack.func_77978_p().func_74779_i(this.key);
        }
        return _default;
    }

    @Nonnull
    public String getString(@Nonnull ItemStack stack) {
        return this.getString(stack, "");
    }

    @Nonnull
    public ItemStack setString(@Nonnull ItemStack stack, String value) {
        if (Prep.isValid(stack) && value != null) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74778_a(this.key, value);
        } else {
            this.removeTag(stack);
        }
        return stack;
    }

    @Nonnull
    public ItemStack setStringCopy(@Nonnull ItemStack stack, String value) {
        return this.setString(stack.func_77946_l(), value);
    }

    @Nonnull
    public ItemStack setStringCopy(@Nonnull ItemStack stack, String value, int stackSize) {
        ItemStack stack2 = this.setStringCopy(stack, value);
        stack2.func_190920_e(stackSize);
        return stack2;
    }

    public int getInt(@Nonnull ItemStack stack, int _default) {
        if (Prep.isValid(stack) && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.key)) {
            return stack.func_77978_p().func_74762_e(this.key);
        }
        return _default;
    }

    public int getInt(@Nonnull ItemStack stack) {
        return this.getInt(stack, 0);
    }

    @Nonnull
    public ItemStack setInt(@Nonnull ItemStack stack, int value) {
        if (Prep.isValid(stack)) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74768_a(this.key, value);
        }
        return stack;
    }

    @Nonnull
    public ItemStack setIntCopy(@Nonnull ItemStack stack, int value) {
        return this.setInt(stack.func_77946_l(), value);
    }

    @Nonnull
    public ItemStack setIntCopy(@Nonnull ItemStack stack, int value, int stackSize) {
        ItemStack stack2 = this.setIntCopy(stack, value);
        stack2.func_190920_e(stackSize);
        return stack2;
    }

    public long getLong(@Nonnull ItemStack stack, long _default) {
        if (Prep.isValid(stack) && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.key)) {
            return stack.func_77978_p().func_74763_f(this.key);
        }
        return _default;
    }

    public long getLong(@Nonnull ItemStack stack) {
        return this.getLong(stack, 0L);
    }

    @Nonnull
    public ItemStack setLong(@Nonnull ItemStack stack, long value) {
        if (Prep.isValid(stack)) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74772_a(this.key, value);
        }
        return stack;
    }

    @Nonnull
    public ItemStack setLongCopy(@Nonnull ItemStack stack, long value) {
        return this.setLong(stack.func_77946_l(), value);
    }

    @Nonnull
    public ItemStack setLongCopy(@Nonnull ItemStack stack, long value, int stackSize) {
        ItemStack stack2 = this.setLongCopy(stack, value);
        stack2.func_190920_e(stackSize);
        return stack2;
    }

    public boolean getBoolean(@Nonnull ItemStack stack, boolean _default) {
        if (Prep.isValid(stack) && stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.key)) {
            return stack.func_77978_p().func_74767_n(this.key);
        }
        return _default;
    }

    public boolean getBoolean(@Nonnull ItemStack stack) {
        return this.getBoolean(stack, false);
    }

    @Nonnull
    public ItemStack setBoolean(@Nonnull ItemStack stack, boolean value) {
        if (Prep.isValid(stack)) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74757_a(this.key, value);
        }
        return stack;
    }

    @Nonnull
    public ItemStack setBooleanCopy(@Nonnull ItemStack stack, boolean value) {
        return this.setBoolean(stack.func_77946_l(), value);
    }

    @Nonnull
    public ItemStack setBooleanCopy(@Nonnull ItemStack stack, boolean value, int stackSize) {
        ItemStack stack2 = this.setBooleanCopy(stack, value);
        stack2.func_190920_e(stackSize);
        return stack2;
    }

    public boolean hasTag(@Nonnull ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.key);
    }

    @Nonnull
    public ItemStack removeTag(@Nonnull ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.key)) {
            stack.func_77978_p().func_82580_o(this.key);
        }
        return stack;
    }

    @Nonnull
    public ItemStack removeTagCopy(@Nonnull ItemStack stack) {
        return this.removeTag(stack.func_77946_l());
    }

    @Nonnull
    public NBTTagCompound getTag(@Nonnull ItemStack tag) {
        return this.getTag(tag, new NBTTagCompound());
    }

    public NBTTagCompound getTag(@Nonnull ItemStack stack, NBTTagCompound _default) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(this.key)) {
            return (NBTTagCompound)stack.func_77978_p().func_74781_a(this.key);
        }
        this.setTag(stack, _default);
        return _default;
    }

    @Nonnull
    public ItemStack setTag(@Nonnull ItemStack stack, NBTTagCompound value) {
        if (Prep.isValid(stack)) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (value == null) {
                this.removeTag(stack);
            } else {
                stack.func_77978_p().func_74782_a(this.key, (NBTBase)value);
            }
        }
        return stack;
    }

    @Nonnull
    public String getString(@Nullable NBTTagCompound tag, @Nonnull String _default) {
        if (tag != null && tag.func_74764_b(this.key)) {
            return tag.func_74779_i(this.key);
        }
        return _default;
    }

    @Nonnull
    public String getString(@Nullable NBTTagCompound tag) {
        return this.getString(tag, "");
    }

    @Nullable
    public NBTTagCompound setString(@Nullable NBTTagCompound tag, @Nullable String value) {
        if (tag != null && value != null) {
            tag.func_74778_a(this.key, value);
        } else {
            this.removeTag(tag);
        }
        return tag;
    }

    @Nullable
    public NBTTagCompound setStringCopy(@Nullable NBTTagCompound tag, @Nullable String value) {
        return tag != null ? this.setString(tag.func_74737_b(), value) : null;
    }

    public int getInt(@Nullable NBTTagCompound tag, int _default) {
        if (tag != null && tag.func_74764_b(this.key)) {
            return tag.func_74762_e(this.key);
        }
        return _default;
    }

    public int getInt(@Nullable NBTTagCompound tag) {
        return this.getInt(tag, 0);
    }

    @Nullable
    public NBTTagCompound setInt(@Nullable NBTTagCompound tag, int value) {
        if (tag != null) {
            tag.func_74768_a(this.key, value);
        }
        return tag;
    }

    @Nullable
    public NBTTagCompound setIntCopy(@Nullable NBTTagCompound tag, int value) {
        return tag != null ? this.setInt(tag.func_74737_b(), value) : null;
    }

    public long getLong(@Nullable NBTTagCompound tag, long _default) {
        if (tag != null && tag.func_74764_b(this.key)) {
            return tag.func_74763_f(this.key);
        }
        return _default;
    }

    public long getLong(@Nullable NBTTagCompound tag) {
        return this.getLong(tag, 0L);
    }

    @Nullable
    public NBTTagCompound setLong(@Nullable NBTTagCompound tag, long value) {
        if (tag != null) {
            tag.func_74772_a(this.key, value);
        }
        return tag;
    }

    @Nullable
    public NBTTagCompound setLongCopy(@Nullable NBTTagCompound tag, long value) {
        return tag != null ? this.setLong(tag.func_74737_b(), value) : null;
    }

    public boolean getBoolean(@Nullable NBTTagCompound tag, boolean _default) {
        if (tag != null && tag.func_74764_b(this.key)) {
            return tag.func_74767_n(this.key);
        }
        return _default;
    }

    public boolean getBoolean(@Nullable NBTTagCompound tag) {
        return this.getBoolean(tag, false);
    }

    @Nullable
    public NBTTagCompound setBoolean(@Nullable NBTTagCompound tag, boolean value) {
        if (tag != null) {
            tag.func_74757_a(this.key, value);
        }
        return tag;
    }

    @Nullable
    public NBTTagCompound setBooleanCopy(@Nullable NBTTagCompound tag, boolean value) {
        return tag != null ? this.setBoolean(tag.func_74737_b(), value) : null;
    }

    @Nonnull
    public BlockPos getBlockPos(@Nullable NBTTagCompound tag, @Nonnull BlockPos _default) {
        return BlockPos.func_177969_a((long)this.getLong(tag, _default.func_177986_g()));
    }

    @Nonnull
    public BlockPos getBlockPos(@Nullable NBTTagCompound tag) {
        return BlockPos.func_177969_a((long)this.getLong(tag, 0L));
    }

    @Nullable
    public NBTTagCompound setBlockPos(@Nullable NBTTagCompound tag, @Nonnull BlockPos value) {
        return this.setLong(tag, value.func_177986_g());
    }

    @Nullable
    public NBTTagCompound setBlockPosCopy(@Nullable NBTTagCompound tag, @Nonnull BlockPos value) {
        return this.setLongCopy(tag, value.func_177986_g());
    }

    @Nonnull
    public ItemStack getStack(@Nullable NBTTagCompound tag, @Nonnull ItemStack _default) {
        if (tag != null && tag.func_74764_b(this.key)) {
            return new ItemStack(tag.func_74775_l(this.key));
        }
        return _default;
    }

    @Nonnull
    public ItemStack getStack(@Nullable NBTTagCompound tag) {
        return this.getStack(tag, Prep.getEmpty());
    }

    @Nullable
    public NBTTagCompound setStack(@Nullable NBTTagCompound tag, @Nonnull ItemStack value) {
        if (tag != null) {
            tag.func_74782_a(this.key, (NBTBase)value.func_77955_b(new NBTTagCompound()));
        }
        return tag;
    }

    @Nullable
    public NBTTagCompound setStackCopy(@Nullable NBTTagCompound tag, @Nonnull ItemStack value) {
        return tag != null ? this.setStack(tag.func_74737_b(), value) : null;
    }

    @Nonnull
    public ItemStack getStack(@Nonnull ItemStack stack, @Nonnull ItemStack _default) {
        if (this.hasTag(stack)) {
            return new ItemStack(this.getTag(stack));
        }
        return _default;
    }

    @Nonnull
    public ItemStack getStack(@Nonnull ItemStack stack) {
        return this.getStack(stack, Prep.getEmpty());
    }

    @Nonnull
    public ItemStack setStack(@Nonnull ItemStack stack, @Nonnull ItemStack value) {
        return this.setTag(stack, value.func_77955_b(new NBTTagCompound()));
    }

    @Nonnull
    public ItemStack setStackCopy(@Nonnull ItemStack stack, @Nonnull ItemStack value) {
        return this.setStack(stack.func_77946_l(), value);
    }

    public boolean hasTag(@Nullable NBTTagCompound tag) {
        return tag != null && tag.func_74764_b(this.key);
    }

    @Nullable
    public NBTTagCompound removeTag(@Nullable NBTTagCompound tag) {
        if (tag != null && tag.func_74764_b(this.key)) {
            tag.func_82580_o(this.key);
        }
        return tag;
    }

    @Nullable
    public NBTTagCompound removeTagCopy(@Nullable NBTTagCompound tag) {
        return tag != null ? this.removeTag(tag.func_74737_b()) : null;
    }

    @Nullable
    public NBTTagCompound getTag(@Nullable NBTTagCompound tag) {
        return this.getTag(tag, new NBTTagCompound());
    }

    @Nullable
    public NBTTagCompound getTag(@Nullable NBTTagCompound tag, @Nullable NBTTagCompound _default) {
        if (tag != null && tag.func_74764_b(this.key)) {
            return (NBTTagCompound)tag.func_74781_a(this.key);
        }
        this.setTag(tag, _default);
        return _default;
    }

    public NBTTagCompound setTag(@Nullable NBTTagCompound tag, @Nullable NBTTagCompound value) {
        if (tag != null) {
            if (value == null) {
                this.removeTag(tag);
            } else {
                tag.func_74782_a(this.key, (NBTBase)value);
            }
        }
        return tag;
    }

    @Nonnull
    public static NBTTagCompound getOrCreateRoot(@Nonnull ItemStack stack) {
        if (Prep.isValid(stack)) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            return stack.func_77978_p();
        }
        return new NBTTagCompound();
    }

    @Nonnull
    public static NBTTagCompound getReadOnlyRoot(@Nonnull ItemStack stack) {
        if (Prep.isValid(stack) && stack.func_77942_o()) {
            return stack.func_77978_p();
        }
        return new NBTTagCompound();
    }
}

