/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.util;

import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;

public final class ColorUtil {
    public static int getRGB(@Nonnull Color color) {
        return ColorUtil.getRGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int getRGBA(@Nonnull Color color) {
        return ColorUtil.getRGBA(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static int getARGB(@Nonnull Color color) {
        return ColorUtil.getRGBA(color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int getRGB(float r, float g, float b) {
        return ColorUtil.getRGB((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public static int getRGBA(float r, float g, float b, float a) {
        return ColorUtil.getRGBA((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public static int getARGB(float r, float g, float b, float a) {
        return ColorUtil.getARGB((int)(a * 255.0f), (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public static int getRGB(int r, int g, int b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int getARGB(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int getRGBA(int r, int g, int b, int a) {
        return (r & 0xFF) << 24 | (g & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static int toHex(int r, int g, int b) {
        int hex = 0;
        hex |= r << 16;
        hex |= g << 8;
        return hex |= b;
    }

    private ColorUtil() {
    }
}

