/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.monitor;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.conduits.conduit.power.NetworkPowerManager;
import crazypants.enderio.powertools.machine.monitor.TilePowerMonitor;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketPowerMonitorStatData
extends MessageTileEntity<TilePowerMonitor> {
    private TilePowerMonitor.StatData data = null;

    public PacketPowerMonitorStatData() {
    }

    private PacketPowerMonitorStatData(@Nonnull TilePowerMonitor tile) {
        super((TileEntity)tile);
    }

    public static IMessage requestUpdate(@Nonnull TilePowerMonitor te) {
        PacketPowerMonitorStatData msg = new PacketPowerMonitorStatData(te);
        return msg;
    }

    public static IMessage sendUpdate(@Nonnull TilePowerMonitor te, TilePowerMonitor.StatData data) {
        PacketPowerMonitorStatData msg = new PacketPowerMonitorStatData(te);
        msg.data = data;
        return msg;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readByte() != 1) {
            this.data = null;
        } else {
            this.data = new TilePowerMonitor.StatData();
            this.data.powerInConduits = buf.readLong();
            this.data.maxPowerInConduits = buf.readLong();
            this.data.powerInCapBanks = buf.readLong();
            this.data.maxPowerInCapBanks = buf.readLong();
            this.data.powerInMachines = buf.readLong();
            this.data.maxPowerInMachines = buf.readLong();
            this.data.aveRfSent = buf.readFloat();
            this.data.aveRfReceived = buf.readFloat();
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.data == null) {
            buf.writeByte(0);
        } else {
            buf.writeByte(1);
            buf.writeLong(this.data.powerInConduits);
            buf.writeLong(this.data.maxPowerInConduits);
            buf.writeLong(this.data.powerInCapBanks);
            buf.writeLong(this.data.maxPowerInCapBanks);
            buf.writeLong(this.data.powerInMachines);
            buf.writeLong(this.data.maxPowerInMachines);
            buf.writeFloat(this.data.aveRfSent);
            buf.writeFloat(this.data.aveRfReceived);
        }
    }

    public static class ClientHandler
    implements IMessageHandler<PacketPowerMonitorStatData, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketPowerMonitorStatData msg, MessageContext ctx) {
            TilePowerMonitor te;
            EntityPlayer player = EnderIO.proxy.getClientPlayer();
            if (player != null && (te = (TilePowerMonitor)msg.getTileEntity(player.field_70170_p)) != null) {
                te.statData = msg.data;
            }
            return null;
        }
    }

    public static class ServerHandler
    implements IMessageHandler<PacketPowerMonitorStatData, IMessage> {
        public IMessage onMessage(PacketPowerMonitorStatData msg, MessageContext ctx) {
            NetworkPowerManager powerManager;
            TilePowerMonitor te = (TilePowerMonitor)msg.getTileEntity(ctx.getServerHandler().field_147369_b.field_70170_p);
            if (te != null && (powerManager = te.getPowerManager()) != null) {
                return PacketPowerMonitorStatData.sendUpdate(te, new TilePowerMonitor.StatData(powerManager));
            }
            return null;
        }
    }
}

