/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.tic.materials;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.material.alloy.IAlloy;
import crazypants.enderio.integration.tic.traits.TraitPickup;
import crazypants.enderio.integration.tic.traits.TraitTeleport;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.Fluid;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTraits;

public class TicMaterials {
    private static final Map<IAlloy, Data> DATA = new HashMap<IAlloy, Data>();

    public static boolean hasIntegration(IAlloy alloy) {
        return DATA.get(alloy) != null;
    }

    public static void addIntegration(IAlloy alloy) {
        DATA.put(alloy, new Data(){

            @Override
            public void traits() {
            }

            @Override
            public void stats() {
            }
        });
    }

    @Nonnull
    public static Data getData(IAlloy alloy) {
        return (Data)NullHelper.notnull((Object)DATA.get(alloy), (String)"TRAIT AWOL");
    }

    static {
        DATA.put(Alloy.ELECTRICAL_STEEL, new Data(){

            @Override
            public void traits() {
                this.getMaterial().addTrait((ITrait)TinkerTraits.lightweight);
                this.getMaterial().addTrait((ITrait)TinkerTraits.shocking, "head");
            }

            @Override
            public void stats() {
                TinkerRegistry.addMaterialStats((Material)this.getMaterial(), (IMaterialStats)new HeadMaterialStats(306, 6.5f, 2.25f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.75f, 80), new ExtraMaterialStats(75), new BowMaterialStats(1.5f, 0.9f, 1.0f)});
            }
        });
        DATA.put(Alloy.ENERGETIC_ALLOY, new Data(){

            @Override
            public void traits() {
                this.getMaterial().addTrait((ITrait)TinkerTraits.petramor);
                this.getMaterial().addTrait((ITrait)TinkerTraits.unnatural, "head");
                this.getMaterial().addTrait((ITrait)TinkerTraits.holy, "handle");
            }

            @Override
            public void stats() {
                TinkerRegistry.addMaterialStats((Material)this.getMaterial(), (IMaterialStats)new HeadMaterialStats(690, 2.5f, 5.6f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(2.0f, -800), new ExtraMaterialStats(400), new BowMaterialStats(0.5f, 0.8f, 1.0f)});
            }
        });
        DATA.put(Alloy.VIBRANT_ALLOY, new Data(){

            @Override
            public void traits() {
                this.getMaterial().addTrait((ITrait)TraitPickup.instance);
                this.getMaterial().addTrait((ITrait)TraitTeleport.instance4, "head");
            }

            @Override
            public void stats() {
                TinkerRegistry.addMaterialStats((Material)this.getMaterial(), (IMaterialStats)new HeadMaterialStats(220, 3.5f, 9.0f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.5f, -50), new ExtraMaterialStats(60), new BowMaterialStats(0.75f, 1.0f, 5.0f)});
            }
        });
        DATA.put(Alloy.REDSTONE_ALLOY, new Data(){

            @Override
            public void traits() {
                this.getMaterial().addTrait((ITrait)TinkerTraits.crude);
                this.getMaterial().addTrait((ITrait)TinkerTraits.shocking, "head");
                this.getMaterial().addTrait((ITrait)TinkerTraits.writable, "handle");
            }

            @Override
            public void stats() {
                TinkerRegistry.addMaterialStats((Material)this.getMaterial(), (IMaterialStats)new HeadMaterialStats(120, 2.5f, 1.5f, 0), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.0f, -5), new ExtraMaterialStats(150), new BowMaterialStats(2.5f, 0.4f, 0.0f)});
            }
        });
        DATA.put(Alloy.CONDUCTIVE_IRON, new Data(){

            @Override
            public void traits() {
                this.getMaterial().addTrait((ITrait)TinkerTraits.lightweight);
                this.getMaterial().addTrait((ITrait)TinkerTraits.crude2, "head");
            }

            @Override
            public void stats() {
                TinkerRegistry.addMaterialStats((Material)this.getMaterial(), (IMaterialStats)new HeadMaterialStats(106, 6.75f, 1.25f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.25f, 100), new ExtraMaterialStats(250), new BowMaterialStats(1.5f, 0.9f, 1.25f)});
            }
        });
        DATA.put(Alloy.PULSATING_IRON, new Data(){

            @Override
            public void traits() {
                this.getMaterial().addTrait((ITrait)TraitTeleport.instance1);
                this.getMaterial().addTrait((ITrait)TraitTeleport.instance2, "handle");
                this.getMaterial().addTrait((ITrait)TraitTeleport.instance3, "extra");
                this.getMaterial().addTrait((ITrait)TraitTeleport.instance0, "head");
                this.getMaterial().addTrait((ITrait)TinkerTraits.poisonous, "projectile");
            }

            @Override
            public void stats() {
                TinkerRegistry.addMaterialStats((Material)this.getMaterial(), (IMaterialStats)new HeadMaterialStats(920, 6.0f, 2.0f, 1), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.05f, 250), new ExtraMaterialStats(250), new BowMaterialStats(0.25f, 3.5f, 6.0f)});
            }
        });
        DATA.put(Alloy.DARK_STEEL, new Data(){

            @Override
            public void traits() {
                this.getMaterial().addTrait((ITrait)TinkerTraits.unnatural);
                this.getMaterial().addTrait((ITrait)TinkerTraits.enderference, "head");
                this.getMaterial().addTrait((ITrait)TinkerTraits.dense, "extra");
                this.getMaterial().addTrait((ITrait)TinkerTraits.dense, "bow");
            }

            @Override
            public void stats() {
                TinkerRegistry.addMaterialStats((Material)this.getMaterial(), (IMaterialStats)new HeadMaterialStats(550, 7.0f, 6.0f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 150), new ExtraMaterialStats(250), new BowMaterialStats(0.3f, 2.5f, 9.0f)});
            }
        });
        DATA.put(Alloy.SOULARIUM, new Data(){

            @Override
            public void traits() {
                this.getMaterial().addTrait((ITrait)TinkerTraits.duritos);
                this.getMaterial().addTrait((ITrait)TinkerTraits.hellish, "head");
                this.getMaterial().addTrait((ITrait)TinkerTraits.splinters, "extra");
                this.getMaterial().addTrait((ITrait)TinkerTraits.flammable, "handle");
                this.getMaterial().addTrait((ITrait)TinkerTraits.writable, "bowstring");
            }

            @Override
            public void stats() {
                TinkerRegistry.addMaterialStats((Material)this.getMaterial(), (IMaterialStats)new HeadMaterialStats(1555, 1.0f, 1.0f, 0), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.5f, 1500), new ExtraMaterialStats(1250), new BowMaterialStats(0.1f, 0.5f, 0.0f), new BowStringMaterialStats(0.75f)});
            }
        });
        DATA.put(Alloy.END_STEEL, new Data(){

            @Override
            public void traits() {
                this.getMaterial().addTrait((ITrait)TinkerTraits.unnatural);
                this.getMaterial().addTrait((ITrait)TinkerTraits.enderference, "head");
                this.getMaterial().addTrait((ITrait)TinkerTraits.alien, "head");
            }

            @Override
            public void stats() {
                TinkerRegistry.addMaterialStats((Material)this.getMaterial(), (IMaterialStats)new HeadMaterialStats(400, 8.25f, 5.0f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 50), new ExtraMaterialStats(150), new BowMaterialStats(0.3f, 2.5f, 9.0f)});
            }
        });
        DATA.put(Alloy.CONSTRUCTION_ALLOY, new Data(){

            @Override
            public void traits() {
                this.getMaterial().addTrait((ITrait)TinkerTraits.cheapskate);
            }

            @Override
            public void stats() {
                TinkerRegistry.addMaterialStats((Material)this.getMaterial(), (IMaterialStats)new HeadMaterialStats(50, 1.25f, 1.0f, 1), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.5f, 10), new ExtraMaterialStats(10), new BowMaterialStats(3.0f, 0.5f, 0.0f)});
            }
        });
    }

    public static abstract class Data {
        private Fluid fluid;
        private Material material;

        public abstract void traits();

        public abstract void stats();

        @Nonnull
        public Fluid getFluid() {
            return (Fluid)NullHelper.notnull((Object)this.fluid, (String)"FLUID AWOL");
        }

        public void setFluid(Fluid fluid) {
            this.fluid = fluid;
        }

        @Nonnull
        public Material getMaterial() {
            return (Material)NullHelper.notnull((Object)this.material, (String)"MATERIAL AWOL");
        }

        public void setMaterial(Material material) {
            this.material = material;
        }
    }
}

