/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.registry;

import crazypants.enderio.base.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public final class TextureRegistry {
    @Nonnull
    private static final Map<ResourceLocation, Object> sprites = new HashMap<ResourceLocation, Object>();
    private static boolean locked = false;
    private static Function<ResourceLocation, Object> fallback = key -> {
        throw new UnsupportedOperationException("TextureRegistry: Texture is accessed too early (or on a dedicated server): " + key);
    };

    @Nonnull
    protected static Map<ResourceLocation, Object> getSprites() {
        return sprites;
    }

    protected static void lock(Function<ResourceLocation, Object> fallbackIn) {
        locked = true;
        fallback = fallbackIn;
    }

    @Nonnull
    public static TextureSupplier registerTexture(@Nonnull String location, boolean prependDomain) {
        final ResourceLocation key = new ResourceLocation(prependDomain ? "enderio:" + location : location);
        Log.debug("registerTexture ", key);
        if (locked) {
            throw new UnsupportedOperationException("TextureRegistry: Texture is registered too late: " + key);
        }
        if (!sprites.containsKey(key)) {
            sprites.put(key, null);
        }
        return new TextureSupplier(){

            @Override
            @Nonnull
            public <T> T get(@Nonnull Class<T> clazz) {
                Function[] functionArray = new Function[3];
                functionArray[0] = sprites::get;
                functionArray[1] = fallback;
                functionArray[2] = unused -> {
                    throw new UnsupportedOperationException("TextureRegistry can only supply TextureAtlasSprite");
                };
                return (T)TextureRegistry.first(clazz, key, functionArray);
            }
        };
    }

    @SafeVarargs
    @Nonnull
    private static final <P> P first(@Nonnull Class<P> clazz, @Nonnull ResourceLocation key, Function<ResourceLocation, ?> ... o) {
        for (Function<ResourceLocation, ?> on : o) {
            Object p = on.apply(key);
            if (!clazz.isInstance(p)) continue;
            return (P)p;
        }
        throw new NullPointerException();
    }

    @Nonnull
    public static TextureSupplier registerTexture(@Nonnull String location) {
        return TextureRegistry.registerTexture(location, true);
    }

    public static interface TextureSupplier {
        @Nonnull
        public <T> T get(@Nonnull Class<T> var1);
    }
}

