/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.storage;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.util.Prep;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class UpgradeCap
implements IItemHandler {
    @Nonnull
    protected final NNList<IDarkSteelUpgrade> stacks = new NNList();
    @Nonnull
    protected final EntityEquipmentSlot equipmentSlot;
    @Nonnull
    protected final ItemStack owner;
    @Nonnull
    protected final IDarkSteelItem item;
    @Nonnull
    protected final EntityPlayer player;

    public UpgradeCap(@Nonnull EntityEquipmentSlot equipmentSlot, @Nonnull EntityPlayer player) {
        this.equipmentSlot = equipmentSlot;
        this.player = player;
        this.owner = player.func_184582_a(equipmentSlot);
        if (this.owner.func_77973_b() instanceof IDarkSteelItem) {
            this.item = (IDarkSteelItem)this.getOwner().func_77973_b();
            UpgradeRegistry.getUpgrades().stream().filter(upgrade -> upgrade.getRules().stream().filter(rule -> rule instanceof IDarkSteelUpgrade.IRule.StaticRule).allMatch(rule -> rule.check(this.owner, this.item).passes())).forEachOrdered(arg_0 -> this.stacks.add(arg_0));
        } else {
            this.stacks.clear();
            this.item = (IDarkSteelItem)ModObject.itemDarkSteelChestplate.getItemNN();
        }
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return ((IDarkSteelUpgrade)this.stacks.get(slot)).hasUpgrade(this.getOwner()) ? ((IDarkSteelUpgrade)this.stacks.get(slot)).getUpgradeItem() : Prep.getEmpty();
    }

    @Nonnull
    public ItemStack getUpgradeItem(int slot) {
        this.validateSlotIndex(slot);
        return ((IDarkSteelUpgrade)this.stacks.get(slot)).getUpgradeItem();
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return stack;
        }
        this.validateSlotIndex(slot);
        IDarkSteelUpgrade upgrade = (IDarkSteelUpgrade)this.stacks.get(slot);
        boolean existing = upgrade.hasUpgrade(this.getOwner());
        if (existing || !upgrade.isUpgradeItem(stack) || upgrade.getRules().stream().allMatch(rule -> rule.check(this.getOwner(), this.item).passes())) {
            return stack;
        }
        if (!simulate && !this.player.field_70170_p.field_72995_K) {
            upgrade.addToItem(this.getOwner(), this.item);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - 1));
    }

    public boolean canInsert(int slot) {
        this.validateSlotIndex(slot);
        IDarkSteelUpgrade upgrade = (IDarkSteelUpgrade)this.stacks.get(slot);
        if (upgrade.hasUpgrade(this.getOwner())) {
            return false;
        }
        return upgrade.getRules().stream().map(rule -> rule.check(this.getOwner(), this.item)).allMatch(rule -> rule.passes());
    }

    @Nullable
    public List<ITextComponent> checkInsert(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        this.validateSlotIndex(slot);
        IDarkSteelUpgrade upgrade = (IDarkSteelUpgrade)this.stacks.get(slot);
        if (upgrade.hasUpgrade(this.getOwner()) || !upgrade.isUpgradeItem(stack)) {
            return null;
        }
        return upgrade.getRules().stream().map(rule -> rule.check(this.getOwner(), this.item)).filter(result -> result.hasResult()).map(result -> result.getResult()).collect(Collectors.toList());
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        IDarkSteelUpgrade upgrade = (IDarkSteelUpgrade)this.stacks.get(slot);
        boolean existing = upgrade.hasUpgrade(this.getOwner());
        if (!existing || !this.stacks.stream().filter(up -> up != upgrade && up.hasUpgrade(this.getOwner())).allMatch(up -> up.canOtherBeRemoved(this.getOwner(), this.item, upgrade))) {
            return ItemStack.field_190927_a;
        }
        if (!simulate && !this.player.field_70170_p.field_72995_K) {
            upgrade.removeFromItem(this.getOwner(), this.item);
        }
        return upgrade.getUpgradeItem();
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    public boolean isStillConnectedToPlayer() {
        if (this.player.field_70170_p.field_72995_K) {
            return this.player.func_184582_a(this.equipmentSlot).func_77973_b() == this.owner.func_77973_b();
        }
        return this.owner == this.player.func_184582_a(this.equipmentSlot);
    }

    @Nonnull
    protected ItemStack getOwner() {
        ItemStack current;
        if (this.player.field_70170_p.field_72995_K && (current = this.player.func_184582_a(this.equipmentSlot)).func_77973_b() == this.owner.func_77973_b()) {
            return current;
        }
        return this.owner;
    }
}

