/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.explosive;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.explosive.ExplosiveUpgrade;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public class ExplosiveDepthUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "depth";
    @Nonnull
    public static final ExplosiveDepthUpgrade INSTANCE = new ExplosiveDepthUpgrade();

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
    }

    public ExplosiveDepthUpgrade() {
        super(UPGRADE_NAME, "enderio.darksteel.upgrade.depth", DarkSteelConfig.explosiveDepthUpgradeCost);
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return ExplosiveUpgrade.INSTANCE.hasAnyUpgradeVariant(stack) && !this.hasUpgrade(stack);
    }

    @Override
    @Nonnull
    public List<IDarkSteelUpgrade> getDependencies() {
        return new NNList((Object[])new IDarkSteelUpgrade[]{ExplosiveUpgrade.INSTANCE});
    }

    @Override
    @Nonnull
    public List<Supplier<String>> getItemClassesForTooltip() {
        return ExplosiveUpgrade.INSTANCE.getItemClassesForTooltip();
    }

    @Override
    public boolean canOtherBeRemoved(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull IDarkSteelUpgrade other) {
        return other != ExplosiveUpgrade.INSTANCE;
    }
}

