/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.fertilizer;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.farm.IFertilizer;
import crazypants.enderio.api.farm.IFertilizerResult;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class AbstractFertilizer
extends IForgeRegistryEntry.Impl<IFertilizer>
implements IFertilizer {
    @Nonnull
    protected final ItemStack fertilizer;

    protected AbstractFertilizer(@Nullable Item item) {
        this(item == null ? Prep.getEmpty() : new ItemStack(item));
    }

    protected AbstractFertilizer(@Nullable Block block) {
        this(block == null ? Prep.getEmpty() : new ItemStack(block));
    }

    protected AbstractFertilizer(@Nonnull ItemStack stack) {
        this.fertilizer = stack;
        if (Prep.isValid(this.fertilizer)) {
            this.setRegistryName(this.fertilizer.func_77973_b().getRegistryName());
        }
    }

    public boolean isValid() {
        return Prep.isValid(this.fertilizer);
    }

    @Override
    public boolean matches(@Nonnull ItemStack stack) {
        return OreDictionary.itemMatches((ItemStack)this.fertilizer, (ItemStack)stack, (boolean)false);
    }

    @Override
    public abstract IFertilizerResult apply(@Nonnull ItemStack var1, @Nonnull EntityPlayer var2, @Nonnull World var3, @Nonnull BlockPos var4);

    @Override
    public boolean applyOnAir() {
        return false;
    }

    @Override
    public boolean applyOnPlant() {
        return true;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getGuiItem() {
        return new NNList((Object[])new ItemStack[]{this.fertilizer});
    }
}

