/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.config.recipes.IRecipeConfigElement;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class Fluid
implements IRecipeConfigElement {
    protected Optional<String> name = this.empty();
    protected Optional<String> nbt = this.empty();
    protected transient Optional<net.minecraftforge.fluids.Fluid> fluid = this.empty();
    protected transient Optional<NBTTagCompound> tag = this.empty();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (!this.name.isPresent()) {
            throw new InvalidRecipeConfigException("Missing fluid name");
        }
        this.fluid = this.ofNullable(FluidRegistry.getFluid((String)this.get(this.name)));
        if (this.nbt.isPresent()) {
            try {
                this.tag = this.of(JsonToNBT.func_180713_a((String)this.get(this.nbt)));
            }
            catch (NBTException e) {
                throw new InvalidRecipeConfigException("'" + this.nbt.get() + "' is not valid NBT json");
            }
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (!this.isValid()) {
            throw new InvalidRecipeConfigException("Could not find a fluid for '" + this.name.get());
        }
    }

    @Override
    public boolean isValid() {
        return this.fluid.isPresent();
    }

    public net.minecraftforge.fluids.Fluid getFluid() {
        return this.get(this.fluid);
    }

    public FluidStack getFluidStack() {
        return new FluidStack(this.fluid.get(), 1000, (NBTTagCompound)this.tag.orElse(null));
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("name".equals(name)) {
            this.name = this.ofString(value);
            return true;
        }
        if ("nbt".equals(name)) {
            this.nbt = this.ofString(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }
}

