/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.config.recipes.IRecipeConfigElement;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import java.util.Locale;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class ConditionConfig
implements IRecipeConfigElement {
    private Optional<String> section = this.empty();
    private Optional<String> name = this.empty();
    private boolean value;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (!this.section.isPresent()) {
            throw new InvalidRecipeConfigException("Missing section");
        }
        this.section = this.of(this.section.get().toLowerCase(Locale.ENGLISH));
        if (!this.name.isPresent()) {
            throw new InvalidRecipeConfigException("Missing name");
        }
        if (!EnderIO.getInstance().getConfiguration().hasKey(this.get(this.section), this.get(this.name))) {
            throw new InvalidRecipeConfigException("Unknown config value '" + this.section.get() + ":" + this.name.get() + "'");
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return EnderIO.getInstance().getConfiguration().getCategory(this.get(this.section)).get(this.get(this.name)).getBoolean() == this.value;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("section".equals(name)) {
            this.section = this.ofString(value);
            return true;
        }
        if ("name".equals(name)) {
            this.name = this.ofString(value);
            return true;
        }
        if ("value".equals(name)) {
            this.value = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
    }
}

