/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.bettermodlist;

import com.enderio.core.EnderCore;
import com.enderio.core.common.config.ConfigHandler;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.client.GuiScrollingList;
import cpw.mods.fml.client.GuiSlotModList;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.StringUtils;

public class GuiEnhancedModList
extends GuiModList {
    private static Field _mods;
    private static Field _selected;
    private static Field _selectedMod;
    private static Field _modList;
    private static Field _modListRight;
    private static Field _modListBottom;
    private static Field _modListMods;
    private static Field _listWidth;
    private static Field _scrollDistance;
    private int buttonMargin = 1;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private GuiTextField search;
    private boolean sorted = false;
    private SortType sortType = SortType.values()[ConfigHandler.defaultModSort];

    public GuiEnhancedModList(GuiScreen mainMenu) {
        super(mainMenu);
    }

    public void func_73866_w_() {
        float scroll = 0.0f;
        if (this.getGuiModList() != null) {
            scroll = this.getGuiModListScroll();
        }
        super.func_73866_w_();
        for (GuiButton button : this.field_146292_n) {
            if (button.field_146127_k == 6) {
                int min = this.getGuiModListRight();
                int max = this.field_146294_l;
                button.field_146128_h = (min + max) / 2 - button.field_146120_f / 2;
                button.field_146129_i += 10;
                continue;
            }
            if (button.field_146127_k != 20 && button.field_146127_k != 21) continue;
            button.field_146129_i += 10;
        }
        this.setGuiModListBottom(this.getGuiModListBottom() - 25);
        if (this.search == null) {
            this.search = new GuiTextField(this.field_146297_k.field_71466_p, 12, this.getGuiModListBottom() + 17, this.getListWidth() - 4, 14);
            this.search.func_146195_b(true);
            this.search.func_146205_d(true);
        }
        int width = this.getListWidth() / this.numButtons;
        int x = 10;
        int y = 10;
        GuiButton normalSort = new GuiButton(SortType.NORMAL.buttonID, x, y, width - this.buttonMargin, 20, EnderCore.lang.localize("gui.normal"));
        normalSort.field_146124_l = false;
        this.field_146292_n.add(normalSort);
        this.field_146292_n.add(new GuiButton(SortType.A_TO_Z.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "A-Z"));
        this.field_146292_n.add(new GuiButton(SortType.Z_TO_A.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "Z-A"));
        this.field_146292_n.add(new InfoButton());
        this.reloadMods();
        this.disableButton();
        this.setGuiModListScroll(scroll);
    }

    public int drawLine(String line, int offset, int shifty) {
        String before = line.substring(0, line.indexOf(58) + 2);
        int followingLineOffset = this.field_146289_q.func_78256_a(before);
        String[] manualSplit = line.split("\n");
        ArrayList split = Lists.newArrayList();
        for (String s : manualSplit) {
            split.addAll(this.field_146289_q.func_78271_c(s, this.field_146294_l - offset));
        }
        for (int i = 0; i < split.size(); ++i) {
            this.field_146289_q.func_78276_b((String)split.get(i), offset + (i > 0 ? followingLineOffset : 0), shifty, 14151146);
            shifty += 10;
        }
        if (split.size() > 1) {
            shifty += 10;
        }
        return shifty;
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.search.func_146192_a(x, y, button);
        if (button == 1 && x >= this.search.field_146209_f && x < this.search.field_146209_f + this.search.field_146218_h && y >= this.search.field_146210_g && y < this.search.field_146210_g + this.search.field_146219_i) {
            this.search.func_146180_a("");
        }
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        super.func_73869_a(p_73869_1_, p_73869_2_);
        this.search.func_146201_a(p_73869_1_, p_73869_2_);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.search.func_146178_a();
        if (!this.search.func_146179_b().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadMods();
            Collections.sort(this.getMods(), this.sortType.comparator);
            this.setMods();
            this.sorted = true;
        }
    }

    private void reloadMods() {
        List<ModContainer> mods = this.getMods();
        mods.clear();
        for (ModContainer m : Loader.instance().getActiveModList()) {
            if (!m.getName().toLowerCase(Locale.US).contains(this.search.func_146179_b().toLowerCase(Locale.US)) || m.getMetadata().parentMod != null) continue;
            mods.add(m);
        }
        this.setMods();
        this.lastFilterText = this.search.func_146179_b();
    }

    public void func_73863_a(int p_571_1_, int p_571_2_, float p_571_3_) {
        super.func_73863_a(p_571_1_, p_571_2_, p_571_3_);
        String text = EnderCore.lang.localize("gui.search");
        int x = (10 + this.getGuiModListRight()) / 2 - this.field_146297_k.field_71466_p.func_78256_a(text) / 2;
        this.field_146297_k.field_71466_p.func_78276_b(text, x, this.getGuiModListBottom() + 5, 0xFFFFFF);
        this.search.func_146194_f();
    }

    protected void func_146284_a(GuiButton button) {
        SortType type;
        super.func_146284_a(button);
        if (button.field_146127_k == 30) {
            this.search.func_146180_a("");
            this.reloadMods();
            for (ModContainer m : this.getMods()) {
                if (!m.getName().equals("EnderCore")) continue;
                this.setSelectedMod(m);
                this.setMods();
            }
        }
        if ((type = SortType.getTypeForButton(button)) == null) {
            return;
        }
        this.sorted = false;
        this.sortType = type;
        this.disableButton();
        this.setMods();
    }

    private void disableButton() {
        for (GuiButton b : this.field_146292_n) {
            if (SortType.getTypeForButton(b) != null) {
                b.field_146124_l = true;
            }
            if (b.field_146127_k != this.sortType.buttonID) continue;
            b.field_146124_l = false;
        }
    }

    private void setMods() {
        List<ModContainer> mods = this.getMods();
        ModContainer sel = this.getSelectedMod();
        boolean found = false;
        try {
            for (int i = 0; !found && i < mods.size(); ++i) {
                if (sel != mods.get(i)) continue;
                _selected.setInt((Object)this, i);
                found = true;
            }
            if (!found) {
                _selected.setInt((Object)this, -1);
                _selectedMod.set((Object)this, null);
            }
            _mods.set((Object)this, this.getMods());
            this.sorted = false;
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private GuiSlotModList getGuiModList() {
        try {
            return (GuiSlotModList)_modList.get((Object)this);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private int getGuiModListRight() {
        try {
            return _modListRight.getInt(this.getGuiModList());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void setGuiModListBottom(int bottom) {
        try {
            _modListBottom.set(this.getGuiModList(), bottom);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private int getGuiModListBottom() {
        try {
            return _modListBottom.getInt(this.getGuiModList());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private float getGuiModListScroll() {
        try {
            return _scrollDistance.getFloat(this.getGuiModList());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void setGuiModListScroll(float scroll) {
        try {
            _scrollDistance.setFloat(this.getGuiModList(), scroll);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private List<ModContainer> getMods() {
        try {
            return (List)_modListMods.get(_modList.get((Object)this));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private int getListWidth() {
        try {
            return _listWidth.getInt((Object)this);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private ModContainer getSelectedMod() {
        try {
            return (ModContainer)_selectedMod.get((Object)this);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void setSelectedMod(ModContainer mod) {
        try {
            _selectedMod.set((Object)this, mod);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    static {
        try {
            _mods = GuiModList.class.getDeclaredField("mods");
            _mods.setAccessible(true);
            _selected = GuiModList.class.getDeclaredField("selected");
            _selected.setAccessible(true);
            _selectedMod = GuiModList.class.getDeclaredField("selectedMod");
            _selectedMod.setAccessible(true);
            _modList = GuiModList.class.getDeclaredField("modList");
            _modList.setAccessible(true);
            _modListRight = GuiScrollingList.class.getDeclaredField("right");
            _modListRight.setAccessible(true);
            _modListBottom = GuiScrollingList.class.getDeclaredField("bottom");
            _modListBottom.setAccessible(true);
            _modListMods = GuiSlotModList.class.getDeclaredField("mods");
            _modListMods.setAccessible(true);
            _listWidth = GuiModList.class.getDeclaredField("listWidth");
            _listWidth.setAccessible(true);
            _scrollDistance = GuiScrollingList.class.getDeclaredField("scrollDistance");
            _scrollDistance.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class InfoButton
    extends GuiButton {
        public InfoButton() {
            super(30, GuiEnhancedModList.this.field_146294_l - 22, 2, 20, 20, "?");
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146123_n) {
                ModContainer sel = GuiEnhancedModList.this.getSelectedMod();
                this.field_146126_j = sel != null && sel.getName().equals("EnderCore") ? EnderCore.lang.localize("gui.modlistinfo2") : EnderCore.lang.localize("gui.modlistinfo1");
                this.field_146120_f = p_146112_1_.field_71466_p.func_78256_a(this.field_146126_j) + 10;
                if (this.field_146120_f % 2 != 0) {
                    ++this.field_146120_f;
                }
                this.field_146128_h = GuiEnhancedModList.this.field_146294_l - this.field_146120_f - 2;
            } else {
                this.field_146126_j = "?";
                this.field_146120_f = 20;
                this.field_146128_h = GuiEnhancedModList.this.field_146294_l - this.field_146120_f - 2;
            }
            super.func_146112_a(p_146112_1_, p_146112_2_, p_146112_3_);
        }
    }

    private static class ModComparator
    implements Comparator<ModContainer> {
        private SortType type;

        private ModComparator(SortType type) {
            this.type = type;
        }

        @Override
        public int compare(ModContainer o1, ModContainer o2) {
            String name1 = StringUtils.func_76338_a((String)o1.getName()).toLowerCase(Locale.US);
            String name2 = StringUtils.func_76338_a((String)o2.getName()).toLowerCase(Locale.US);
            switch (this.type) {
                case A_TO_Z: {
                    return name1.compareTo(name2);
                }
                case Z_TO_A: {
                    return name2.compareTo(name1);
                }
            }
            return 0;
        }
    }

    private static enum SortType {
        NORMAL(24),
        A_TO_Z(25),
        Z_TO_A(26);

        private final int buttonID;
        private final ModComparator comparator;

        private SortType(int buttonID) {
            this.buttonID = buttonID;
            this.comparator = new ModComparator(this);
        }

        public static SortType getTypeForButton(GuiButton button) {
            for (SortType t : SortType.values()) {
                if (t.buttonID != button.field_146127_k) continue;
                return t;
            }
            return null;
        }
    }
}

