/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.lib.fluid.FluidUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class EnderLiquidStorage
extends AbstractEnderStorage
implements IFluidHandler,
IFluidTank {
    public static final EnderStorageManager.StorageType<EnderLiquidStorage> TYPE = new EnderStorageManager.StorageType("liquid");
    public static final int CAPACITY = 16 * FluidUtils.B;
    private Tank tank = new Tank(CAPACITY);

    public EnderLiquidStorage(EnderStorageManager manager, Frequency freq) {
        super(manager, freq);
    }

    @Override
    public void clearStorage() {
        this.tank = new Tank(CAPACITY);
        this.setDirty();
    }

    @Override
    public void loadFromTag(CompoundNBT tag) {
        this.tank.readFromNBT(tag.func_74775_l("tank"));
    }

    @Override
    public String type() {
        return "liquid";
    }

    @Override
    public CompoundNBT saveToTag() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        return compound;
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.tank.isFluidValid(stack);
    }

    public int getTanks() {
        return this.tank.getTanks();
    }

    public FluidStack getFluidInTank(int tankId) {
        return this.tank.getFluidInTank(tankId);
    }

    public int getTankCapacity(int tankId) {
        return this.tank.getTankCapacity(tankId);
    }

    public boolean isFluidValid(int tankId, FluidStack stack) {
        return this.tank.isFluidValid(tankId, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.tank.drain(maxDrain, action);
    }

    private class Tank
    extends FluidTank {
        public Tank(int capacity) {
            super(capacity);
        }

        protected void onContentsChanged() {
            EnderLiquidStorage.this.setDirty();
        }
    }
}

