/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;

public class TranslatedLogMessage {
    private final String prefix;
    private final String translationKey;
    private final String suffix;
    private final boolean actionBar;

    public TranslatedLogMessage() {
        this.prefix = "";
        this.translationKey = "";
        this.suffix = "";
        this.actionBar = false;
    }

    public TranslatedLogMessage(String prefix, String translationKey, String suffix, boolean actionBar) {
        this.prefix = prefix;
        this.translationKey = translationKey;
        this.suffix = suffix;
        this.actionBar = actionBar;
    }

    public static void encode(TranslatedLogMessage message, FriendlyByteBuf buf) {
        buf.m_130070_(message.prefix);
        buf.m_130070_(message.translationKey);
        buf.m_130070_(message.suffix);
        buf.writeBoolean(message.actionBar);
    }

    public static TranslatedLogMessage decode(FriendlyByteBuf buf) {
        return new TranslatedLogMessage(buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.readBoolean());
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isActionBar() {
        return this.actionBar;
    }

    public static class Handler {
        public static void handle(TranslatedLogMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    Player player = EffortlessBuilding.proxy.getPlayerEntityFromContext(ctx);
                    EffortlessBuilding.logTranslate(player, message.prefix, message.translationKey, message.suffix, message.actionBar);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

