/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.BlockSet;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.buildmodifier.UndoRedo;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.helper.InventoryHelper;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;
import nl.requios.effortlessbuilding.item.AbstractRandomizerBagItem;
import nl.requios.effortlessbuilding.render.BlockPreviewRenderer;

public class BuildModifiers {
    public static void onBlockPlaced(Player player, List<BlockPos> startCoordinates, Direction sideHit, Vec3 hitVec, boolean placeStartPos) {
        Level world = player.f_19853_;
        AbstractRandomizerBagItem.renewRandomness();
        hitVec = new Vec3(Math.abs(hitVec.f_82479_ - (double)((int)hitVec.f_82479_)), Math.abs(hitVec.f_82480_ - (double)((int)hitVec.f_82480_)), Math.abs(hitVec.f_82481_ - (double)((int)hitVec.f_82481_)));
        List<BlockPos> coordinates = BuildModifiers.findCoordinates(player, startCoordinates);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        List<BlockState> blockStates = BuildModifiers.findBlockStates(player, startCoordinates, hitVec, sideHit, itemStacks);
        if (blockStates.size() == 0 || coordinates.size() != blockStates.size()) {
            return;
        }
        ArrayList<BlockState> previousBlockStates = new ArrayList<BlockState>(coordinates.size());
        List<Object> newBlockStates = new ArrayList(coordinates.size());
        for (BlockPos coordinate : coordinates) {
            previousBlockStates.add(world.m_8055_(coordinate));
        }
        if (world.f_46443_) {
            BlockPreviewRenderer.onBlocksPlaced();
            newBlockStates = blockStates;
        } else {
            int i;
            int n = i = placeStartPos ? 0 : 1;
            while (i < coordinates.size()) {
                BlockPos blockPos = coordinates.get(i);
                BlockState blockState = blockStates.get(i);
                ItemStack itemStack = (ItemStack)itemStacks.get(i);
                if (!(!world.m_46749_(blockPos) || itemStack.m_41619_() && (itemStack = InventoryHelper.findItemStackInInventory(player, blockState.m_60734_())).m_41619_())) {
                    SurvivalHelper.placeBlock(world, player, blockPos, blockState, itemStack, Direction.UP, hitVec, false, false, false);
                }
                ++i;
            }
            for (BlockPos coordinate : coordinates) {
                newBlockStates.add(world.m_8055_(coordinate));
            }
        }
        if (!placeStartPos) {
            previousBlockStates.set(0, Blocks.f_50016_.m_49966_());
        }
        if (Collections.frequency(newBlockStates, Blocks.f_50016_.m_49966_()) != newBlockStates.size()) {
            BlockPos firstPos = startCoordinates.get(0);
            BlockPos secondPos = startCoordinates.get(startCoordinates.size() - 1);
            UndoRedo.addUndo(player, new BlockSet(coordinates, previousBlockStates, newBlockStates, hitVec, firstPos, secondPos));
        }
    }

    public static void onBlockBroken(Player player, List<BlockPos> startCoordinates, boolean breakStartPos) {
        Level world = player.f_19853_;
        List<BlockPos> coordinates = BuildModifiers.findCoordinates(player, startCoordinates);
        if (coordinates.isEmpty()) {
            return;
        }
        ArrayList<BlockState> previousBlockStates = new ArrayList<BlockState>(coordinates.size());
        ArrayList<BlockState> newBlockStates = new ArrayList<BlockState>(coordinates.size());
        for (BlockPos coordinate : coordinates) {
            previousBlockStates.add(world.m_8055_(coordinate));
        }
        if (world.f_46443_) {
            BlockPreviewRenderer.onBlocksBroken();
            for (int i = 0; i < coordinates.size(); ++i) {
                newBlockStates.add(Blocks.f_50016_.m_49966_());
            }
        } else {
            int i;
            boolean onlyInstaBreaking = !player.m_7500_() && world.m_8055_(startCoordinates.get(0)).m_60800_((BlockGetter)world, startCoordinates.get(0)) == 0.0f;
            int n = i = breakStartPos ? 0 : 1;
            while (i < coordinates.size()) {
                BlockPos coordinate = coordinates.get(i);
                if (!(!world.m_46749_(coordinate) || world.m_46859_(coordinate) || onlyInstaBreaking && world.m_8055_(coordinate).m_60800_((BlockGetter)world, coordinate) != 0.0f)) {
                    SurvivalHelper.breakBlock(world, player, coordinate, false);
                }
                ++i;
            }
            for (BlockPos coordinate : coordinates) {
                newBlockStates.add(world.m_8055_(coordinate));
            }
        }
        if (!breakStartPos) {
            newBlockStates.set(0, Blocks.f_50016_.m_49966_());
        }
        BlockPos firstPos = startCoordinates.get(0);
        BlockPos secondPos = startCoordinates.get(startCoordinates.size() - 1);
        Vec3 hitVec = new Vec3(0.5, 0.5, 0.5);
        UndoRedo.addUndo(player, new BlockSet(coordinates, previousBlockStates, newBlockStates, hitVec, firstPos, secondPos));
    }

    public static List<BlockPos> findCoordinates(Player player, List<BlockPos> posList) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        coordinates.addAll(posList);
        for (BlockPos blockPos : posList) {
            List<BlockPos> arrayCoordinates = Array.findCoordinates(player, blockPos);
            coordinates.addAll(arrayCoordinates);
            coordinates.addAll(Mirror.findCoordinates(player, blockPos));
            coordinates.addAll(RadialMirror.findCoordinates(player, blockPos));
            for (BlockPos coordinate : arrayCoordinates) {
                coordinates.addAll(Mirror.findCoordinates(player, coordinate));
                coordinates.addAll(RadialMirror.findCoordinates(player, coordinate));
            }
        }
        return coordinates;
    }

    public static List<BlockPos> findCoordinates(Player player, BlockPos blockPos) {
        return BuildModifiers.findCoordinates(player, new ArrayList<BlockPos>(Collections.singletonList(blockPos)));
    }

    public static List<BlockState> findBlockStates(Player player, List<BlockPos> posList, Vec3 hitVec, Direction facing, List<ItemStack> itemStacks) {
        BlockState blockState;
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        itemStacks.clear();
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemStack.m_41619_() || !CompatHelper.isItemBlockProxy(itemStack)) {
            itemStack = player.m_21120_(InteractionHand.OFF_HAND);
        }
        if (itemStack.m_41619_() || !CompatHelper.isItemBlockProxy(itemStack)) {
            return blockStates;
        }
        ItemStack itemBlock = ItemStack.f_41583_;
        itemBlock = itemStack.m_41720_() instanceof BlockItem ? itemStack : CompatHelper.getItemBlockFromStack(itemStack);
        AbstractRandomizerBagItem.resetRandomness();
        for (BlockPos blockPos : posList) {
            if (!(itemStack.m_41720_() instanceof BlockItem)) {
                itemBlock = CompatHelper.getItemBlockFromStack(itemStack);
            }
            if ((blockState = BuildModifiers.getBlockStateFromItem(itemBlock, player, blockPos, facing, hitVec, InteractionHand.MAIN_HAND)) == null) continue;
            blockStates.add(blockState);
            itemStacks.add(itemBlock);
        }
        for (BlockPos blockPos : posList) {
            blockState = BuildModifiers.getBlockStateFromItem(itemBlock, player, blockPos, facing, hitVec, InteractionHand.MAIN_HAND);
            if (blockState == null) continue;
            List<BlockState> arrayBlockStates = Array.findBlockStates(player, blockPos, blockState, itemStack, itemStacks);
            blockStates.addAll(arrayBlockStates);
            blockStates.addAll(Mirror.findBlockStates(player, blockPos, blockState, itemStack, itemStacks));
            blockStates.addAll(RadialMirror.findBlockStates(player, blockPos, blockState, itemStack, itemStacks));
            List<BlockPos> arrayCoordinates = Array.findCoordinates(player, blockPos);
            for (int i = 0; i < arrayCoordinates.size(); ++i) {
                BlockPos coordinate = arrayCoordinates.get(i);
                BlockState blockState1 = arrayBlockStates.get(i);
                if (blockState1 == null) continue;
                blockStates.addAll(Mirror.findBlockStates(player, coordinate, blockState1, itemStack, itemStacks));
                blockStates.addAll(RadialMirror.findBlockStates(player, coordinate, blockState1, itemStack, itemStacks));
            }
        }
        return blockStates;
    }

    public static boolean isEnabled(ModifierSettingsManager.ModifierSettings modifierSettings, BlockPos startPos) {
        return Mirror.isEnabled(modifierSettings.getMirrorSettings(), startPos) || Array.isEnabled(modifierSettings.getArraySettings()) || RadialMirror.isEnabled(modifierSettings.getRadialMirrorSettings(), startPos) || modifierSettings.doQuickReplace();
    }

    public static BlockState getBlockStateFromItem(ItemStack itemStack, Player player, BlockPos blockPos, Direction facing, Vec3 hitVec, InteractionHand hand) {
        return Block.m_49814_((Item)itemStack.m_41720_()).m_5573_(new BlockPlaceContext(new UseOnContext(player, hand, new BlockHitResult(hitVec, facing, blockPos, false))));
    }

    public static boolean compareCoordinates(List<BlockPos> coordinates1, List<BlockPos> coordinates2) {
        if (coordinates1 == null && coordinates2 == null) {
            return true;
        }
        if (coordinates1 == null || coordinates2 == null) {
            return false;
        }
        if (coordinates1.size() == coordinates2.size()) {
            if (coordinates1.size() == 1) {
                return coordinates1.get(0).equals((Object)coordinates2.get(0));
            }
            return true;
        }
        return false;
    }
}

