/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode.buildmodes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.buildmode.ThreeClicksBuildMode;
import nl.requios.effortlessbuilding.buildmode.buildmodes.DiagonalLine;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Floor;
import nl.requios.effortlessbuilding.helper.ReachHelper;

public class SlopeFloor
extends ThreeClicksBuildMode {
    public static List<BlockPos> getSlopeFloorBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2, int x3, int y3, int z3) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int axisLimit = ReachHelper.getMaxBlocksPerAxis(player);
        boolean onXAxis = true;
        int xLength = Math.abs(x2 - x1);
        int zLength = Math.abs(z2 - z1);
        if (ModeOptions.getRaisedEdge() == ModeOptions.ActionEnum.SHORT_EDGE) {
            if (zLength > xLength) {
                onXAxis = false;
            }
        } else if (zLength <= xLength) {
            onXAxis = false;
        }
        if (onXAxis) {
            List<BlockPos> diagonalLineBlocks = DiagonalLine.getDiagonalLineBlocks(player, x1, y1, z1, x2, y3, z1, 1.0f);
            int lowest = Math.min(z1, z2);
            int highest = Math.max(z1, z2);
            if (highest - lowest >= axisLimit) {
                highest = lowest + axisLimit - 1;
            }
            for (int z = lowest; z <= highest; ++z) {
                for (BlockPos blockPos : diagonalLineBlocks) {
                    list.add(new BlockPos(blockPos.m_123341_(), blockPos.m_123342_(), z));
                }
            }
        } else {
            List<BlockPos> diagonalLineBlocks = DiagonalLine.getDiagonalLineBlocks(player, x1, y1, z1, x1, y3, z2, 1.0f);
            int lowest = Math.min(x1, x2);
            int highest = Math.max(x1, x2);
            if (highest - lowest >= axisLimit) {
                highest = lowest + axisLimit - 1;
            }
            for (int x = lowest; x <= highest; ++x) {
                for (BlockPos blockPos : diagonalLineBlocks) {
                    list.add(new BlockPos(x, blockPos.m_123342_(), blockPos.m_123343_()));
                }
            }
        }
        return list;
    }

    @Override
    protected BlockPos findSecondPos(Player player, BlockPos firstPos, boolean skipRaytrace) {
        return Floor.findFloor(player, firstPos, skipRaytrace);
    }

    @Override
    protected BlockPos findThirdPos(Player player, BlockPos firstPos, BlockPos secondPos, boolean skipRaytrace) {
        return SlopeFloor.findHeight(player, secondPos, skipRaytrace);
    }

    @Override
    protected List<BlockPos> getIntermediateBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2) {
        return Floor.getFloorBlocks(player, x1, y1, z1, x2, y2, z2);
    }

    @Override
    protected List<BlockPos> getFinalBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2, int x3, int y3, int z3) {
        return SlopeFloor.getSlopeFloorBlocks(player, x1, y1, z1, x2, y2, z2, x3, y3, z3);
    }
}

