/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode;

import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.IBuildMode;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Circle;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Cube;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Cylinder;
import nl.requios.effortlessbuilding.buildmode.buildmodes.DiagonalLine;
import nl.requios.effortlessbuilding.buildmode.buildmodes.DiagonalWall;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Floor;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Line;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Normal;
import nl.requios.effortlessbuilding.buildmode.buildmodes.NormalPlus;
import nl.requios.effortlessbuilding.buildmode.buildmodes.SlopeFloor;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Sphere;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Wall;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;
import nl.requios.effortlessbuilding.network.BlockBrokenMessage;
import nl.requios.effortlessbuilding.network.BlockPlacedMessage;

public class BuildModes {
    public static Dictionary<Player, Boolean> currentlyBreakingClient = new Hashtable<Player, Boolean>();
    public static Dictionary<Player, Boolean> currentlyBreakingServer = new Hashtable<Player, Boolean>();

    public static void onBlockPlacedMessage(Player player, BlockPlacedMessage message) {
        Vec3 hitVec;
        Direction sideHit;
        List<BlockPos> coordinates;
        Dictionary<Player, Boolean> currentlyBreaking;
        Dictionary<Player, Boolean> dictionary = currentlyBreaking = player.f_19853_.f_46443_ ? currentlyBreakingClient : currentlyBreakingServer;
        if (currentlyBreaking.get(player) != null && currentlyBreaking.get(player).booleanValue()) {
            BuildModes.initializeMode(player);
            return;
        }
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings(player);
        BuildModeEnum buildMode = modeSettings.getBuildMode();
        BlockPos startPos = null;
        if (message.isBlockHit() && message.getBlockPos() != null) {
            startPos = message.getBlockPos();
            boolean replaceable = player.f_19853_.m_8055_(startPos).m_60767_().m_76336_();
            boolean becomesDoubleSlab = SurvivalHelper.doesBecomeDoubleSlab(player, startPos, message.getSideHit());
            if (!(modifierSettings.doQuickReplace() || replaceable || becomesDoubleSlab)) {
                startPos = startPos.m_142300_(message.getSideHit());
            }
            if (modifierSettings.doQuickReplace() && replaceable) {
                startPos = startPos.m_7495_();
            }
            int maxReach = ReachHelper.getMaxReach(player);
            if (buildMode != BuildModeEnum.NORMAL && player.m_142538_().m_123331_((Vec3i)startPos) > (double)(maxReach * maxReach)) {
                EffortlessBuilding.log(player, "Placement exceeds your reach.");
                return;
            }
        }
        if ((coordinates = buildMode.instance.onRightClick(player, startPos, message.getSideHit(), message.getHitVec(), modifierSettings.doQuickReplace())).isEmpty()) {
            currentlyBreaking.put(player, false);
            return;
        }
        int limit = ReachHelper.getMaxBlocksPlacedAtOnce(player);
        if (coordinates.size() > limit) {
            coordinates = coordinates.subList(0, limit);
        }
        if ((sideHit = buildMode.instance.getSideHit(player)) == null) {
            sideHit = message.getSideHit();
        }
        if ((hitVec = buildMode.instance.getHitVec(player)) == null) {
            hitVec = message.getHitVec();
        }
        BuildModifiers.onBlockPlaced(player, coordinates, sideHit, hitVec, message.getPlaceStartPos());
        currentlyBreaking.remove(player);
    }

    public static void onBlockBrokenMessage(Player player, BlockBrokenMessage message) {
        BlockPos startPos = message.isBlockHit() ? message.getBlockPos() : null;
        BuildModes.onBlockBroken(player, startPos, true);
    }

    public static void onBlockBroken(Player player, BlockPos startPos, boolean breakStartPos) {
        Dictionary<Player, Boolean> currentlyBreaking;
        Dictionary<Player, Boolean> dictionary = currentlyBreaking = player.f_19853_.f_46443_ ? currentlyBreakingClient : currentlyBreakingServer;
        if (currentlyBreaking.get(player) != null && !currentlyBreaking.get(player).booleanValue()) {
            BuildModes.initializeMode(player);
            return;
        }
        if (!ReachHelper.canBreakFar(player)) {
            return;
        }
        if (currentlyBreaking.get(player) == null && startPos == null) {
            return;
        }
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings(player);
        BuildModeEnum buildMode = modeSettings.getBuildMode();
        List<BlockPos> coordinates = buildMode.instance.onRightClick(player, startPos, Direction.UP, Vec3.f_82478_, true);
        if (coordinates.isEmpty()) {
            currentlyBreaking.put(player, true);
            return;
        }
        BuildModifiers.onBlockBroken(player, coordinates, breakStartPos);
        currentlyBreaking.remove(player);
    }

    public static List<BlockPos> findCoordinates(Player player, BlockPos startPos, boolean skipRaytrace) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings(player);
        coordinates.addAll(modeSettings.getBuildMode().instance.findCoordinates(player, startPos, skipRaytrace));
        return coordinates;
    }

    public static void initializeMode(Player player) {
        Dictionary<Player, Boolean> currentlyBreaking = player.f_19853_.f_46443_ ? currentlyBreakingClient : currentlyBreakingServer;
        currentlyBreaking.remove(player);
        ModeSettingsManager.getModeSettings((Player)player).getBuildMode().instance.initialize(player);
    }

    public static boolean isCurrentlyPlacing(Player player) {
        Dictionary<Player, Boolean> currentlyBreaking = player.f_19853_.f_46443_ ? currentlyBreakingClient : currentlyBreakingServer;
        return currentlyBreaking.get(player) != null && currentlyBreaking.get(player) == false;
    }

    public static boolean isCurrentlyBreaking(Player player) {
        Dictionary<Player, Boolean> currentlyBreaking = player.f_19853_.f_46443_ ? currentlyBreakingClient : currentlyBreakingServer;
        return currentlyBreaking.get(player) != null && currentlyBreaking.get(player) != false;
    }

    public static boolean isActive(Player player) {
        Dictionary<Player, Boolean> currentlyBreaking = player.f_19853_.f_46443_ ? currentlyBreakingClient : currentlyBreakingServer;
        return currentlyBreaking.get(player) != null;
    }

    public static Vec3 findXBound(double x, Vec3 start, Vec3 look) {
        double y = (x - start.f_82479_) / look.f_82479_ * look.f_82480_ + start.f_82480_;
        double z = (x - start.f_82479_) / look.f_82479_ * look.f_82481_ + start.f_82481_;
        return new Vec3(x, y, z);
    }

    public static Vec3 findYBound(double y, Vec3 start, Vec3 look) {
        double x = (y - start.f_82480_) / look.f_82480_ * look.f_82479_ + start.f_82479_;
        double z = (y - start.f_82480_) / look.f_82480_ * look.f_82481_ + start.f_82481_;
        return new Vec3(x, y, z);
    }

    public static Vec3 findZBound(double z, Vec3 start, Vec3 look) {
        double x = (z - start.f_82481_) / look.f_82481_ * look.f_82479_ + start.f_82479_;
        double y = (z - start.f_82481_) / look.f_82481_ * look.f_82480_ + start.f_82480_;
        return new Vec3(x, y, z);
    }

    public static Vec3 getPlayerLookVec(Player player) {
        Vec3 lookVec = player.m_20154_();
        double x = lookVec.f_82479_;
        double y = lookVec.f_82480_;
        double z = lookVec.f_82481_;
        if (Math.abs(x) < 1.0E-4) {
            x = 1.0E-4;
        }
        if (Math.abs(x - 1.0) < 1.0E-4) {
            x = 0.9999;
        }
        if (Math.abs(x + 1.0) < 1.0E-4) {
            x = -0.9999;
        }
        if (Math.abs(y) < 1.0E-4) {
            y = 1.0E-4;
        }
        if (Math.abs(y - 1.0) < 1.0E-4) {
            y = 0.9999;
        }
        if (Math.abs(y + 1.0) < 1.0E-4) {
            y = -0.9999;
        }
        if (Math.abs(z) < 1.0E-4) {
            z = 1.0E-4;
        }
        if (Math.abs(z - 1.0) < 1.0E-4) {
            z = 0.9999;
        }
        if (Math.abs(z + 1.0) < 1.0E-4) {
            z = -0.9999;
        }
        return new Vec3(x, y, z);
    }

    public static boolean isCriteriaValid(Vec3 start, Vec3 look, int reach, Player player, boolean skipRaytrace, Vec3 lineBound, Vec3 planeBound, double distToPlayerSq) {
        boolean intersects = false;
        if (!skipRaytrace) {
            ClipContext rayTraceContext = new ClipContext(start, lineBound, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult rayTraceResult = player.f_19853_.m_45547_(rayTraceContext);
            intersects = rayTraceResult != null && rayTraceResult.m_6662_() == HitResult.Type.BLOCK && planeBound.m_82546_(rayTraceResult.m_82450_()).m_82556_() > 4.0;
        }
        return planeBound.m_82546_(start).m_82526_(look) > 0.0 && distToPlayerSq > 2.0 && distToPlayerSq < (double)(reach * reach) && !intersects;
    }

    public static enum BuildModeEnum {
        NORMAL("normal", new Normal(), BuildModeCategoryEnum.BASIC, new ModeOptions.OptionEnum[0]),
        NORMAL_PLUS("normal_plus", new NormalPlus(), BuildModeCategoryEnum.BASIC, ModeOptions.OptionEnum.BUILD_SPEED),
        LINE("line", new Line(), BuildModeCategoryEnum.BASIC, new ModeOptions.OptionEnum[0]),
        WALL("wall", new Wall(), BuildModeCategoryEnum.BASIC, ModeOptions.OptionEnum.FILL),
        FLOOR("floor", new Floor(), BuildModeCategoryEnum.BASIC, ModeOptions.OptionEnum.FILL),
        CUBE("cube", new Cube(), BuildModeCategoryEnum.BASIC, ModeOptions.OptionEnum.CUBE_FILL),
        DIAGONAL_LINE("diagonal_line", new DiagonalLine(), BuildModeCategoryEnum.DIAGONAL, new ModeOptions.OptionEnum[0]),
        DIAGONAL_WALL("diagonal_wall", new DiagonalWall(), BuildModeCategoryEnum.DIAGONAL, new ModeOptions.OptionEnum[0]),
        SLOPE_FLOOR("slope_floor", new SlopeFloor(), BuildModeCategoryEnum.DIAGONAL, ModeOptions.OptionEnum.RAISED_EDGE),
        CIRCLE("circle", new Circle(), BuildModeCategoryEnum.CIRCULAR, ModeOptions.OptionEnum.CIRCLE_START, ModeOptions.OptionEnum.FILL),
        CYLINDER("cylinder", new Cylinder(), BuildModeCategoryEnum.CIRCULAR, ModeOptions.OptionEnum.CIRCLE_START, ModeOptions.OptionEnum.FILL),
        SPHERE("sphere", new Sphere(), BuildModeCategoryEnum.CIRCULAR, ModeOptions.OptionEnum.CIRCLE_START, ModeOptions.OptionEnum.FILL);

        private final String name;
        public final IBuildMode instance;
        public final BuildModeCategoryEnum category;
        public final ModeOptions.OptionEnum[] options;

        private BuildModeEnum(String name, IBuildMode instance, BuildModeCategoryEnum category, ModeOptions.OptionEnum ... options) {
            this.name = name;
            this.instance = instance;
            this.category = category;
            this.options = options;
        }

        public String getNameKey() {
            return "effortlessbuilding.mode." + this.name;
        }

        public String getDescriptionKey() {
            return "effortlessbuilding.modedescription." + this.name;
        }
    }

    public static enum BuildModeCategoryEnum {
        BASIC(new Vector4f(0.0f, 0.5f, 1.0f, 0.8f)),
        DIAGONAL(new Vector4f(0.56f, 0.28f, 0.87f, 0.8f)),
        CIRCULAR(new Vector4f(0.29f, 0.76f, 0.3f, 1.0f)),
        ROOF(new Vector4f(0.83f, 0.87f, 0.23f, 0.8f));

        public final Vector4f color;

        private BuildModeCategoryEnum(Vector4f color) {
            this.color = color;
        }
    }
}

