/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import de.matthiasmann.twl.renderer.AttributedStringFontCache;
import de.matthiasmann.twl.renderer.lwjgl.BitmapFont;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLFont;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLRenderer;
import de.matthiasmann.twl.renderer.lwjgl.TintStack;
import de.matthiasmann.twl.renderer.lwjgl.VertexArray;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;

class LWJGLAttributedStringFontCache
extends VertexArray
implements AttributedStringFontCache {
    final LWJGLRenderer renderer;
    final BitmapFont font;
    int width;
    int height;
    private Run[] runs;
    private int numRuns;

    LWJGLAttributedStringFontCache(LWJGLRenderer renderer, BitmapFont font) {
        this.renderer = renderer;
        this.font = font;
        this.runs = new Run[8];
    }

    @Override
    public FloatBuffer allocate(int maxGlyphs) {
        this.numRuns = 0;
        return super.allocate(maxGlyphs);
    }

    Run addRun() {
        Run run;
        if (this.runs.length == this.numRuns) {
            this.grow();
        }
        if ((run = this.runs[this.numRuns]) == null) {
            this.runs[this.numRuns] = run = new Run();
        }
        ++this.numRuns;
        return run;
    }

    private void grow() {
        Run[] newRuns = new Run[this.numRuns * 2];
        System.arraycopy(this.runs, 0, newRuns, 0, this.numRuns);
        this.runs = newRuns;
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(int x, int y) {
        if (this.font.bind()) {
            this.bind();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            TintStack tintStack = this.renderer.tintStack;
            try {
                int idx = 0;
                for (int i = 0; i < this.numRuns; ++i) {
                    Run run = this.runs[i];
                    LWJGLFont.FontState state = run.state;
                    int numVertices = run.numVertices;
                    tintStack.setColor(state.color);
                    if (numVertices > 0) {
                        this.drawVertices(idx, numVertices);
                        idx += numVertices;
                    }
                    if (state.style == 0) continue;
                    this.drawLines(run);
                }
            }
            finally {
                GL11.glPopMatrix();
                this.unbind();
            }
        }
    }

    private void drawLines(Run run) {
        LWJGLFont.FontState state = run.state;
        if ((state.style & 1) != 0) {
            this.font.drawLine(run.x, run.y + this.font.getBaseLine() + state.underlineOffset, run.xend);
        }
        if ((state.style & 2) != 0) {
            this.font.drawLine(run.x, run.y + this.font.getLineHeight() / 2, run.xend);
        }
    }

    static class Run {
        LWJGLFont.FontState state;
        int numVertices;
        int x;
        int xend;
        int y;

        Run() {
        }
    }
}

