/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModRegistry;

import Reika.DragonAPI.Base.CropHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Interfaces.CustomCropHandler;
import Reika.DragonAPI.Interfaces.Registry.CropHandler;
import Reika.DragonAPI.Interfaces.Registry.ModCrop;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaReflectionHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.ModInteract.ItemHandlers.AgriCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.BerryBushHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.FluxedCrystalHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.HarvestCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.OreBerryBushHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.PneumaticPlantHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;

public enum ModCropList implements ModCrop
{
    BARLEY(ModList.NATURA, 13480269, "crops", "seeds", 0, 0, 0, 3, ModWoodList.VarType.INSTANCE),
    COTTON(ModList.NATURA, 14903029, "crops", "seeds", 0, 4, 6, 8, ModWoodList.VarType.INSTANCE),
    FLAX(ModList.BLUEPOWER, 14271618, "flax_crop", "flax_seeds", 0, 0, 0, 8, ModWoodList.VarType.INSTANCE),
    MAGIC(ModList.MAGICCROPS, 7311717, (CropHandlerBase)ModList.MAGICCROPS.getHandler("Handler")),
    MANA(ModList.THAUMCRAFT, 0x55AAFF, "blockManaPod", "itemManaBean", 0, 0, 0, 3, ModWoodList.VarType.INSTANCE),
    BERRY(ModList.NATURA, 0x55FF33, BerryBushHandler.getInstance()),
    OREBERRY(ModList.TINKERER, 0xCCCCCC, OreBerryBushHandler.getInstance()),
    PAM(ModList.HARVESTCRAFT, 0x22AA22, HarvestCraftHandler.getInstance()),
    ALGAE(ModList.EMASHER, 2742357, "algae", 0, ModWoodList.VarType.INSTANCE),
    ENDER(ModList.EXTRAUTILS, 26698, "enderLily", 7, ModWoodList.VarType.INSTANCE),
    PNEUMATIC(ModList.PNEUMATICRAFT, 3669865, PneumaticPlantHandler.getInstance()),
    FLUXED(ModList.FLUXEDCRYSTALS, 0xD00000, FluxedCrystalHandler.getInstance()),
    AGRICRAFT(ModList.AGRICRAFT, 8295954, AgriCraftHandler.getInstance()),
    ASPECT(ModList.THAUMICTINKER, 12947928, "infusedGrainBlock", "infusedGrain", 0, 0, 0, 7, ModWoodList.VarType.REGISTRY);

    private final ModEntry mod;
    public final Block blockID;
    public final Item seedID;
    public final int seedMeta;
    public final int ripeMeta;
    private final int harvestedMeta;
    private int minmeta;
    private final CropHandler handler;
    private String blockClass;
    private String itemClass;
    private boolean dropsSelf;
    public final int cropColor;
    private boolean exists = false;
    public static final ModCropList[] cropList;
    private static final BlockMap<ModCropList> cropMappings;

    private ModCropList(ModList api, int color, String blockVar, int metaripe, ModWoodList.VarType type) {
        this(api, color, blockVar, 0, metaripe, type);
    }

    private ModCropList(ModList api, int color, String blockVar, int metamin, int metaripe, ModWoodList.VarType type) {
        this.dropsSelf = true;
        this.mod = api;
        this.ripeMeta = metaripe;
        this.harvestedMeta = metamin;
        this.handler = null;
        this.cropColor = color;
        Block id = null;
        Object seed = null;
        if (this.mod.isLoaded()) {
            Class blocks = api.getBlockClass();
            Class items = api.getItemClass();
            if (blocks == null) {
                DragonAPICore.logError("Error loading crop " + this + ": Empty block class");
            } else if (items == null) {
                DragonAPICore.logError("Error loading crop " + this + ": Empty item class");
            } else if (blockVar == null || blockVar.isEmpty()) {
                DragonAPICore.logError("Error loading crop " + this + ": Empty variable name");
            } else {
                try {
                    switch (type) {
                        case ITEMSTACK: {
                            Field b = blocks.getField(blockVar);
                            ItemStack is = (ItemStack)b.get(null);
                            if (is == null) {
                                DragonAPICore.logError("Error loading crop " + this + ": Block not instantiated!");
                                this.exists = false;
                                break;
                            }
                            id = Block.func_149634_a((Item)is.func_77973_b());
                            this.exists = true;
                            break;
                        }
                        case INSTANCE: {
                            Field b = blocks.getField(blockVar);
                            Block block = (Block)b.get(null);
                            if (block == null) {
                                DragonAPICore.logError("Error loading crop " + this + ": Block not instantiated!");
                                this.exists = false;
                                break;
                            }
                            id = block;
                            this.exists = true;
                            break;
                        }
                        case REGISTRY: {
                            Block block = GameRegistry.findBlock((String)this.mod.getModLabel(), (String)blockVar);
                            if (block == null) {
                                DragonAPICore.logError("Error loading crop " + this + ": Block not instantiated!");
                                this.exists = false;
                                break;
                            }
                            id = block;
                            this.exists = true;
                            break;
                        }
                        default: {
                            DragonAPICore.logError("Error loading crop " + this);
                            DragonAPICore.logError("Invalid variable type for field " + blockVar);
                            this.exists = false;
                            break;
                        }
                    }
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError("Error loading crop " + this);
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    DragonAPICore.logError("Error loading crop " + this);
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Error loading crop " + this);
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    DragonAPICore.logError("Error loading crop " + this);
                    e.printStackTrace();
                }
            }
        }
        this.blockID = id;
        this.seedID = Item.func_150898_a((Block)this.blockID);
        this.seedMeta = 0;
    }

    private ModCropList(ModEntry api, int color, CropHandler h) {
        this.handler = h;
        this.mod = api;
        this.blockID = null;
        this.seedID = null;
        this.seedMeta = -1;
        this.harvestedMeta = -1;
        this.ripeMeta = -1;
        this.cropColor = color;
        this.exists = h != null && h.initializedProperly();
    }

    private ModCropList(ModList api, int color, String blockVar, String itemVar, int seedItem, int metamin, int metafresh, int metaripe, ModWoodList.VarType type) {
        this(api, color, blockVar, itemVar, seedItem, metamin, metafresh, metaripe, type, type);
    }

    private ModCropList(ModList api, int color, String blockVar, String itemVar, int seedItem, int metamin, int metafresh, int metaripe, ModWoodList.VarType blockType, ModWoodList.VarType itemType) {
        if (!DragonAPIInit.canLoadHandlers()) {
            throw new MisuseException("Accessed registry enum too early! Wait until postInit!");
        }
        this.mod = api;
        this.harvestedMeta = metafresh;
        this.ripeMeta = metaripe;
        this.minmeta = metamin;
        this.cropColor = color;
        this.seedMeta = seedItem;
        this.handler = null;
        Block id = null;
        Item seed = null;
        if (this.mod.isLoaded()) {
            Class blocks = api.getBlockClass();
            Class items = api.getItemClass();
            if (blocks == null) {
                DragonAPICore.logError("Error loading crop " + this + ": Empty block class");
            } else if (items == null) {
                DragonAPICore.logError("Error loading crop " + this + ": Empty item class");
            } else if (blockVar == null || blockVar.isEmpty() || itemVar == null || itemVar.isEmpty()) {
                DragonAPICore.logError("Error loading crop " + this + ": Empty variable name");
            } else {
                try {
                    switch (blockType) {
                        case ITEMSTACK: {
                            Field b = blocks.getField(blockVar);
                            ItemStack is = (ItemStack)b.get(null);
                            if (is == null) {
                                DragonAPICore.logError("Error loading crop " + this + ": Block not instantiated!");
                                this.exists = false;
                                break;
                            }
                            id = Block.func_149634_a((Item)is.func_77973_b());
                            this.exists = true;
                            break;
                        }
                        case INSTANCE: {
                            Field b = blocks.getField(blockVar);
                            Block block = (Block)b.get(null);
                            if (block == null) {
                                DragonAPICore.logError("Error loading crop " + this + ": Block not instantiated!");
                                this.exists = false;
                                break;
                            }
                            id = block;
                            this.exists = true;
                            break;
                        }
                        case REGISTRY: {
                            Block block = GameRegistry.findBlock((String)this.mod.getModLabel(), (String)blockVar);
                            if (block == null) {
                                DragonAPICore.logError("Error loading crop " + this + ": Block not instantiated!");
                                this.exists = false;
                                break;
                            }
                            id = block;
                            this.exists = true;
                            break;
                        }
                        default: {
                            DragonAPICore.logError("Error loading crop " + this);
                            DragonAPICore.logError("Invalid variable type for field " + blockVar);
                            this.exists = false;
                        }
                    }
                    switch (itemType) {
                        case ITEMSTACK: {
                            Field i = items.getField(itemVar);
                            ItemStack is2 = (ItemStack)i.get(null);
                            if (is2 == null) {
                                DragonAPICore.logError("Error loading crop " + this + ": Seed not instantiated!");
                                this.exists = false;
                                break;
                            }
                            seed = is2.func_77973_b();
                            this.exists = true;
                            break;
                        }
                        case INSTANCE: {
                            Field i = items.getField(itemVar);
                            Item item = (Item)i.get(null);
                            if (item == null) {
                                DragonAPICore.logError("Error loading crop " + this + ": Seed not instantiated!");
                                this.exists = false;
                                break;
                            }
                            seed = item;
                            this.exists = true;
                            break;
                        }
                        case REGISTRY: {
                            Item item = GameRegistry.findItem((String)this.mod.getModLabel(), (String)itemVar);
                            if (item == null) {
                                DragonAPICore.logError("Error loading crop " + this + ": Item not instantiated!");
                                this.exists = false;
                                break;
                            }
                            seed = item;
                            this.exists = true;
                            break;
                        }
                        default: {
                            DragonAPICore.logError("Error loading crop " + this);
                            DragonAPICore.logError("Invalid variable type for field " + itemVar);
                            this.exists = false;
                            break;
                        }
                    }
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError("Error loading crop " + this);
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    DragonAPICore.logError("Error loading crop " + this);
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Error loading crop " + this);
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    DragonAPICore.logError("Error loading crop " + this);
                    e.printStackTrace();
                }
            }
        }
        this.blockID = id;
        this.seedID = seed;
    }

    public String toString() {
        if (this.isHandlered()) {
            return this.name() + " from " + this.mod + " with handler " + this.handler.getClass().getSimpleName();
        }
        return this.name() + " from " + this.mod + " with metadatas [" + this.harvestedMeta + "," + this.ripeMeta + "]";
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int fortune) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        if (this.blockID != null) {
            li.addAll(this.blockID.getDrops(world, x, y, z, meta, fortune));
        } else {
            if (b == Blocks.field_150350_a) {
                return new ArrayList<ItemStack>();
            }
            if (b != null) {
                li.addAll(b.getDrops(world, x, y, z, meta, fortune));
            }
        }
        if (this.isHandlered()) {
            ArrayList<ItemStack> li2;
            ArrayList<ItemStack> li3 = this.handler.getDropsOverride(world, x, y, z, b, meta, fortune);
            if (li3 != null) {
                li.clear();
                li.addAll(li3);
            }
            if ((li2 = this.handler.getAdditionalDrops(world, x, y, z, b, meta, fortune)) != null && !li2.isEmpty()) {
                li.addAll(li2);
            }
        }
        return li;
    }

    @Override
    public boolean isTileEntityUsedForGrowth() {
        return this.handler instanceof CustomCropHandler ? ((CustomCropHandler)this.handler).isTileEntity() : false;
    }

    @Override
    public void setHarvested(World world, int x, int y, int z) {
        if (this.isTileEntityUsedForGrowth()) {
            this.runTEHarvestCode(world, x, y, z);
        } else {
            world.func_72921_c(x, y, z, this.getHarvestedMetadata(world, x, y, z), 3);
        }
    }

    private void runTEHarvestCode(World world, int x, int y, int z) {
        if (!this.isTileEntityUsedForGrowth()) {
            return;
        }
        this.handler.editTileDataForHarvest(world, x, y, z);
    }

    @Override
    public boolean isSeedItem(ItemStack is) {
        if (this.isHandlered()) {
            return this.handler.isSeedItem(is);
        }
        if (this.itemClass != null && !this.itemClass.isEmpty()) {
            return this.itemClass.equals(is.func_77973_b().getClass().getSimpleName());
        }
        return this.seedID == is.func_77973_b() && this.seedMeta == is.func_77960_j();
    }

    public ModEntry getParentMod() {
        return this.mod;
    }

    public static ModCropList getModCrop(Block id, int meta) {
        ModCropList mod = cropMappings.get(id, meta);
        if (mod == null) {
            for (int i = 0; i < cropList.length && mod == null; ++i) {
                ModCropList crop = cropList[i];
                if (crop.isHandlered()) {
                    if (!crop.handler.isCrop(id, meta)) continue;
                    mod = crop;
                    continue;
                }
                if (crop.blockClass != null && !crop.blockClass.isEmpty()) {
                    if (!crop.blockClass.equals(id.getClass().getSimpleName())) continue;
                    mod = crop;
                    continue;
                }
                if (crop.blockID != id || !ReikaMathLibrary.isValueInsideBoundsIncl(crop.minmeta, crop.ripeMeta, meta)) continue;
                mod = crop;
            }
            cropMappings.put(id, meta, mod);
        }
        return mod;
    }

    public static boolean isModCrop(Block id, int meta) {
        return ModCropList.getModCrop(id, meta) != null;
    }

    @Override
    public boolean isCrop(Block id, int meta) {
        return this.isHandlered() ? this.handler.isCrop(id, meta) : this.blockID == id && meta >= this.minmeta && meta <= this.ripeMeta;
    }

    @Override
    public boolean destroyOnHarvest() {
        return this == ALGAE || this == ASPECT;
    }

    public boolean isBerryBush() {
        return this == BERRY || this == OREBERRY;
    }

    @Override
    public boolean isRipe(World world, int x, int y, int z) {
        return this.isHandlered() ? this.handler.isRipeCrop(world, x, y, z) : world.func_72805_g(x, y, z) >= this.ripeMeta;
    }

    @Override
    public void makeRipe(World world, int x, int y, int z) {
        if (this.isHandlered()) {
            this.handler.makeRipe(world, x, y, z);
        } else {
            int metato = this.ripeMeta;
            world.func_72921_c(x, y, z, metato, 3);
        }
    }

    private int getHarvestedMetadata(World world, int x, int y, int z) {
        return this.isHandlered() ? this.handler.getHarvestedMeta(world, x, y, z) : this.harvestedMeta;
    }

    public boolean isHandlered() {
        return this.handler != null;
    }

    @Override
    public boolean existsInGame() {
        return this.exists;
    }

    public static void addCustomCropType(CustomCropHandler ch) {
        String n = ch.getEnumEntryName().toUpperCase();
        try {
            ModCropList.valueOf(n);
            throw new IllegalArgumentException("Crop name " + n + " is already taken!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Class[] argTypes = new Class[]{ModEntry.class, Integer.TYPE, CropHandler.class};
                Object[] args = new Object[]{ch.getMod(), ch.getColor(), ch};
                ModCropList crop = (ModCropList)EnumHelper.addEnum(ModCropList.class, (String)n, (Class[])argTypes, (Object[])args);
                ReikaReflectionHelper.setFinalField(ModCropList.class, "cropList", null, ModCropList.values());
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not add custom crop type '" + ch.getMod() + ": " + n + "'!");
                e.printStackTrace();
            }
            return;
        }
    }

    @Override
    public int getGrowthState(World world, int x, int y, int z) {
        return this.isHandlered() ? this.handler.getGrowthState(world, x, y, z) : world.func_72805_g(x, y, z);
    }

    @Override
    public boolean neverDropsSecondSeed() {
        return this.isHandlered() ? this.handler.neverDropsSecondSeed() : false;
    }

    static {
        cropList = ModCropList.values();
        cropMappings = new BlockMap();
        for (int i = 0; i < cropList.length; ++i) {
            ModCropList c = cropList[i];
            if (!c.existsInGame() || c.isHandlered()) continue;
            Block b = c.blockID;
            for (int k = c.minmeta; k <= c.ripeMeta; ++k) {
                cropMappings.put(b, k, c);
            }
        }
    }
}

