/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.CropHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class VeryLegacyMagicCropHandler
extends CropHandlerBase {
    public final Block oreID;
    public final Block netherOreID;
    public final Item essenceID;
    public final Item cropEssenceID;
    private final int configChance;
    private ItemStack christmasEssence;
    private static final VeryLegacyMagicCropHandler instance = new VeryLegacyMagicCropHandler();

    private VeryLegacyMagicCropHandler() {
        Block idore = null;
        Block idnether = null;
        Item idessence = null;
        Object idcropessence = null;
        int chance = -1;
        if (this.hasMod()) {
            Class c = this.getMod().getBlockClass();
            for (int i = 0; i < EssenceType.essenceList.length; ++i) {
                EssenceType type = EssenceType.essenceList[i];
                String cropf = type.getCropFieldName();
                String seedf = type.getSeedFieldName();
                String essf = type.getEssenceFieldName();
                try {
                    Field f = c.getField(cropf);
                    Block crop = (Block)f.get(null);
                    f = c.getField(seedf);
                    Item seed = (Item)f.get(null);
                    f = c.getField(essf);
                    Item essence = (Item)f.get(null);
                    type.setIDs(crop, seed, essence);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (NullPointerException e) {
                    DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logFailure(e);
                }
            }
            try {
                Item essence;
                Block ore;
                Field f = c.getField("EssenceOre");
                idore = ore = (Block)f.get(null);
                f = c.getField("EssenceOreNether");
                idnether = ore = (Block)f.get(null);
                f = c.getField("MagicEssence");
                idessence = essence = (Item)f.get(null);
                Class<?> c2 = Class.forName("com.mark719.magicalcrops.ConfigHandler");
                f = c2.getDeclaredField("seeddropchance");
                f.setAccessible(true);
                chance = f.getInt(null);
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.oreID = idore;
        this.netherOreID = idnether;
        this.essenceID = idessence;
        this.cropEssenceID = idcropessence;
        this.configChance = chance >= 0 ? chance : 10;
        this.christmasEssence = this.cropEssenceID != null ? new ItemStack(this.cropEssenceID, 1, 20) : null;
    }

    @Override
    public boolean isCrop(Block id, int meta) {
        return EssenceType.cropIDs.containsKey(id);
    }

    @Override
    public boolean isSeedItem(ItemStack is) {
        return EssenceType.seedIDs.containsKey(is.func_77973_b());
    }

    @Override
    public boolean isRipeCrop(World world, int x, int y, int z) {
        int meta;
        Block b = world.func_147439_a(x, y, z);
        return this.isCrop(b, meta = world.func_72805_g(x, y, z)) && meta == 7;
    }

    @Override
    public void makeRipe(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, 7, 3);
    }

    public static VeryLegacyMagicCropHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return EssenceType.initialized() && this.configChance != -1 && this.oreID != null && this.netherOreID != null && this.essenceID != null && this.cropEssenceID != null;
    }

    public boolean isEssenceOre(Block id) {
        return id == this.netherOreID || id == this.oreID;
    }

    @Override
    public ModList getMod() {
        return ModList.MAGICCROPS;
    }

    @Override
    public int getHarvestedMeta(World world, int x, int y, int z) {
        return 0;
    }

    @Override
    public ArrayList<ItemStack> getAdditionalDrops(World world, int x, int y, int z, Block id, int meta, int fortune) {
        ItemStack weak;
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        if (ReikaRandomHelper.doWithChance(20 * (1 + fortune)) && this.christmasEssence != null) {
            li.add(this.christmasEssence);
        }
        ItemStack nature = EssenceType.NATURE.getEssence();
        if (ReikaRandomHelper.doWithChance(20 * (1 + fortune)) && nature != null) {
            li.add(nature);
        }
        if (ReikaRandomHelper.doWithChance(20 * (1 + fortune)) && (weak = this.getWeakEssence()) != null) {
            li.add(weak);
            if (ReikaRandomHelper.doWithChance(25 * (1 + fortune))) {
                li.add(weak);
            }
        }
        return li;
    }

    public void registerEssence() {
        ItemStack ore = new ItemStack(this.oreID, 1, 0);
        OreDictionary.registerOre((String)"oreEssence", (ItemStack)ore);
        ore = new ItemStack(this.netherOreID, 1, 0);
        OreDictionary.registerOre((String)"oreNetherEssence", (ItemStack)ore);
        ModOreList.ESSENCE.initialize();
        DragonAPICore.log("Registering Magic Crops Essence ore to the Ore Dictionary!");
    }

    public ItemStack getWeakEssence() {
        return this.essenceID != null ? new ItemStack(this.essenceID, 1, 0) : null;
    }

    @Override
    public int getGrowthState(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public ArrayList<ItemStack> getDropsOverride(World world, int x, int y, int z, Block id, int meta, int fortune) {
        return null;
    }

    @Override
    public boolean neverDropsSecondSeed() {
        return this.configChance == 0;
    }

    private static enum EssenceClass {
        MATERIAL("MagicCrop", "MagicSeeds"),
        MOD("ModMagicCrop", "ModMagicSeeds"),
        SOUL("SoulCrop", "SoulSeeds"),
        ELEMENT("ElementCrop", "ElementSeeds");

        public final String seedPrefix;
        public final String cropPrefix;

        private EssenceClass(String crop, String seed) {
            this.seedPrefix = seed;
            this.cropPrefix = crop;
        }
    }

    public static enum EssenceType {
        COW(EssenceClass.SOUL, "Cow", 0),
        CREEPER(EssenceClass.SOUL, "Creeper", 1),
        MAGMA(EssenceClass.SOUL, "Magma", 2),
        SKELETON(EssenceClass.SOUL, "Skeleton", 3),
        SLIME(EssenceClass.SOUL, "Slime", 4),
        SPIDER(EssenceClass.SOUL, "Spider", 5),
        GHAST(EssenceClass.SOUL, "Ghast", 6),
        WITHER(EssenceClass.SOUL, "Wither", 7),
        NATURE(EssenceClass.MATERIAL, "Essence", 0),
        REDSTONE(EssenceClass.MATERIAL, "Redstone", 1),
        GLOWSTONE(EssenceClass.MATERIAL, "Glowstone", 2),
        DIAMOND(EssenceClass.MATERIAL, "Diamond", 3),
        IRON(EssenceClass.MATERIAL, "Iron", 4),
        GOLD(EssenceClass.MATERIAL, "Gold", 5),
        LAPIS(EssenceClass.MATERIAL, "Lapis", 6),
        BLAZE(EssenceClass.MATERIAL, "Blaze", 7),
        EMERALD(EssenceClass.MATERIAL, "Emerald", 8),
        ENDER(EssenceClass.MATERIAL, "Ender", 9),
        OBSIDIAN(EssenceClass.MATERIAL, "Obsidian", 10),
        COAL(EssenceClass.MATERIAL, "Coal", 11),
        XP(EssenceClass.MATERIAL, "Experience", 12),
        DYE(EssenceClass.MATERIAL, "Dye", 13),
        NETHER(EssenceClass.MATERIAL, "Nether", 14),
        COPPER(EssenceClass.MOD, "Copper", 0),
        TIN(EssenceClass.MOD, "Tin", 1),
        SILVER(EssenceClass.MOD, "Silver", 2),
        LEAD(EssenceClass.MOD, "Lead", 3),
        QUARTZ(EssenceClass.MOD, "Quartz", 4),
        SAPPHIRE(EssenceClass.MOD, "Sapphire", 5),
        RUBY(EssenceClass.MOD, "Ruby", 6),
        PERIDOT(EssenceClass.MOD, "Peridot", 7),
        ALUMINUM(EssenceClass.MOD, "Alumin", 8),
        FORCE(EssenceClass.MOD, "Force", 9),
        COBALT(EssenceClass.MOD, "Cobalt", 10),
        ARDITE(EssenceClass.MOD, "Ardite", 11),
        NICKEL(EssenceClass.MOD, "Nickel", 12),
        PLATINUM(EssenceClass.MOD, "Platinum", 13),
        SHARD(EssenceClass.MOD, "ThaumcraftShard", 14),
        URANIUM(EssenceClass.MOD, "Uranium", 15),
        OIL(EssenceClass.MOD, "Oil", 16),
        RUBBER(EssenceClass.MOD, "Rubber", 17),
        VINTEUM(EssenceClass.MOD, "Vinteum", 18),
        TOPAZ(EssenceClass.MOD, "BlueTopaz", 19),
        CHIMERITE(EssenceClass.MOD, "Chimerite", 20),
        MOONSTONE(EssenceClass.MOD, "Moonstone", 21),
        SUNSTONE(EssenceClass.MOD, "Sunstone", 22),
        IRIDIUM(EssenceClass.MOD, "Iridium", 23),
        YELLORITE(EssenceClass.MOD, "Yellorite", 24),
        OSMIUM(EssenceClass.MOD, "Osmium", 25),
        MAGANESE(EssenceClass.MOD, "Manganese", 26),
        SULFUR(EssenceClass.MOD, "Sulfur", 27),
        DARKIRON(EssenceClass.MOD, "Darkiron", 28),
        WATER(EssenceClass.ELEMENT, "Water", 0),
        FIRE(EssenceClass.ELEMENT, "Fire", 1),
        EARTH(EssenceClass.ELEMENT, "Earth", 2),
        AIR(EssenceClass.ELEMENT, "Air", 3);

        private final EssenceClass type;
        private final String tag;
        private Block cropID = null;
        private Item seedID = null;
        private Item essenceID = null;
        private final int essenceMeta;
        public static final EssenceType[] essenceList;
        private static final HashMap<Block, EssenceType> cropIDs;
        private static final HashMap<Item, EssenceType> essenceIDs;
        private static final HashMap<Item, EssenceType> seedIDs;

        private EssenceType(EssenceClass type, String name, int meta) {
            this.type = type;
            this.tag = name;
            this.essenceMeta = meta;
        }

        private void setIDs(Block crop, Item seed, Item essence) {
            this.seedID = seed;
            this.cropID = crop;
            this.essenceID = essence;
            cropIDs.put(crop, this);
            seedIDs.put(seed, this);
            essenceIDs.put(essence, this);
        }

        public String getSeedFieldName() {
            return this.type.seedPrefix + this.tag;
        }

        public String getCropFieldName() {
            return this.type.cropPrefix + this.tag;
        }

        public ItemStack getEssence() {
            return this.essenceID != null ? new ItemStack(this.essenceID, 1, this.essenceMeta) : null;
        }

        public ItemStack getSeeds() {
            return this.seedID != null ? new ItemStack(this.seedID, 1, 0) : null;
        }

        public ItemStack getCrop() {
            return this.cropID != null ? new ItemStack(this.cropID, 1, 0) : null;
        }

        public String getEssenceFieldName() {
            switch (this.type) {
                case ELEMENT: {
                    return "ElementEssence";
                }
                case MATERIAL: {
                    return "CropEssence";
                }
                case SOUL: {
                    return "SoulEssence";
                }
                case MOD: {
                    return "ModCropEssence";
                }
            }
            return "";
        }

        public static boolean initialized() {
            return !cropIDs.isEmpty() && !seedIDs.isEmpty() && !essenceIDs.isEmpty();
        }

        static {
            essenceList = EssenceType.values();
            cropIDs = new HashMap();
            essenceIDs = new HashMap();
            seedIDs = new HashMap();
        }
    }
}

