/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.IO;

import java.awt.Color;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class ReikaColorAPI {
    public static float RGBtoColorMultiplier(int[] RGB2, int bit) {
        float color = 1.0f;
        if (bit < 0 || bit > 2) {
            return 1.0f;
        }
        color = (float)RGB2[bit] / 255.0f;
        return color;
    }

    public static float HextoColorMultiplier(int hex, int bit) {
        float color = 1.0f;
        int[] RGB2 = ReikaColorAPI.HexToRGB(hex);
        if (bit < 0 || bit > 2) {
            return 1.0f;
        }
        color = (float)RGB2[bit] / 255.0f;
        return color;
    }

    public static int RGBtoHex(int R, int G, int B, int A) {
        int color = B | G << 8 | R << 16 | A << 24;
        return color;
    }

    public static int RGBtoHex(int R, int G, int B) {
        return ReikaColorAPI.RGBtoHex(R, G, B, 255);
    }

    public static int GStoHex(int GS) {
        return ReikaColorAPI.RGBtoHex(GS, GS, GS);
    }

    public static int[] HexToRGB(int hex) {
        int[] color = new int[]{hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF, hex >> 24 & 0xFF};
        return color;
    }

    public static int getColorWithBrightnessMultiplier(int argb, float mult) {
        int alpha = argb >> 24 & 0xFF;
        int red = Math.min(255, (int)((float)(argb >> 16 & 0xFF) * mult)) & 0xFF;
        int green = Math.min(255, (int)((float)(argb >> 8 & 0xFF) * mult)) & 0xFF;
        int blue = Math.min(255, (int)((float)(argb & 0xFF) * mult)) & 0xFF;
        int color = alpha;
        color = (color << 8) + red;
        color = (color << 8) + green;
        color = (color << 8) + blue;
        return color;
    }

    public static int getColorWithBrightnessMultiplierRGBA(int rgba, float mult) {
        int alpha = rgba & 0xFF;
        int red = Math.min(255, (int)((float)(rgba >> 24 & 0xFF) * mult)) & 0xFF;
        int green = Math.min(255, (int)((float)(rgba >> 16 & 0xFF) * mult)) & 0xFF;
        int blue = Math.min(255, (int)((float)(rgba >> 8 & 0xFF) * mult)) & 0xFF;
        int color = red;
        color = (color << 8) + green;
        color = (color << 8) + blue;
        color = (color << 8) + alpha;
        return color;
    }

    private static float[] RGBtoHSB(int rgb) {
        return Color.RGBtoHSB(ReikaColorAPI.getRed(rgb), ReikaColorAPI.getGreen(rgb), ReikaColorAPI.getBlue(rgb), null);
    }

    public static Color getModifiedSat(Color color, float factor) {
        return new Color(ReikaColorAPI.getModifiedSat(color.getRGB(), factor));
    }

    public static int getModifiedSat(int rgb, float factor) {
        float[] hsb = ReikaColorAPI.RGBtoHSB(rgb);
        hsb[1] = hsb[1] * factor;
        hsb[1] = Math.min(hsb[1], 1.0f);
        return Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
    }

    public static Color getModifiedHue(Color color, int hue) {
        return new Color(ReikaColorAPI.getModifiedHue(color.getRGB(), hue));
    }

    public static int getModifiedHue(int rgb, int hue) {
        float[] hsb = ReikaColorAPI.RGBtoHSB(rgb);
        hsb[0] = (float)hue / 360.0f;
        return Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
    }

    public static int getShiftedHue(int rgb, float hueShift) {
        float[] hsb = ReikaColorAPI.RGBtoHSB(rgb);
        hsb[0] = hsb[0] + hueShift / 360.0f % 1.0f;
        return Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
    }

    public static int getRed(int color) {
        int r = color >> 16 & 0xFF;
        return r;
    }

    public static int getGreen(int color) {
        int g = color >> 8 & 0xFF;
        return g;
    }

    public static int getBlue(int color) {
        int b = color >> 0 & 0xFF;
        return b;
    }

    public static int getAlpha(int color) {
        int a = color >> 24 & 0xFF;
        return a;
    }

    public static boolean isRGBNonZero(int color) {
        return (color & 0xFFFFFF) != 0;
    }

    public static boolean isAlphaNonZero(int color) {
        return (color & 0xFF000000) > 0;
    }

    public static int mixColors(int c1, int c2, float ratio) {
        int a1 = (c1 & 0xFF000000) >> 24;
        int a2 = (c2 & 0xFF000000) >> 24;
        int r1 = (c1 & 0xFF0000) >> 16;
        int r2 = (c2 & 0xFF0000) >> 16;
        int g1 = (c1 & 0xFF00) >> 8;
        int g2 = (c2 & 0xFF00) >> 8;
        int b1 = c1 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 * ratio + (float)r2 * (1.0f - ratio));
        int g = (int)((float)g1 * ratio + (float)g2 * (1.0f - ratio));
        int b = (int)((float)b1 * ratio + (float)b2 * (1.0f - ratio));
        int a = (int)((float)a1 * ratio + (float)a2 * (1.0f - ratio));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int additiveBlend(int color) {
        int rgb = color & 0xFFFFFF;
        int r = ReikaColorAPI.getRed(color);
        int g = ReikaColorAPI.getGreen(color);
        int b = ReikaColorAPI.getBlue(color);
        int alpha = (r + g + b) / 3;
        return rgb | alpha << 24;
    }

    public static int getPackedIntForColoredLight(int color, int lightval) {
        int red = ReikaColorAPI.getRed(color) * 15 / 255;
        int green = ReikaColorAPI.getGreen(color) * 15 / 255;
        int blue = ReikaColorAPI.getBlue(color) * 15 / 255;
        return lightval | blue << 15 | green << 10 | red << 5;
    }

    public static int invertColor(int rgb) {
        return ReikaColorAPI.RGBtoHex(255 - ReikaColorAPI.getRed(rgb), 255 - ReikaColorAPI.getGreen(rgb), 255 - ReikaColorAPI.getBlue(rgb));
    }

    public static int HexToGS(int rgb) {
        return (ReikaColorAPI.getRed(rgb) + ReikaColorAPI.getGreen(rgb) + ReikaColorAPI.getBlue(rgb)) / 3;
    }

    public static int getHue(int rgb) {
        return (int)(360.0f * Color.RGBtoHSB(ReikaColorAPI.getRed(rgb), ReikaColorAPI.getGreen(rgb), ReikaColorAPI.getBlue(rgb), null)[0]);
    }

    public static int getShiftedDelta(int color, int base, int newbase) {
        int red = ReikaColorAPI.getRed(color);
        int green = ReikaColorAPI.getGreen(color);
        int blue = ReikaColorAPI.getBlue(color);
        float[] hsv = Color.RGBtoHSB(red, green, blue, null);
        red = ReikaColorAPI.getRed(base);
        green = ReikaColorAPI.getGreen(base);
        blue = ReikaColorAPI.getBlue(base);
        float[] hsvb = Color.RGBtoHSB(red, green, blue, null);
        red = ReikaColorAPI.getRed(newbase);
        green = ReikaColorAPI.getGreen(newbase);
        blue = ReikaColorAPI.getBlue(newbase);
        float[] hsvn = Color.RGBtoHSB(red, green, blue, null);
        float[] ret = new float[3];
        for (int i = 0; i < 3; ++i) {
            ret[i] = hsv[i] - hsvb[i] + hsvn[i];
            if (i <= 0) continue;
            ret[i] = MathHelper.func_76131_a((float)ret[i], (float)0.0f, (float)1.0f);
        }
        return Color.HSBtoRGB(ret[0], ret[1], ret[2]);
    }

    public static int multiplyChannels(int c, float r, float g, float b) {
        int r2 = (int)Math.min(255.0f, r * (float)ReikaColorAPI.getRed(c));
        int g2 = (int)Math.min(255.0f, g * (float)ReikaColorAPI.getGreen(c));
        int b2 = (int)Math.min(255.0f, b * (float)ReikaColorAPI.getBlue(c));
        return ReikaColorAPI.RGBtoHex(r2, g2, b2);
    }

    public static int getColorWithAlpha(int color, float alpha) {
        return color & 0xFFFFFF | (int)alpha << 24;
    }

    public static int fromVec3(Vec3 vec) {
        return ReikaColorAPI.RGBtoHex((int)(vec.field_72450_a * 255.0), (int)(vec.field_72448_b * 255.0), (int)(vec.field_72449_c * 255.0));
    }
}

