/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class VillageBuilding
implements VillagerRegistry.IVillageCreationHandler {
    public final Class buildingClass;
    public final int weight;
    private final Constructor<VillagePiece> constructor;
    public final int xSize;
    public final int ySize;
    public final int zSize;

    public VillageBuilding(Class<? extends VillagePiece> c, int w, String n, int x, int y, int z) {
        this.buildingClass = c;
        this.weight = w;
        try {
            this.constructor = c.getConstructor(StructureVillagePieces.Start.class, Integer.TYPE, Random.class, StructureBoundingBox.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("You must specify an appropriate constructor!", e);
        }
        MapGenStructureIO.func_143031_a((Class)this.buildingClass, (String)n);
        this.xSize = x;
        this.ySize = y;
        this.zSize = z;
    }

    public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int i) {
        return new StructureVillagePieces.PieceWeight(this.buildingClass, this.weight, MathHelper.func_76136_a((Random)random, (int)(0 + i), (int)(1 + i)));
    }

    public Class<?> getComponentClass() {
        return this.buildingClass;
    }

    public Object buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List pieces, Random random, int p1, int p2, int p3, int p4, int p5) {
        return this.buildComponent(startPiece, pieces, random, p1, p2, p3, p4, p5);
    }

    private VillagePiece buildComponent(StructureVillagePieces.Start startPiece, List pieces, Random random, int par3, int par4, int par5, int par6, int par7) {
        StructureBoundingBox var8 = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)this.xSize, (int)this.ySize, (int)this.zSize, (int)par6);
        return !this.canVillageGoDeeper(var8) || StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)var8) != null ? null : this.createInstance(startPiece, par7, random, var8, par6);
    }

    private VillagePiece createInstance(StructureVillagePieces.Start start, int par7, Random random, StructureBoundingBox var8, int par6) {
        try {
            return this.constructor.newInstance(start, par7, random, var8, par6, this.xSize, this.ySize, this.zSize);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean canVillageGoDeeper(StructureBoundingBox var8) {
        return var8 != null && var8.field_78895_b > 10;
    }

    public static class StructureEntry {
        public final Class structureClass;
        public final String identifier;
        public final int weight;
        public final int xSize;
        public final int ySize;
        public final int zSize;

        public StructureEntry(Class<? extends VillagePiece> c, int w, String s, int x, int y, int z) {
            this.structureClass = c;
            this.weight = w;
            this.identifier = s;
            this.xSize = x;
            this.ySize = y;
            this.zSize = z;
        }

        public VillageBuilding build() {
            return new VillageBuilding(this.structureClass, this.weight, this.identifier, this.xSize, this.ySize, this.zSize);
        }
    }

    public static abstract class VillagePiece
    extends StructureVillagePieces.Village {
        private int xSize;
        private int ySize;
        private int zSize;
        private int averageGroundLevel = -1;
        private StructureBoundingBox structureBox;
        private static final BlockKey BASIC_SUPPORT = new BlockKey(Blocks.field_150347_e);

        public VillagePiece() {
        }

        protected VillagePiece(StructureVillagePieces.Start start, int par2, Random rand, StructureBoundingBox bb, int par5, int x, int y, int z) {
            super(start, par2);
            this.field_74885_f = par5;
            this.field_74887_e = bb;
            this.xSize = x;
            this.ySize = y;
            this.zSize = z;
        }

        public final void func_143009_a(World world, NBTTagCompound tag) {
            super.func_143009_a(world, tag);
            this.xSize = tag.func_74762_e("sizeX");
            this.ySize = tag.func_74762_e("sizeY");
            this.zSize = tag.func_74762_e("sizeZ");
        }

        public final boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            this.structureBox = box;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = this.func_74889_b(world, box);
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + this.ySize - 1, 0);
            }
            return this.generate(world, rand);
        }

        public final int hashCode() {
            return this.structureBox.func_151535_h().hashCode() ^ ((Object)((Object)this)).getClass().hashCode();
        }

        public boolean equals(Object o) {
            return o.getClass() == ((Object)((Object)this)).getClass() && ((VillagePiece)((Object)o)).structureBox.func_151535_h().equals((Object)this.structureBox.func_151535_h());
        }

        protected final void clearDroppedItems(World world) {
            AxisAlignedBB box = ReikaAABBHelper.structureToAABB(this.field_74887_e).func_72314_b(2.0, 2.0, 2.0);
            List li = world.func_72872_a(EntityItem.class, box);
            for (EntityItem ei : li) {
                ei.func_70106_y();
            }
        }

        protected abstract boolean generate(World var1, Random var2);

        protected final void placeBlockAtCurrentPosition(World world, int i, int j, int k, Block b) {
            this.placeBlockAtCurrentPosition(world, i, j, k, b, 0);
        }

        protected final void placeBlockAtCurrentPosition(World world, int i, int j, int k, Block b, int meta) {
            this.placeBlockAtCurrentPosition(world, i, j, k, b, meta, BASIC_SUPPORT);
        }

        protected final void placeBlockAtCurrentPosition(World world, int i, int j, int k, Block b, int meta, BlockKey support) {
            int i1 = this.func_74865_a(i, k);
            int j1 = this.func_74862_a(j);
            int k1 = this.func_74873_b(i, k);
            if (b == Blocks.field_150444_as) {
                meta = ReikaBlockHelper.getSignMetadataToConnectToWall(world, i1, j1, k1, meta);
            }
            this.tryPlaceBlock(world, i1, j1, k1, b, meta, 3, support);
        }

        private void tryPlaceBlock(World world, int x, int y, int z, Block b, int meta, int flags) {
            this.tryPlaceBlock(world, x, y, z, b, meta, flags, BASIC_SUPPORT);
        }

        private void tryPlaceBlock(World world, int x, int y, int z, Block b, int meta, int flags, BlockKey support) {
            Block b2 = world.func_147439_a(x, y, z);
            int meta2 = world.func_72805_g(x, y, z);
            if (b2 != b || meta2 != meta) {
                world.func_147465_d(x, y, z, b, meta, flags);
            }
            if (b.func_149688_o().func_76220_a() && support != null && y == this.field_74887_e.field_78895_b) {
                for (int dy = y - 1; dy > 0 && ReikaWorldHelper.softBlocks((IBlockAccess)world, x, dy, z) && world.func_147439_a(x, dy, z) != b; --dy) {
                    world.func_147465_d(x, dy, z, support.blockID, support.metadata, 3);
                }
            }
        }

        protected final void placeBlockAtFixedPosition(World world, int i, int j, int k, Block b) {
            this.placeBlockAtFixedPosition(world, i, j, k, b, 0);
        }

        protected final void placeBlockAtFixedPosition(World world, int i, int j, int k, Block b, int meta) {
            this.placeBlockAtFixedPosition(world, i, j, k, b, meta, BASIC_SUPPORT);
        }

        protected final void placeBlockAtFixedPosition(World world, int i, int j, int k, Block b, int meta, BlockKey support) {
            this.tryPlaceBlock(world, i + this.field_74887_e.field_78897_a, j + this.field_74887_e.field_78895_b, k + this.field_74887_e.field_78896_c, b, meta, 3, support);
        }

        protected final void placeBlockAtFixedPosition(World world, int i, int j, int k, BlockKey bk) {
            this.placeBlockAtFixedPosition(world, i, j, k, bk.blockID, Math.max(0, bk.metadata));
        }

        protected final TileEntity placeTileEntityAtFixedPosition(World world, int i, int j, int k, Block b, int meta) {
            this.tryPlaceBlock(world, i + this.field_74887_e.field_78897_a, j + this.field_74887_e.field_78895_b, k + this.field_74887_e.field_78896_c, b, meta, 3);
            return world.func_147438_o(i + this.field_74887_e.field_78897_a, j + this.field_74887_e.field_78895_b, k + this.field_74887_e.field_78896_c);
        }

        protected final TileEntity generateTileEntity(World world, int i, int j, int k, Block b, int meta) {
            this.placeBlockAtCurrentPosition(world, i, j, k, b, meta);
            int x = this.func_74865_a(i, k);
            int y = this.func_74862_a(j);
            int z = this.func_74873_b(i, k);
            return world.func_147438_o(x, y, z);
        }

        protected void clearVolume(World world) {
            this.clearVolume(world, 0, 0, 0, this.xSize, this.ySize, this.zSize);
        }

        protected void clearVolume(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
            for (int i = x1; i < x2; ++i) {
                for (int k = z1; k < z2; ++k) {
                    for (int j = y1; j < y2; ++j) {
                        this.placeBlockAtFixedPosition(world, i, j, k, Blocks.field_150350_a);
                    }
                }
            }
        }
    }
}

