/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class EdgeDetectionRenderer {
    public final BlockKey block;
    private IIcon[] icons = new IIcon[4];

    public EdgeDetectionRenderer(Block b) {
        this(new BlockKey(b));
    }

    public EdgeDetectionRenderer(Block b, int meta) {
        this(new BlockKey(b, meta));
    }

    public EdgeDetectionRenderer(BlockKey bk) {
        if (bk == null || bk.blockID == null) {
            throw new MisuseException("You cannot use a null block in the edge detection renderer!");
        }
        this.block = bk;
    }

    public EdgeDetectionRenderer setIcons(IIcon[] icons) {
        if (icons.length != 4) {
            throw new IllegalArgumentException("You must provide only four icons!");
        }
        this.icons = icons;
        return this;
    }

    public void renderBlock(IBlockAccess world, int x, int y, int z, RenderBlocks rb) {
        for (int i = 0; i < 6; ++i) {
            if (!this.canRenderFace(world, x, y, z)) continue;
            this.renderFace(world, x, y, z, rb, ForgeDirection.VALID_DIRECTIONS[i]);
        }
    }

    private boolean canRenderFace(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    private void renderFace(IBlockAccess world, int x, int y, int z, RenderBlocks rb, ForgeDirection face) {
        Tessellator v5 = Tessellator.field_78398_a;
        double o = 0.005;
        boolean draw = false;
        if (!v5.field_78415_z) {
            v5.func_78382_b();
            draw = true;
        }
        switch (face) {
            case DOWN: {
                IIcon ico;
                BlockKey bk = BlockKey.getAt(world, x + 1, y, z);
                if (!bk.equals(this.block) || !world.func_147439_a(x + 1, y, z).func_149646_a(world, x + 1, y - 1, z, 0)) {
                    ico = this.icons[2];
                    v5.func_78374_a(0.0, -o, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0, -o, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0, -o, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(0.0, -o, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                }
                if (!(bk = BlockKey.getAt(world, x - 1, y, z)).equals(this.block) || !world.func_147439_a(x - 1, y, z).func_149646_a(world, x - 1, y - 1, z, 0)) {
                    ico = this.icons[0];
                    v5.func_78374_a(0.0, -o, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0, -o, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0, -o, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(0.0, -o, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                }
                if (!(bk = BlockKey.getAt(world, x, y, z + 1)).equals(this.block) || !world.func_147439_a(x, y, z + 1).func_149646_a(world, x, y - 1, z + 1, 0)) {
                    ico = this.icons[3];
                    v5.func_78374_a(0.0, -o, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0, -o, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0, -o, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(0.0, -o, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                }
                if ((bk = BlockKey.getAt(world, x, y, z - 1)).equals(this.block) && world.func_147439_a(x, y, z - 1).func_149646_a(world, x, y - 1, z - 1, 0)) break;
                ico = this.icons[1];
                v5.func_78374_a(0.0, -o, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                v5.func_78374_a(1.0, -o, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                v5.func_78374_a(1.0, -o, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                v5.func_78374_a(0.0, -o, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                break;
            }
            case UP: {
                IIcon ico;
                BlockKey bk = BlockKey.getAt(world, x + 1, y, z);
                if (!bk.equals(this.block) || !world.func_147439_a(x + 1, y, z).func_149646_a(world, x + 1, y + 1, z, 0)) {
                    ico = this.icons[2];
                    v5.func_78374_a(0.0, 1.0 + o, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0, 1.0 + o, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0, 1.0 + o, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(0.0, 1.0 + o, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                }
                if (!(bk = BlockKey.getAt(world, x - 1, y, z)).equals(this.block) || !world.func_147439_a(x - 1, y, z).func_149646_a(world, x - 1, y + 1, z, 0)) {
                    ico = this.icons[0];
                    v5.func_78374_a(0.0, 1.0 + o, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0, 1.0 + o, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0, 1.0 + o, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(0.0, 1.0 + o, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                }
                if (!(bk = BlockKey.getAt(world, x, y, z + 1)).equals(this.block) || !world.func_147439_a(x, y, z + 1).func_149646_a(world, x, y + 1, z + 1, 0)) {
                    ico = this.icons[3];
                    v5.func_78374_a(0.0, 1.0 + o, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0, 1.0 + o, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0, 1.0 + o, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(0.0, 1.0 + o, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                }
                if ((bk = BlockKey.getAt(world, x, y, z - 1)).equals(this.block) && world.func_147439_a(x, y, z - 1).func_149646_a(world, x, y + 1, z - 1, 0)) break;
                ico = this.icons[1];
                v5.func_78374_a(0.0, 1.0 + o, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                v5.func_78374_a(1.0, 1.0 + o, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                v5.func_78374_a(1.0, 1.0 + o, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                v5.func_78374_a(0.0, 1.0 + o, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                break;
            }
            case EAST: {
                IIcon ico;
                BlockKey bk = BlockKey.getAt(world, x, y + 1, z);
                if (!bk.equals(this.block) || !world.func_147439_a(x, y + 1, z).func_149646_a(world, x + 1, y + 1, z, 0)) {
                    ico = this.icons[2];
                    v5.func_78374_a(1.0 + o, 0.0, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0 + o, 1.0, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0 + o, 1.0, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0 + o, 0.0, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                }
                if (!(bk = BlockKey.getAt(world, x, y - 1, z)).equals(this.block) || !world.func_147439_a(x, y - 1, z).func_149646_a(world, x + 1, y - 1, z, 0)) {
                    ico = this.icons[0];
                    v5.func_78374_a(1.0 + o, 0.0, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0 + o, 1.0, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0 + o, 1.0, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0 + o, 0.0, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                }
                if (!(bk = BlockKey.getAt(world, x, y, z + 1)).equals(this.block) || !world.func_147439_a(x, y, z + 1).func_149646_a(world, x + 1, y, z + 1, 0)) {
                    ico = this.icons[3];
                    v5.func_78374_a(1.0 + o, 0.0, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0 + o, 1.0, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0 + o, 1.0, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0 + o, 0.0, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                }
                if ((bk = BlockKey.getAt(world, x, y, z - 1)).equals(this.block) && world.func_147439_a(x, y, z - 1).func_149646_a(world, x + 1, y, z - 1, 0)) break;
                ico = this.icons[1];
                v5.func_78374_a(1.0 + o, 0.0, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                v5.func_78374_a(1.0 + o, 1.0, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                v5.func_78374_a(1.0 + o, 1.0, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                v5.func_78374_a(1.0 + o, 0.0, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                break;
            }
            case WEST: {
                IIcon ico;
                BlockKey bk = BlockKey.getAt(world, x, y + 1, z);
                if (!bk.equals(this.block) || !world.func_147439_a(x, y + 1, z).func_149646_a(world, x - 1, y + 1, z, 0)) {
                    ico = this.icons[2];
                    v5.func_78374_a(-o, 0.0, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                    v5.func_78374_a(-o, 1.0, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(-o, 1.0, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(-o, 0.0, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                }
                if (!(bk = BlockKey.getAt(world, x, y - 1, z)).equals(this.block) || !world.func_147439_a(x, y - 1, z).func_149646_a(world, x - 1, y - 1, z, 0)) {
                    ico = this.icons[0];
                    v5.func_78374_a(-o, 0.0, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                    v5.func_78374_a(-o, 1.0, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(-o, 1.0, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(-o, 0.0, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                }
                if (!(bk = BlockKey.getAt(world, x, y, z + 1)).equals(this.block) || !world.func_147439_a(x, y, z + 1).func_149646_a(world, x - 1, y, z + 1, 0)) {
                    ico = this.icons[3];
                    v5.func_78374_a(-o, 0.0, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                    v5.func_78374_a(-o, 1.0, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(-o, 1.0, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(-o, 0.0, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                }
                if ((bk = BlockKey.getAt(world, x, y, z - 1)).equals(this.block) && world.func_147439_a(x, y, z - 1).func_149646_a(world, x - 1, y, z - 1, 0)) break;
                ico = this.icons[1];
                v5.func_78374_a(-o, 0.0, 1.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                v5.func_78374_a(-o, 1.0, 1.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                v5.func_78374_a(-o, 1.0, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                v5.func_78374_a(-o, 0.0, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                break;
            }
            case NORTH: {
                IIcon ico;
                BlockKey bk = BlockKey.getAt(world, x, y + 1, z);
                if (!bk.equals(this.block) || !world.func_147439_a(x, y + 1, z).func_149646_a(world, x, y + 1, z - 1, 0)) {
                    ico = this.icons[2];
                    v5.func_78374_a(0.0, 0.0, -o, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                    v5.func_78374_a(0.0, 1.0, -o, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0, 1.0, -o, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0, 0.0, -o, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                }
                if (!(bk = BlockKey.getAt(world, x, y - 1, z)).equals(this.block) || !world.func_147439_a(x, y - 1, z).func_149646_a(world, x, y - 1, z - 1, 0)) {
                    ico = this.icons[0];
                    v5.func_78374_a(0.0, 0.0, -o, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                    v5.func_78374_a(0.0, 1.0, -o, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0, 1.0, -o, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0, 0.0, -o, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                }
                if (!(bk = BlockKey.getAt(world, x + 1, y, z)).equals(this.block) || !world.func_147439_a(x + 1, y, z).func_149646_a(world, x + 1, y, z - 1, 0)) {
                    ico = this.icons[3];
                    v5.func_78374_a(0.0, 0.0, -o, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                    v5.func_78374_a(0.0, 1.0, -o, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(1.0, 1.0, -o, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0, 0.0, -o, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                }
                if ((bk = BlockKey.getAt(world, x - 1, y, z)).equals(this.block) && world.func_147439_a(x - 1, y, z).func_149646_a(world, x - 1, y, z - 1, 0)) break;
                ico = this.icons[1];
                v5.func_78374_a(0.0, 0.0, -o, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                v5.func_78374_a(0.0, 1.0, -o, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                v5.func_78374_a(1.0, 1.0, -o, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                v5.func_78374_a(1.0, 0.0, -o, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                break;
            }
            case SOUTH: {
                IIcon ico;
                BlockKey bk = BlockKey.getAt(world, x, y + 1, z);
                if (!bk.equals(this.block) || !world.func_147439_a(x, y + 1, z).func_149646_a(world, x, y + 1, z + 1, 0)) {
                    ico = this.icons[2];
                    v5.func_78374_a(1.0, 0.0, 1.0 + o, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0, 1.0, 1.0 + o, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(0.0, 1.0, 1.0 + o, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(0.0, 0.0, 1.0 + o, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                }
                if (!(bk = BlockKey.getAt(world, x, y - 1, z)).equals(this.block) || !world.func_147439_a(x, y - 1, z).func_149646_a(world, x, y - 1, z + 1, 0)) {
                    ico = this.icons[0];
                    v5.func_78374_a(1.0, 0.0, 1.0 + o, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0, 1.0, 1.0 + o, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(0.0, 1.0, 1.0 + o, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(0.0, 0.0, 1.0 + o, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                }
                if (!(bk = BlockKey.getAt(world, x + 1, y, z)).equals(this.block) || !world.func_147439_a(x + 1, y, z).func_149646_a(world, x + 1, y, z + 1, 0)) {
                    ico = this.icons[3];
                    v5.func_78374_a(1.0, 0.0, 1.0 + o, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                    v5.func_78374_a(1.0, 1.0, 1.0 + o, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                    v5.func_78374_a(0.0, 1.0, 1.0 + o, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                    v5.func_78374_a(0.0, 0.0, 1.0 + o, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                }
                if ((bk = BlockKey.getAt(world, x - 1, y, z)).equals(this.block) && world.func_147439_a(x - 1, y, z).func_149646_a(world, x - 1, y, z + 1, 0)) break;
                ico = this.icons[1];
                v5.func_78374_a(1.0, 0.0, 1.0 + o, (double)ico.func_94209_e(), (double)ico.func_94210_h());
                v5.func_78374_a(1.0, 1.0, 1.0 + o, (double)ico.func_94212_f(), (double)ico.func_94210_h());
                v5.func_78374_a(0.0, 1.0, 1.0 + o, (double)ico.func_94212_f(), (double)ico.func_94206_g());
                v5.func_78374_a(0.0, 0.0, 1.0 + o, (double)ico.func_94209_e(), (double)ico.func_94206_g());
                break;
            }
        }
        if (draw) {
            v5.func_78381_a();
        }
    }
}

