/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import java.util.Random;

public class LobulatedCurve {
    public final double amplitudeVariation;
    public final int degree;
    public final double angleStep;
    public final double minRadius;
    private static final Random delegateRand = new Random();
    private final double[] radii;

    public LobulatedCurve(double r, double a, int d) {
        this(r, a, d, 0.25);
    }

    public LobulatedCurve(double r, double a, int d, double da) {
        this.minRadius = r;
        this.amplitudeVariation = a;
        this.degree = d;
        this.angleStep = da;
        if ((double)this.degree * this.amplitudeVariation >= this.minRadius) {
            throw new IllegalArgumentException("Radius variation larger than base radius!");
        }
        this.radii = new double[(int)(360.0 / da)];
    }

    public static LobulatedCurve fromMinMaxRadii(double min, double max, int d) {
        double diff = (max - min) / 2.0;
        return new LobulatedCurve(min + diff, diff / (double)d, d);
    }

    public LobulatedCurve generate() {
        return this.generate(delegateRand);
    }

    public LobulatedCurve generate(Random rand) {
        double[] amps = new double[this.degree];
        for (int i = 0; i < this.degree; ++i) {
            amps[i] = rand.nextDouble() * this.amplitudeVariation;
        }
        double phase = rand.nextDouble() * 360.0;
        for (int i = 0; i < this.radii.length; ++i) {
            double theta = (double)i * this.angleStep;
            double r = this.minRadius;
            for (int k = 0; k < this.degree; ++k) {
                r += amps[k] * Math.sin(Math.toRadians(phase + (double)k * theta));
            }
            this.radii[i] = r;
        }
        return this;
    }

    public double getRadius(double ang) {
        double didx = (ang % 360.0 + 360.0) % 360.0 / this.angleStep;
        int idx = (int)didx;
        return ReikaMathLibrary.linterpolate(didx, idx, idx + 1, this.radii[idx], this.radii[(idx + 1) % this.radii.length]);
    }

    public boolean isPointInsideCurve(double x, double z) {
        double[] arr = ReikaPhysicsHelper.cartesianToPolar(x, 0.0, z);
        double ang = arr[2];
        if ((ang %= 360.0) < 0.0) {
            ang += 360.0;
        }
        return arr[0] <= this.getRadius(ang = ReikaMathLibrary.roundToNearestFraction(ang, this.angleStep));
    }
}

