/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.IO.DirectResourceManager;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class SoundLoader {
    private Collection<SoundEnum> soundList;

    public SoundLoader(Collection<SoundEnum> sounds) {
        this.soundList = new ArrayList<SoundEnum>(sounds);
    }

    public SoundLoader(SoundEnum ... sounds) {
        this.soundList = ReikaJavaLibrary.makeListFrom(sounds);
    }

    public void register() {
        for (SoundEnum e : this.soundList) {
            DirectResourceManager.getInstance().registerCustomPath(e.getPath(), e.getCategory(), false);
            if (!e.preload()) continue;
            try {
                DirectResourceManager.getInstance().func_110536_a(DirectResourceManager.getResource(e.getPath()));
            }
            catch (IOException ex) {
                DragonAPICore.logError("Caught error when preloading sound '" + e + "':");
                ex.printStackTrace();
            }
        }
    }
}

