/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.GUI;

import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class PianoKeyboard
extends Gui {
    public final int guiX;
    public final int guiY;
    private final MusicGui guiInstance;
    private final ArrayList<PianoKey> keyList = new ArrayList();
    private static final KeyShape[] shapeList = new KeyShape[]{KeyShape.LEFT, KeyShape.BLACK, KeyShape.MIDDLE, KeyShape.BLACK, KeyShape.MIDDLE, KeyShape.BLACK, KeyShape.RIGHT, KeyShape.LEFT, KeyShape.BLACK, KeyShape.MIDDLE, KeyShape.BLACK, KeyShape.RIGHT};

    public PianoKeyboard(int x, int y, MusicGui gui) {
        this.guiX = x;
        this.guiY = y;
        this.guiInstance = gui;
        int dx = 6;
        for (int m = 0; m < 4; ++m) {
            int id;
            int i;
            for (i = 0; i <= 4; i += 2) {
                id = i + 1 + m * 12;
                this.keyList.add(new PianoKey(id, x + dx + i * 4, y + 1, this.getShapeFromIndex(id), this.guiInstance));
            }
            dx += 32;
            for (i = 0; i <= 2; i += 2) {
                id = i + 8 + m * 12;
                this.keyList.add(new PianoKey(id, x + dx + i * 4, y + 1, this.getShapeFromIndex(id), this.guiInstance));
            }
            dx += 24;
        }
        for (int i = 0; i <= 56; i += 2) {
            int id = i;
            if (id >= 8) {
                --id;
            }
            if (id >= 13) {
                --id;
            }
            if (id >= 20) {
                --id;
            }
            if (id >= 25) {
                --id;
            }
            if (id >= 32) {
                --id;
            }
            if (id >= 37) {
                --id;
            }
            if (id >= 44) {
                --id;
            }
            if (id >= 49) {
                --id;
            }
            this.keyList.add(new PianoKey(id, x + i * 4, y + 1, this.getShapeFromIndex(id), this.guiInstance));
        }
    }

    private KeyShape getShapeFromIndex(int i) {
        if (i == 48) {
            return KeyShape.WHITE;
        }
        return shapeList[i % shapeList.length];
    }

    public void mouseClicked(int x, int y, int button) {
        for (int i = 0; i < this.keyList.size(); ++i) {
            PianoKey key = this.keyList.get(i);
            if (!key.func_146116_c(Minecraft.func_71410_x(), x, y)) continue;
            this.guiInstance.onKeyPressed(key);
            return;
        }
    }

    public void drawKeys() {
        this.guiInstance.bindKeyboardTexture();
        this.func_73729_b(this.guiX, this.guiY, 0, 64, 232, 37);
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glEnable((int)3042);
        for (int i = 0; i < this.keyList.size(); ++i) {
            PianoKey key = this.keyList.get(i);
            key.func_146112_a(mc, 0, 0);
        }
        GL11.glDisable((int)3042);
        mc.field_71466_p.func_78276_b("F", this.guiX - 6, this.guiY + 28, 0);
        mc.field_71466_p.func_78276_b("F", this.guiX + 233, this.guiY + 28, 0);
    }

    public static interface MusicGui {
        public int getActiveChannel();

        public void bindKeyboardTexture();

        public void onKeyPressed(PianoKey var1);

        public int getColorForChannel(int var1);
    }

    private static enum KeyShape {
        WHITE,
        BLACK,
        LEFT,
        RIGHT,
        MIDDLE;

    }

    public static class PianoKey
    extends GuiButton {
        public final KeyShape hitbox;
        private int alpha = 0;
        private final MusicGui guiInstance;

        public PianoKey(int note, int x, int y, KeyShape shape, MusicGui gui) {
            super(note, x, y, 0, 0, "");
            this.hitbox = shape;
            this.guiInstance = gui;
        }

        public void func_146112_a(Minecraft mc, int x, int y) {
            int c = this.guiInstance.getColorForChannel(this.guiInstance.getActiveChannel());
            int rgb = c & 0xFFFFFF | this.alpha << 24;
            if (this.alpha > 0) {
                switch (this.hitbox) {
                    case BLACK: {
                        PianoKey.func_73734_a((int)(this.field_146128_h + 1), (int)(this.field_146129_i + 1), (int)(this.field_146128_h + 3), (int)(this.field_146129_i + 20), (int)rgb);
                        break;
                    }
                    case LEFT: {
                        PianoKey.func_73734_a((int)(this.field_146128_h + 1), (int)this.field_146129_i, (int)(this.field_146128_h + 6), (int)(this.field_146129_i + 35), (int)rgb);
                        PianoKey.func_73734_a((int)(this.field_146128_h + 6), (int)(this.field_146129_i + 21), (int)(this.field_146128_h + 7), (int)(this.field_146129_i + 35), (int)rgb);
                        break;
                    }
                    case MIDDLE: {
                        PianoKey.func_73734_a((int)(this.field_146128_h + 2), (int)this.field_146129_i, (int)(this.field_146128_h + 6), (int)(this.field_146129_i + 21), (int)rgb);
                        PianoKey.func_73734_a((int)(this.field_146128_h + 1), (int)(this.field_146129_i + 21), (int)(this.field_146128_h + 7), (int)(this.field_146129_i + 35), (int)rgb);
                        break;
                    }
                    case RIGHT: {
                        PianoKey.func_73734_a((int)(this.field_146128_h + 2), (int)this.field_146129_i, (int)(this.field_146128_h + 7), (int)(this.field_146129_i + 35), (int)rgb);
                        PianoKey.func_73734_a((int)(this.field_146128_h + 1), (int)(this.field_146129_i + 21), (int)(this.field_146128_h + 2), (int)(this.field_146129_i + 35), (int)rgb);
                        break;
                    }
                    case WHITE: {
                        PianoKey.func_73734_a((int)(this.field_146128_h + 1), (int)this.field_146129_i, (int)(this.field_146128_h + 7), (int)(this.field_146129_i + 35), (int)rgb);
                        break;
                    }
                }
                --this.alpha;
            }
        }

        public boolean func_146116_c(Minecraft mc, int x, int y) {
            ReikaGuiAPI api = ReikaGuiAPI.instance;
            boolean flag = false;
            switch (this.hitbox) {
                case BLACK: {
                    if (!api.isMouseInBox(this.field_146128_h, this.field_146128_h + 4, this.field_146129_i, this.field_146129_i + 21)) break;
                    flag = true;
                    break;
                }
                case LEFT: {
                    if (api.isMouseInBox(this.field_146128_h + 1, this.field_146128_h + 6, this.field_146129_i, this.field_146129_i + 35)) {
                        flag = true;
                    }
                    if (!api.isMouseInBox(this.field_146128_h + 5, this.field_146128_h + 7, this.field_146129_i + 21, this.field_146129_i + 35)) break;
                    flag = true;
                    break;
                }
                case MIDDLE: {
                    if (api.isMouseInBox(this.field_146128_h + 2, this.field_146128_h + 6, this.field_146129_i, this.field_146129_i + 35)) {
                        flag = true;
                    }
                    if (!api.isMouseInBox(this.field_146128_h + 1, this.field_146128_h + 7, this.field_146129_i + 21, this.field_146129_i + 35)) break;
                    flag = true;
                    break;
                }
                case RIGHT: {
                    if (api.isMouseInBox(this.field_146128_h + 2, this.field_146128_h + 7, this.field_146129_i, this.field_146129_i + 35)) {
                        flag = true;
                    }
                    if (!api.isMouseInBox(this.field_146128_h + 1, this.field_146128_h + 7, this.field_146129_i + 21, this.field_146129_i + 35)) break;
                    flag = true;
                    break;
                }
                case WHITE: {
                    if (!api.isMouseInBox(this.field_146128_h + 1, this.field_146128_h + 7, this.field_146129_i, this.field_146129_i + 35)) break;
                    flag = true;
                    break;
                }
            }
            if (flag) {
                this.alpha = 255;
            }
            return flag;
        }
    }
}

