/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Formula;

import Reika.DragonAPI.Instantiable.Formula.MathExpression;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;

public class LogarithmExpression
extends MathExpression {
    public final double baseVal;
    public final double scale;
    public final double logBase;

    public LogarithmExpression(double init, double scale, double base) {
        this.baseVal = init;
        this.scale = scale;
        this.logBase = base;
    }

    @Override
    public final double evaluate(double arg) throws ArithmeticException {
        return this.baseVal + this.scale * ReikaMathLibrary.logbase(arg + 1.0, this.logBase);
    }

    @Override
    public final double getBaseValue() {
        return this.baseVal;
    }

    @Override
    public final String toString() {
        return this.baseVal + (this.scale > 0.0 ? "+" : "-") + Math.abs(this.scale) + "*log_" + this.logBase + "(x+1)";
    }
}

