/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event.Client;

import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;

public class WaterColorEvent
extends Event {
    public final int originalColor;
    public int color;
    public final IBlockAccess world;
    public final int x;
    public final int y;
    public final int z;

    public WaterColorEvent(IBlockAccess iba, int x, int y, int z, int c) {
        this.color = this.originalColor = c;
        this.world = iba;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BiomeGenBase getBiome() {
        return this.world.func_72807_a(this.x, this.z);
    }

    public int getLightLevel() {
        return this.world.func_72802_i(this.x, this.y, this.z, 0);
    }

    public static int fire(IBlockAccess iba, int x, int y, int z) {
        WaterColorEvent evt = new WaterColorEvent(iba, x, y, z, WaterColorEvent.calcDefault(iba, x, y, z));
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.color;
    }

    private static int calcDefault(IBlockAccess iba, int x, int y, int z) {
        int sumR = 0;
        int sumG = 0;
        int sumB = 0;
        int r = 1;
        for (int k = -r; k <= r; ++k) {
            for (int i = -r; i <= r; ++i) {
                int c = iba.func_72807_a(x + i, z + k).getWaterColorMultiplier();
                sumR += ReikaColorAPI.getRed(c);
                sumG += ReikaColorAPI.getGreen(c);
                sumB += ReikaColorAPI.getBlue(c);
            }
        }
        return (sumR / 9 & 0xFF) << 16 | (sumG / 9 & 0xFF) << 8 | sumB / 9 & 0xFF;
    }
}

