/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ValueSortedMap<K, V extends Comparable> {
    private final HashMap<K, V> raw = new HashMap();
    private final TreeMap<K, V> data = new TreeMap(new ValueComparator());

    public ValueSortedMap() {
    }

    public ValueSortedMap(Map<K, V> data) {
        this();
        this.putAll(data);
    }

    public int size() {
        return this.raw.size();
    }

    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.raw.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.raw.containsValue(value);
    }

    public V get(K key) {
        return (V)((Comparable)this.raw.get(key));
    }

    public V put(K key, V value) {
        Comparable ret = (Comparable)this.raw.put(key, value);
        this.rebuildData();
        return (V)ret;
    }

    public V remove(K key) {
        Comparable ret = (Comparable)this.raw.remove(key);
        this.rebuildData();
        return (V)ret;
    }

    public void putAll(Map<K, V> m) {
        this.raw.putAll(m);
        this.rebuildData();
    }

    private void rebuildData() {
        this.data.clear();
        this.data.putAll(this.raw);
    }

    public void clear() {
        this.raw.clear();
        this.data.clear();
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.data.values());
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.data.entrySet());
    }

    public K getFirstKey() {
        return this.isEmpty() ? null : (K)this.data.firstEntry().getKey();
    }

    public V getFirst() {
        return (V)(this.isEmpty() ? null : (Comparable)this.data.firstEntry().getValue());
    }

    public String toString() {
        return this.raw.toString();
    }

    private class ValueComparator
    implements Comparator<K> {
        private ValueComparator() {
        }

        @Override
        public int compare(K o1, K o2) {
            return ((Comparable)ValueSortedMap.this.raw.get(o1)).compareTo(ValueSortedMap.this.raw.get(o2));
        }
    }
}

