/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CountMap<V> {
    private final HashMap<V, Integer> data = new HashMap();
    private int total;

    public void increment(V key) {
        this.increment(key, 1);
    }

    public void increment(V key, int num) {
        Integer get = this.data.get(key);
        int has = get != null ? get : 0;
        int next = has + num;
        this.set(key, next);
        this.total += num;
    }

    public void set(V key, int num) {
        if (num != 0) {
            this.data.put((Integer)key, num);
        } else {
            this.data.remove(key);
        }
    }

    public int remove(V key) {
        Integer amt = this.data.remove(key);
        if (amt == null) {
            amt = 0;
        }
        this.total -= amt.intValue();
        return amt;
    }

    public int get(V key) {
        Integer get = this.data.get(key);
        return get != null ? get : 0;
    }

    public int size() {
        return this.data.size();
    }

    public int getTotalCount() {
        return this.total;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof CountMap && ((CountMap)o).data.equals(this.data);
    }

    public String toString() {
        return this.data.toString();
    }

    public Set<V> keySet() {
        return this.data.keySet();
    }

    public boolean containsKey(V key) {
        return this.data.containsKey(key);
    }

    public void clear() {
        this.data.clear();
    }

    public WeightedRandom<V> asWeightedRandom() {
        WeightedRandom<V> w = new WeightedRandom<V>();
        for (V key : this.data.keySet()) {
            w.addEntry(key, this.get(key));
        }
        return w;
    }

    public double getFraction(V k) {
        if (this.total == 0) {
            return 0.0;
        }
        return (double)this.get(k) / (double)this.getTotalCount();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void readFromNBT(NBTTagCompound tag, ReikaNBTHelper.NBTIO<V> converter) {
        this.total = tag.func_74762_e("total");
        this.data.clear();
        NBTTagList li = tag.func_150295_c("data", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound dat = (NBTTagCompound)o;
            V key = converter.createFromNBT(dat.func_74781_a("key"));
            int amt = dat.func_74762_e("value");
            this.data.put((Integer)key, amt);
        }
    }

    public void writeToNBT(NBTTagCompound tag, ReikaNBTHelper.NBTIO<V> converter) {
        tag.func_74768_a("total", this.total);
        NBTTagList li = new NBTTagList();
        for (V k : this.data.keySet()) {
            NBTTagCompound dat = new NBTTagCompound();
            int amt = this.data.get(k);
            dat.func_74782_a("key", converter.convertToNBT(k));
            dat.func_74768_a("value", amt);
            li.func_74742_a((NBTBase)dat);
        }
        tag.func_74782_a("data", (NBTBase)li);
    }
}

