/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Collections;

import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class FastPlayerCache {
    private final HashSet<UUID> data = new HashSet();

    public Collection<UUID> getPlayers() {
        return Collections.unmodifiableSet(this.data);
    }

    public boolean removePlayer(UUID uid) {
        return uid != null && this.data.remove(uid);
    }

    public boolean removePlayer(EntityPlayer ep) {
        return this.removePlayer(ep.func_110124_au());
    }

    public boolean addPlayer(UUID uid) {
        return uid != null && this.data.add(uid);
    }

    public boolean addPlayer(EntityPlayer ep) {
        return this.addPlayer(ep.func_110124_au());
    }

    public boolean containsPlayer(UUID uid) {
        return uid != null && this.data.contains(uid);
    }

    public boolean containsPlayer(EntityPlayer ep) {
        return this.containsPlayer(ep.func_110124_au());
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList li = new NBTTagList();
        for (UUID uid : this.data) {
            NBTTagString dat = new NBTTagString(uid.toString());
            li.func_74742_a((NBTBase)dat);
        }
        tag.func_74782_a("data", (NBTBase)li);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.data.clear();
        NBTTagList li = tag.func_150295_c("data", ReikaNBTHelper.NBTTypes.STRING.ID);
        for (Object o : li.field_74747_a) {
            NBTTagString dat = (NBTTagString)o;
            UUID uid = UUID.fromString(dat.func_150285_a_());
            if (uid == null) continue;
            this.data.add(uid);
        }
    }

    public void clear() {
        this.data.clear();
    }
}

