/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Random;

public final class ColumnArray {
    private static final Random rand = new Random();
    private final ArrayList<Coordinate> coords = new ArrayList();
    private final HashSet<Coordinate> set = new HashSet();

    public boolean add(int x, int z) {
        if (this.hasColumn(x, z)) {
            return false;
        }
        this.coords.add(new Coordinate(x, 0, z));
        return true;
    }

    public boolean hasColumn(int x, int z) {
        return this.set.contains(new Coordinate(x, 0, z));
    }

    public void remove(int index) {
        this.coords.remove(index);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty[]";
        }
        StringBuilder list = new StringBuilder();
        for (Coordinate c : this.coords) {
            list.append(c);
            list.append(";");
        }
        return list.toString();
    }

    public int getSize() {
        return this.coords.size();
    }

    public boolean isEmpty() {
        return this.coords.isEmpty();
    }

    public void clear() {
        this.coords.clear();
    }

    public Coordinate getNthColumn(int n) {
        if (this.isEmpty()) {
            return null;
        }
        return this.coords.get(n);
    }

    public Coordinate getNextColumn() {
        if (this.isEmpty()) {
            return null;
        }
        return this.coords.get(0);
    }

    public Coordinate getNextAndMoveOn() {
        if (this.isEmpty()) {
            return null;
        }
        Coordinate next = this.getNextColumn();
        this.coords.remove(0);
        return next;
    }

    public Coordinate getRandomColumn() {
        int s = this.getSize();
        return this.getNthColumn(rand.nextInt(s));
    }

    public void sort(Comparator<Coordinate> c) {
        Collections.sort(this.coords, c);
    }
}

